/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.util.Log;

public class Hash
extends DataStructureImpl {
    private static final Log _log = new Log(class$net$i2p$data$Hash == null ? (class$net$i2p$data$Hash = Hash.class$("net.i2p.data.Hash")) : class$net$i2p$data$Hash);
    private byte[] _data;
    private volatile String _stringified;
    private volatile String _base64ed;
    private Map _xorCache;
    public static final int HASH_LENGTH = 32;
    public static final Hash FAKE_HASH = new Hash(new byte[32]);
    private static final int MAX_CACHED_XOR = 1024;
    static /* synthetic */ Class class$net$i2p$data$Hash;

    public Hash() {
        this.setData(null);
    }

    public Hash(byte[] data) {
        this.setData(data);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
        this._stringified = null;
        this._base64ed = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCache() {
        Hash hash = this;
        synchronized (hash) {
            if (this._xorCache == null) {
                this._xorCache = new HashMap(1024);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] cachedXor(Hash key) throws IllegalStateException {
        if (this._xorCache == null) {
            throw new IllegalStateException("To use the cache, you must first prepare it");
        }
        byte[] distance = (byte[])this._xorCache.get(key);
        if (distance == null) {
            int cached = 0;
            Map map = this._xorCache;
            synchronized (map) {
                int toRemove = this._xorCache.size() + 1 - 1024;
                if (toRemove > 0) {
                    HashSet<Object> keys = new HashSet<Object>(toRemove);
                    Iterator<Object> iter = this._xorCache.keySet().iterator();
                    for (int removed = 0; iter.hasNext() && removed < toRemove; ++removed) {
                        keys.add(iter.next());
                    }
                    iter = keys.iterator();
                    while (iter.hasNext()) {
                        this._xorCache.remove(iter.next());
                    }
                }
                distance = DataHelper.xor(key.getData(), this.getData());
                this._xorCache.put(key, distance);
                cached = this._xorCache.size();
            }
            if (_log.shouldLog(10)) {
                StringBuffer buf = new StringBuffer(128);
                buf.append("miss [").append(cached).append("] from ");
                buf.append(DataHelper.toHexString(this.getData())).append(" to ");
                buf.append(DataHelper.toHexString(key.getData()));
                _log.debug(buf.toString(), new Exception());
            }
        } else if (_log.shouldLog(10)) {
            StringBuffer buf = new StringBuffer(128);
            buf.append("hit from ");
            buf.append(DataHelper.toHexString(this.getData())).append(" to ");
            buf.append(DataHelper.toHexString(key.getData()));
            _log.debug(buf.toString());
        }
        return distance;
    }

    public void clearXorCache() {
        this._xorCache = null;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._data = new byte[32];
        this._stringified = null;
        this._base64ed = null;
        int read = this.read(in, this._data);
        if (read != 32) {
            throw new DataFormatException("Not enough bytes to read the hash");
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data in the hash to write out");
        }
        if (this._data.length != 32) {
            throw new DataFormatException("Invalid size of data in the private key");
        }
        out.write(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Hash)) {
            return false;
        }
        return DataHelper.eq(this._data, ((Hash)obj)._data);
    }

    public int hashCode() {
        return DataHelper.hashCode(this._data);
    }

    public String toString() {
        if (this._stringified == null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("[Hash: ");
            if (this._data == null) {
                buf.append("null hash");
            } else {
                buf.append(this.toBase64());
            }
            buf.append("]");
            this._stringified = buf.toString();
        }
        return this._stringified;
    }

    public String toBase64() {
        if (this._base64ed == null) {
            this._base64ed = super.toBase64();
        }
        return this._base64ed;
    }

    public static void main(String[] args) {
        Hash.testFill();
        Hash.testOverflow();
        Hash.testFillCheck();
    }

    private static void testFill() {
        Hash local = new Hash(new byte[32]);
        local.prepareCache();
        for (int i = 0; i < 1024; ++i) {
            byte[] t = new byte[32];
            for (int j = 0; j < 32; ++j) {
                t[j] = (byte)(i >> j & 0xFF);
            }
            Hash cur = new Hash(t);
            local.cachedXor(cur);
            if (local._xorCache.size() == i + 1) continue;
            _log.error("xor cache size where i=" + i + " isn't correct!  size = " + local._xorCache.size());
            return;
        }
        _log.debug("Fill test passed");
    }

    private static void testOverflow() {
        Hash local = new Hash(new byte[32]);
        local.prepareCache();
        for (int i = 0; i < 2048; ++i) {
            byte[] t = new byte[32];
            for (int j = 0; j < 32; ++j) {
                t[j] = (byte)(i >> j & 0xFF);
            }
            Hash cur = new Hash(t);
            local.cachedXor(cur);
            if (i < 1024) {
                if (local._xorCache.size() == i + 1) continue;
                _log.error("xor cache size where i=" + i + " isn't correct!  size = " + local._xorCache.size());
                return;
            }
            if (local._xorCache.size() <= 1024) continue;
            _log.error("xor cache size where i=" + i + " isn't correct!  size = " + local._xorCache.size());
            return;
        }
        _log.debug("overflow test passed");
    }

    private static void testFillCheck() {
        Hash cur;
        byte[] t;
        HashSet<Hash> hashes = new HashSet<Hash>();
        Hash local = new Hash(new byte[32]);
        local.prepareCache();
        for (int i = 0; i < 1024; ++i) {
            t = new byte[32];
            for (int j = 0; j < 32; ++j) {
                t[j] = (byte)(i >> j & 0xFF);
            }
            cur = new Hash(t);
            hashes.add(cur);
            local.cachedXor(cur);
            if (local._xorCache.size() == i + 1) continue;
            _log.error("xor cache size where i=" + i + " isn't correct!  size = " + local._xorCache.size());
            return;
        }
        Iterator iter = hashes.iterator();
        while (iter.hasNext()) {
            Hash cur2 = (Hash)iter.next();
            if (local._xorCache.containsKey(cur2)) continue;
            _log.error("checking the cache, we dont have " + DataHelper.toHexString(cur2.getData()));
            return;
        }
        for (int i = 0; i < 1024; ++i) {
            t = new byte[32];
            for (int j = 0; j < 32; ++j) {
                t[j] = (byte)(i >> j & 0xFF);
            }
            cur = new Hash(t);
            if (local._xorCache.containsKey(cur)) continue;
            _log.error("checking the cache, we do NOT have " + DataHelper.toHexString(cur.getData()));
            return;
        }
        _log.debug("Fill check test passed");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

