/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;

public class Destination
extends DataStructureImpl {
    private static final Log _log = new Log(class$net$i2p$data$Destination == null ? (class$net$i2p$data$Destination = Destination.class$("net.i2p.data.Destination")) : class$net$i2p$data$Destination);
    private Certificate _certificate;
    private SigningPublicKey _signingKey;
    private PublicKey _publicKey;
    private Hash __calculatedHash;
    static /* synthetic */ Class class$net$i2p$data$Destination;

    public Destination() {
        this.setCertificate(null);
        this.setSigningPublicKey(null);
        this.setPublicKey(null);
        this.__calculatedHash = null;
    }

    public Destination(String s) throws DataFormatException {
        this();
        this.fromBase64(s);
    }

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setCertificate(Certificate cert) {
        this._certificate = cert;
        this.__calculatedHash = null;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public void setPublicKey(PublicKey key) {
        this._publicKey = key;
        this.__calculatedHash = null;
    }

    public SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    public void setSigningPublicKey(SigningPublicKey key) {
        this._signingKey = key;
        this.__calculatedHash = null;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._publicKey = new PublicKey();
        this._publicKey.readBytes(in);
        this._signingKey = new SigningPublicKey();
        this._signingKey.readBytes(in);
        this._certificate = new Certificate();
        this._certificate.readBytes(in);
        this.__calculatedHash = null;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._certificate == null || this._publicKey == null || this._signingKey == null) {
            throw new DataFormatException("Not enough data to format the destination");
        }
        this._publicKey.writeBytes(out);
        this._signingKey.writeBytes(out);
        this._certificate.writeBytes(out);
    }

    public int writeBytes(byte[] target, int offset) {
        int cur = offset;
        System.arraycopy(this._publicKey.getData(), 0, target, cur, 256);
        System.arraycopy(this._signingKey.getData(), 0, target, cur += 256, 128);
        cur += 128;
        cur += this._certificate.writeBytes(target, cur);
        return cur - offset;
    }

    public int readBytes(byte[] source, int offset) throws DataFormatException {
        if (source == null) {
            throw new DataFormatException("Null source");
        }
        if (source.length <= offset + 256 + 128) {
            throw new DataFormatException("Not enough data (len=" + source.length + " off=" + offset + ")");
        }
        int cur = offset;
        this._publicKey = new PublicKey();
        byte[] buf = new byte[256];
        System.arraycopy(source, cur, buf, 0, 256);
        this._publicKey.setData(buf);
        this._signingKey = new SigningPublicKey();
        buf = new byte[128];
        System.arraycopy(source, cur += 256, buf, 0, 128);
        this._signingKey.setData(buf);
        cur += 128;
        this._certificate = new Certificate();
        cur += this._certificate.readBytes(source, cur);
        return cur - offset;
    }

    public int size() {
        return 384 + this._certificate.size();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Destination)) {
            return false;
        }
        Destination dst = (Destination)object;
        return DataHelper.eq(this.getCertificate(), dst.getCertificate()) && DataHelper.eq(this.getSigningPublicKey(), dst.getSigningPublicKey()) && DataHelper.eq(this.getPublicKey(), dst.getPublicKey());
    }

    public int hashCode() {
        return DataHelper.hashCode(this.getCertificate()) + DataHelper.hashCode(this.getSigningPublicKey()) + DataHelper.hashCode(this.getPublicKey());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("[Destination: ");
        buf.append("\n\tHash: ").append(this.calculateHash().toBase64());
        buf.append("\n\tPublic Key: ").append(this.getPublicKey());
        buf.append("\n\tSigning Public Key: ").append(this.getSigningPublicKey());
        buf.append("\n\tCertificate: ").append(this.getCertificate());
        buf.append("]");
        return buf.toString();
    }

    public Hash calculateHash() {
        if (this.__calculatedHash == null) {
            this.__calculatedHash = super.calculateHash();
        }
        return this.__calculatedHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        FileInputStream in;
        if (args.length == 0) {
            System.err.println("Usage: Destination filename");
            return;
        } else {
            in = null;
            in = new FileInputStream(args[0]);
            Destination d = new Destination();
            d.readBytes(in);
            System.out.println(d.toBase64());
            Object var4_4 = null;
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException ioe) {}
        }
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var4_5 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

