using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using i2p_connection;
using I2P_Messenger.Forms;

namespace I2P_Messenger.Forms
{

  
    public partial class form_Main : Form
    {
        // Event handler fr verbindung zwischen Gui und Core
        public delegate void StatusReceivedHandler(Status Status);
        public delegate void UserStatusChangedHandler();
        public delegate void ErrorMessageFromCoreHandler(string Message);
        public delegate void MessageFromCoreHandler(string Message);
        public delegate void AllUserDetailsRecivedHandler(string Destination);
        public delegate void RequestAuthorizationHandler(string Destination, string ID, Core cCore);

        //--------------------------------------------------------
        
        // callbacks fr Thread sicher zugriff
            delegate void dataGridView1_callback(DataGridViewRow newRow);
            delegate void dataGridView1_clear_callback();
            delegate void set_zwischenablageText(string text);
            delegate void onAllUserDetailsRecivedHandler_callback(string Destination);
            delegate void RequestAuthorizationHandler_callback(string Destination, string ID, Core cCore);

            delegate void datagrid1_addRow_callback();
            delegate void datagrid1_removeRow_callback();
            delegate void set_onlineStatuseVisible_callback(bool visible);
        //-----------------------------------------------------
      
        // Genutze Klassen
            private i2p_connection_Class cI2P;
            private LogManager cLogManager;
            private Core cCore;

        //----------------------------------------------------

        //fenster Variablen
            private LogWindow logwindows;
            private configWindow configwindow;
            private ManuellConnectWindow manuellconnectwindow;
            private ConfigWindow2 configwindows2;
            private ChangeNickname changeNickname;
           
        //----------------------------------------------------

        
        private Settings MySettings;

        public form_Main()
        {
            InitializeComponent();
            init();
        }
        
        private void init()
        {
            MySettings = new Settings();

            SessionStyle Style = new SessionStyle();
            Style = SessionStyle.STREAM;

            Direction Direktion = new Direction();
            Direktion = Direction.BOTH;
           
            cI2P = new i2p_connection_Class(MySettings.CONNECTION.SamHost, MySettings.CONNECTION.SamPort, MySettings.CONNECTION.allTunnelOptions);
            cLogManager = new LogManager(cI2P);

            if (cCore == null)
            {   //Neuer Core erzeugen
                cCore = new Core(cI2P, MySettings);
                cCore.UserStatusChanged += new Core.UserStatusChangedHandler(OnUserStatuschanged);
                cCore.ErrorMessageFromCore += new Core.ErrorMessageFromCoreHandler(OnErrorMessageFromCore);
                cCore.AllUserDetailsRecived += new Core.AllUserDetailsRecivedHandler(onAllUserDetailsRecivedHandler);
                cCore.OnlineStatusChanged += new Core.OnlineStatusChangedHandler(onOnlineStatusChangedClient);
                cCore.MessageFromCore += new Core.MessageFromCoreHandler(OnMessageFromCore);
                cCore.RequestAuthorization += new Core.RequestAuthorizationHandler(onRequestAuthorization);

                cCore.init_sound();
                cCore.start_core();
            }
            else
                //alter Core restarten
                cCore.restartCore(cI2P, MySettings);

            if (cI2P.init() == 0)
            {
                cI2P.Create_Session(Style, MySettings.CONNECTION.SamDestination, Direktion);
            }
        }

        public void onRequestAuthorization(string Destination, string ID, Core cCore)
        {
            openRequestAuthorizationWindows(Destination, ID, cCore);
        }

        public void OnErrorMessageFromCore(string Message)
        {
            MessageBox.Show(Message, "Core", MessageBoxButtons.OK,MessageBoxIcon.Error);
        }

        public void OnMessageFromCore(string Message)
        {
            MessageBox.Show(Message, "Core", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            try
            {
                manuellconnectwindow.Show();
                manuellconnectwindow.Focus();
            }
            catch
            {
                manuellconnectwindow = new ManuellConnectWindow(cCore);
                manuellconnectwindow.Show();
                manuellconnectwindow.Focus();
            }
        }

        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            try
            {
                configwindow.Show();
                configwindow.Focus();
            }
            catch
            {
                configwindow = new configWindow();
                configwindow.Show();
                configwindow.Focus();
            }
        }

        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            if (cCore.get_ClientOnlineStatus()!=Core.enum_OnlineStatus.OFFLINE)
            {
                set_zwischenablageText set_zwischenablageText_delegate = new set_zwischenablageText(OnSet_zwischenablageText);
                this.Invoke(set_zwischenablageText_delegate, cCore.get_myDestination());
                MessageBox.Show("Destination is copyed into the clipboard !!!");

            }
            else
                MessageBox.Show("You must be online to do this");
        }

        public void OnSet_zwischenablageText(string text)
        {
            Clipboard.SetText(text);
        }


        public void onOnlineStatusChangedClient()
        {

            Core.enum_OnlineStatus Status = cCore.get_ClientOnlineStatus();
          
            switch (Status)
            {
                    
                case Core.enum_OnlineStatus.TRY_TO_COONNECT:
                    toolStripOnlineStatus.Image = Properties.Resources.yellow;
                    toolStripOnlineStatus.Text = "Try to connect";
                    break;

                case Core.enum_OnlineStatus.OFFLINE:
                    toolStripOnlineStatus.Image = Properties.Resources.offline;
                    toolStripOnlineStatus.Text = "Offline";
                    /*
                    wantToChatToolStripMenuItem.Visible = false;
                    toolStripMenuItemDontDisturb.Visible = false;
                    invisibleToolStripMenuItem.Visible = false;
                    shortAwayToolStripMenuItem.Visible=false;
                    */
                    Onset_onlineStatuseVisible(false);

                    break;
                
                case Core.enum_OnlineStatus.ONLINE:
                    cI2P.Naming_Lookup("ME");//eigene destination abfragen
                    toolStripOnlineStatus.Image = Properties.Resources.online;
                    toolStripOnlineStatus.Text = "Online";
                    
                    /*
                    wantToChatToolStripMenuItem.Visible = true;
                    toolStripMenuItemDontDisturb.Visible = true;
                    invisibleToolStripMenuItem.Visible = true;
                    shortAwayToolStripMenuItem.Visible = true;
                    */
                    Onset_onlineStatuseVisible(true);
                    break;

                case Core.enum_OnlineStatus.DONT_DISTURB:
                    toolStripOnlineStatus.Image = Properties.Resources.dont_disturb;
                    toolStripOnlineStatus.Text = "don't disturb";
                    break;

                case Core.enum_OnlineStatus.LIKE_TO_CHAT:
                    toolStripOnlineStatus.Image = Properties.Resources.like_to_chat;
                    toolStripOnlineStatus.Text = "like to chat";
                    break;
                
                case Core.enum_OnlineStatus.INVISIBLE:
                    toolStripOnlineStatus.Image = Properties.Resources.invisible;
                    toolStripOnlineStatus.Text = "invisible";
                    break;

                case Core.enum_OnlineStatus.SHORT_AWAY:
                    toolStripOnlineStatus.Image = Properties.Resources.short_away;
                    toolStripOnlineStatus.Text = "short away";
                    break;

            }
        
        }
     
        private void datagrid1_removeLastRow()
        {
            if (this.dataGridView1.InvokeRequired)
            {
                datagrid1_removeRow_callback d = new datagrid1_removeRow_callback(datagrid1_removeLastRow);
                this.Invoke(d, new object[] { });
            }
            else
                this.dataGridView1.Rows.RemoveAt(dataGridView1.Rows.Count - 1);

        }

        private void openRequestAuthorizationWindows(string Destination, string ID, Core cCore)
        {
          
            if (this.InvokeRequired)
            {
                RequestAuthorizationHandler_callback d = new RequestAuthorizationHandler_callback(openRequestAuthorizationWindows);
                this.Invoke(d, new object[] {Destination,ID,cCore });
            }
            else
            {
                RequestAuthorizationWindow t = new RequestAuthorizationWindow(Destination, ID, cCore);
                t.Show();
                t.Focus();
            }
        }

        
        public void Onset_onlineStatuseVisible(bool visible)
        {
            if (this.InvokeRequired)
            {
                set_onlineStatuseVisible_callback d = new set_onlineStatuseVisible_callback(Onset_onlineStatuseVisible);
                this.Invoke(d, new object[] { visible });
            }
            else
            {
                if (visible == true)
                {
                    wantToChatToolStripMenuItem.Visible = true;
                    toolStripMenuItemDontDisturb.Visible = true;
                    invisibleToolStripMenuItem.Visible = true;
                    shortAwayToolStripMenuItem.Visible = true;
                }
                else
                {
                    wantToChatToolStripMenuItem.Visible = false;
                    toolStripMenuItemDontDisturb.Visible = false;
                    invisibleToolStripMenuItem.Visible = false;
                    shortAwayToolStripMenuItem.Visible = false;
                }
            }
        }

        private void openUserDetailsWindows(string Destination)
        {
            if (cCore.functions_forUsers.have_allreadyOneUserDetailWindow(Destination) == true) return;

            if (this.InvokeRequired)
            {
                onAllUserDetailsRecivedHandler_callback d = new onAllUserDetailsRecivedHandler_callback(openUserDetailsWindows);
                this.Invoke(d, new object[] { Destination });
            }
            else
            {
                UserDetailsWindow t = new UserDetailsWindow(cCore, Destination);
                t.Show();
                t.Focus();
            }
        }

        public void onAllUserDetailsRecivedHandler(string Destination)
        {
            openUserDetailsWindows(Destination);
        }

        private void datagrid1_addRow()
        {
            if (this.dataGridView1.InvokeRequired)
            {
                datagrid1_addRow_callback d = new datagrid1_addRow_callback(datagrid1_addRow);
                this.Invoke(d, new object[] { });
            }
            else
                dataGridView1.Rows.Add();
        }
      
        public void set_dataGridView1(DataGridViewRow newRow)
        {
            try
            {
                if (this.dataGridView1.InvokeRequired)
                {
                    dataGridView1_callback d = new dataGridView1_callback(set_dataGridView1);
                    this.Invoke(d, new object[] { newRow });
                }
                else
                    dataGridView1.Rows.Add(newRow);
            }
            catch
            {
            }

        }

        
        public void set_dataGridView1_clear()
        {
            if (this.dataGridView1.InvokeRequired)
            {
                dataGridView1_clear_callback d = new dataGridView1_clear_callback(set_dataGridView1_clear);
                this.Invoke(d,new object[] {});
            }
            else
                dataGridView1.Rows.Clear();

        }
       

        private void form_Main_FormClosing(object sender, FormClosingEventArgs e)
        {

            if (cCore != null)
            {
                cCore.UserStatusChanged -= new Core.UserStatusChangedHandler(OnUserStatuschanged);
                cCore.ErrorMessageFromCore -= new Core.ErrorMessageFromCoreHandler(OnErrorMessageFromCore);
                cCore.AllUserDetailsRecived -= new Core.AllUserDetailsRecivedHandler(onAllUserDetailsRecivedHandler);
                cCore.OnlineStatusChanged -= new Core.OnlineStatusChangedHandler(onOnlineStatusChangedClient);
                cCore.MessageFromCore -= new Core.MessageFromCoreHandler(OnMessageFromCore);
                cCore.RequestAuthorization -= new Core.RequestAuthorizationHandler(onRequestAuthorization);
                cCore.closeCore();
            }
            
            if (cI2P != null)
                cI2P.unload();

            MySettings = null;
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
          try
          {
              logwindows.Show();
              logwindows.Focus();
          }
          catch
          {
              logwindows = new LogWindow(cLogManager);
              logwindows.Show();
              logwindows.Focus();
          }
           
        }
        
        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
                        
        }

        private void dataGridView1_SelectionChanged(object sender, EventArgs e)
        {
           
        }

        private void toolStripMenuItem_RemoveUser_Click(object sender, EventArgs e)
        {
            string Destination;
            string ID;

            ID=get_selectedUserID();

            if (ID.Length > 0)
                cI2P.Stream_close(ID);

            Destination = get_selectedUserDestination();
            if(Destination.Length>0)
                cCore.functions_forUsers.removeUserByDestination(Destination);
        }

     
        private string get_selectedUserID()
        {
            DataGridViewCell downloadCell;
            DataGridViewRow downloadRow;
            string ID="";

            try
            {
                if (dataGridView1.CurrentRow != null)
                {
                    int CurrentRow = dataGridView1.CurrentRow.Index;

                    downloadCell = new DataGridViewTextBoxCell();
                    downloadRow = dataGridView1.Rows[CurrentRow];

                    downloadCell = downloadRow.Cells["ID"];
                    ID = downloadCell.Value.ToString();
                }
            }
            catch
            {
            }
            return ID;
        }
        
        private string get_selectedUserDestination()
        {
            DataGridViewCell downloadCell;
            DataGridViewRow downloadRow;
            string Destination = "";

            if (dataGridView1.CurrentRow != null)
            {
                int CurrentRow = dataGridView1.CurrentRow.Index;

                downloadCell = new DataGridViewTextBoxCell();
                downloadRow = dataGridView1.Rows[CurrentRow];

                downloadCell = downloadRow.Cells["Destination"];
                Destination = downloadCell.Value.ToString();
            }
            return Destination;
        }

        private string get_selectedUserNickname()
        {
            DataGridViewCell downloadCell;
            DataGridViewRow downloadRow;
            string Nickname = "";

            if (dataGridView1.CurrentRow != null)
            {
                int CurrentRow = dataGridView1.CurrentRow.Index;

                downloadCell = new DataGridViewTextBoxCell();
                downloadRow = dataGridView1.Rows[CurrentRow];

                downloadCell = downloadRow.Cells["Nickname"];
                Nickname = downloadCell.Value.ToString();
            }
            return Nickname;
        }


        private void ToolStripMenuItem_changeNickname_Click(object sender, EventArgs e)
        {
            try
            {
                changeNickname.Show();
            }
            catch
            {
                changeNickname = new ChangeNickname(cCore, get_selectedUserDestination());
                changeNickname.Show();
            }

        }

        private void dataGridView1_CellMouseDown(object sender, DataGridViewCellMouseEventArgs e)
        {
            string Destination = "";

            if (e.Button == MouseButtons.Right)
            {
                if (dataGridView1.SelectedRows.Count > 0)
                {
                    if (dataGridView1.SelectedRows.Count == 1)
                    {
                        toolStripMenuItem_RemoveUser.Enabled = true;
                        ToolStripMenuItem_changeNickname.Enabled = true;

                        if (cCore.functions_forUsers.get_UserStatusByDestination(get_selectedUserDestination())
                            == usereintrag.userStatus.YOU_WERE_BLOCKED)
                            toolStripMenuItem_block_options.Visible = false;
                        else
                            toolStripMenuItem_block_options.Visible = true;


                        toolStripMenuItem_block_options.Enabled = true;
                        ToolStripMenu_block_thisUser.Visible = true;
                    }
                    else
                    {
                        toolStripMenuItem_RemoveUser.Enabled = false;
                       // toolStripMenuItem_block_options.Enabled = false;
                       // ToolStripMenu_block_thisUser.Visible = false;
                        
                    }
                }
                else
                {
                   // ToolStripMenu_block_thisUser.Visible = false;
                }

                Destination = get_selectedUserDestination();
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_Destination() == Destination)
                    {
                        ToolStripMenuItem_changeNickname.Enabled = true;

                        if (eintrag.get_aktStatus() == usereintrag.userStatus.DISCONNECTED || eintrag.get_aktStatus() == usereintrag.userStatus.CANT_REACH ||
                            eintrag.get_aktStatus() == usereintrag.userStatus.YOU_WERE_BLOCKED || eintrag.get_aktStatus() == usereintrag.userStatus.TRY_TO_CONNECT)
                        {
                                ToolStripMenuItem_get_UserDetails.Enabled = false;
                        }
                            
                        else if (eintrag.get_aktStatus() == usereintrag.userStatus.YOU_BLOCKED_HIM)
                        {
                            ThisUserToolStripMenu_block_thisUser.Enabled = false;
                            ToolStripMenuItem_unblockThisuser.Enabled = true;
                        }
                        else
                        {
                            if (eintrag.get_aktStatus() == usereintrag.userStatus.INVISIBLE)
                                ToolStripMenuItem_get_UserDetails.Enabled = false;
                            else
                                ToolStripMenuItem_get_UserDetails.Enabled = true;

                            ThisUserToolStripMenu_block_thisUser.Enabled = true;
                        }
                    }
                }
            }

        }

        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            try
            {
                configwindows2.Show();
                configwindows2.Focus();
            }
            catch
            {
                configwindows2 = new ConfigWindow2(MySettings);
                configwindows2.Show();
                configwindows2.Focus();
            }
  
        }

        public void OnUserStatuschanged()
        {
            DataGridViewRow downloadRow;

            //zu wenige rows (neue Rows hinzufgen)
            while (dataGridView1.Rows.Count < cCore.users.Count)
                datagrid1_addRow();

            //zu viele rows (vorhandene entfernen)
            while (dataGridView1.Rows.Count > cCore.users.Count)
                datagrid1_removeLastRow();


            for (int i = 0; i < cCore.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)cCore.users[i];

                    downloadRow = dataGridView1.Rows[i];
                    downloadRow.Cells["ID"].Value = eintrag.get_id();
                    
                    //alle bilder setzen
                    if (eintrag.get_aktStatus() == usereintrag.userStatus.CANT_REACH)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.offline;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.CONNECTED)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.online;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.DISCONNECTED)
                    {

                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.offline;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.TRY_TO_CONNECT)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.offline;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.YOU_WERE_BLOCKED)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.blocked;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.YOU_BLOCKED_HIM)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.blocked;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.DONT_DISTURB)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.dont_disturb;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.LIKE_TO_CHAT)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.like_to_chat;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.INVISIBLE)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.offline;
                    }
                    else if (eintrag.get_aktStatus() == usereintrag.userStatus.SHORT_AWAY)
                    {
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.short_away;
                    }

                    if (eintrag.get_newUnreadMessage() == true)
                        downloadRow.Cells["Status"].Value = I2P_Messenger.Properties.Resources.mail;

                    //-------------------------------
                    downloadRow.Cells["Nickname"].Value = eintrag.get_Nickname();
                    downloadRow.Cells["Destination"].Value = eintrag.get_Destination();


              

            }

        }
       
        private void toolStripDropDownButton1_Click(object sender, EventArgs e)
        {

        }
        private void toolStripMenuItemOffline_Click(object sender, EventArgs e)
        {
            if (cCore.get_ClientOnlineStatus()==Core.enum_OnlineStatus.OFFLINE)
                return;
            else
            {

                if (cCore != null)
                {
                    cCore.stopCore();
                    //set_dataGridView1_clear();
                }
                
                if (cI2P != null)
                {
                    cI2P.unload();
                    cI2P = null;
                }
            }
                toolStripOnlineStatus.Image = Properties.Resources.offline;
                toolStripOnlineStatus.Text = "Offline";
        }

        private void toolStripMenuItemOnline_Click(object sender, EventArgs e)
        {
            if (cCore.get_ClientOnlineStatus() != Core.enum_OnlineStatus.OFFLINE  )
            {
                cCore.set_clientOnlineStatus(Core.enum_OnlineStatus.ONLINE);
                return;
            }
            else
                init();
        }

        private void dataGridView1_DoubleClick(object sender, MouseEventArgs e)
        {
            string Destination = get_selectedUserDestination();
            if (Destination != null && Destination != "" )
            {
                if (cCore.have_allreadyOneChatwindow(Destination) == false)
                {
                    ChatWindow t = new ChatWindow(Destination, cCore);
                    cCore.set_have_allreadyOneChatwindow(true, Destination);
                    t.Show();
                    t.Focus();
                    OnUserStatuschanged();
                }
                else
                    MessageBox.Show("Only one Chatwindow pro User !");
            }
            
        }

        private void getUserdetailsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string Destination;
            string ID;

            Destination = get_selectedUserDestination();
            ID = cCore.functions_forUsers.get_ID_byDestination(Destination);

            if (cCore.functions_forUsers.have_allreadyOneUserDetailWindow(Destination) == false)
                cCore.Protocol.send(ID, "", Protocol.ProtocoTags.cUserDetails.enumCommands.get_allUserdetails);
            else
                MessageBox.Show("Only one Userdetailwindow pro User !");
        }

        private void ThisUserToolStripMenu_block_thisUser_Click(object sender, EventArgs e)
        {
            string destination = get_selectedUserDestination();
            cCore.functions_forUsers.block_userByDestination(destination);
        }

        private void ToolStripMenuItem_unblockThisuser_Click(object sender, EventArgs e)
        {
            string destination=get_selectedUserDestination();
            cCore.functions_forUsers.set_userStatusByDestination(destination, usereintrag.userStatus.DISCONNECTED);
        }

        private void toolStripMenuItemDontDisturb_Click(object sender, EventArgs e)
        {
            cCore.set_clientOnlineStatus(Core.enum_OnlineStatus.DONT_DISTURB);          
        }

        private void wantToChatToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cCore.set_clientOnlineStatus(Core.enum_OnlineStatus.LIKE_TO_CHAT);

        }

        private void invisibleToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cCore.set_clientOnlineStatus(Core.enum_OnlineStatus.INVISIBLE);
        }

        private void shortAwayToolStripMenuItem_Click(object sender, EventArgs e)
        {
            cCore.set_clientOnlineStatus(Core.enum_OnlineStatus.SHORT_AWAY);
        }

        private void toolStripMenuItem_Chat_Click(object sender, EventArgs e)
        {
            dataGridView1_DoubleClick(null, null);
        }

    }
}