using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace I2P_Messenger.Forms
{
    public partial class UserDetailsWindow : Form
    {
        private Core cCore;
        private string Destination;

        public UserDetailsWindow(Core cCore,string Destination)
        {
            InitializeComponent();
            this.cCore = cCore;
            this.Destination = Destination;
            cCore.functions_forUsers.set_haveallreadyOneUserDetailWindow(true, Destination);
            init();
            
        }

        private void init()
        {
            text_nickname.Text=cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.UserNickname);
            text_age.Text = cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.UserAge);
            text_interests.Text = cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.UserInterests);
            rtf_other_informations.Text = cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.UserOtherInformation);
            text_Destination.Text = Destination;
            label_clientName.Text = cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.ClientName);
            label_clientVersion.Text = cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.ClientVersion);
            label_protocolversion.Text = cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.ProcolVersion);


            if (cCore.functions_forUsers.get_userDetail(Destination, usereintrag.UserDetails.UserGender) == "Female")
            {
                check_female.Checked = true;
                check_male.Checked = false;
            }
            else
            {
                check_male.Checked = true;
                check_female.Checked = false;
            }
        }

        private void UserDetailsWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            cCore.functions_forUsers.set_haveallreadyOneUserDetailWindow(false, Destination);
        }
    }
}