using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace I2P_Messenger.Forms
{
    public partial class Setting_Sound : UserControl
    {
        public Setting_Sound()
        {
            InitializeComponent();
            init();
        }
        private void init()
        {
            I2P_Messenger.Properties.Sound mySettings = new I2P_Messenger.Properties.Sound();
            if (mySettings.Activate_userList_sounds == true)
            {
                checkBox1.Checked = true;
                text_onlineSoundFile.Text = mySettings.User_go_OnlineSoundFile;
                text_OfflineSoundFile.Text = mySettings.User_go_OfflineSoundFile;
            }
            else
                checkBox1.Checked = false;


            if (mySettings.Activate_newMessageSound == true)
            {
                checkBox2.Checked = true;
                text_newMessageSoundFile.Text = mySettings.NewMessageSoundFile;
            }
            else
                checkBox2.Checked = false;

            if (mySettings.Activate_startSound == true)
            {
                checkBox3.Checked = true;
                text_startSoundFile.Text = mySettings.StartSoundFile;
            }
            else
                checkBox3.Checked = false;

        }
        public bool save_sound_settings()
        {
            if (allSettingsAreSet() == true)
            {
                I2P_Messenger.Properties.Sound mySettings = new I2P_Messenger.Properties.Sound();
                if (checkBox1.Checked == true)
                    mySettings.Activate_userList_sounds=true;
                else
                    mySettings.Activate_userList_sounds=false;
            
                mySettings.User_go_OnlineSoundFile=text_onlineSoundFile.Text;
                mySettings.User_go_OfflineSoundFile=text_OfflineSoundFile.Text;

                if (checkBox2.Checked == true)
                    mySettings.Activate_newMessageSound = true;
                else
                    mySettings.Activate_newMessageSound = false;

                mySettings.NewMessageSoundFile = text_newMessageSoundFile.Text;

                if (checkBox3.Checked == true)
                    mySettings.Activate_startSound = true;
                else
                    mySettings.Activate_startSound = false;
                
                mySettings.StartSoundFile = text_startSoundFile.Text;

                mySettings.Save();
                return true;
            }
            return false;
            
        }

        private bool allSettingsAreSet()
        {
            if (checkBox1.Checked == true)
            {
                if(text_onlineSoundFile.Text.Length==0)
                {
                    MessageBox.Show("No Online SoundFile is selected");
                    return false;
                }
                if (text_OfflineSoundFile.Text.Length == 0)
                {
                    MessageBox.Show("No Offline SoundFile is selected");
                    return false;
                }
            }
            if (checkBox2.Checked == true)
            {
                if (text_newMessageSoundFile.Text.Length == 0)
                {
                    MessageBox.Show("No newMessage SoundFile is selected");
                    return false;
                }
            }
            if(checkBox3.Checked==true)
            {
                if (text_startSoundFile.Text.Length==0)
                {
                    MessageBox.Show("Start SoundFile is selected");
                    return false;
                }
            }
            return true;
        }


        private void pictureBox1_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked == false) return;
            
                OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "c:\\";
            openFileDialog1.Filter = "WAV files (*.wav)|*.wav";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
                text_onlineSoundFile.Text = openFileDialog1.FileName;
        }

        private void pictureBox2_Click(object sender, EventArgs e)
        {
            if (checkBox1.Checked == false) return;

            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "c:\\";
            openFileDialog1.Filter = "WAV files (*.wav)|*.wav";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
                text_OfflineSoundFile.Text = openFileDialog1.FileName;
        }

        private void pictureBox4_Click(object sender, EventArgs e)
        {
            if (checkBox3.Checked == false) return;

            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "c:\\";
            openFileDialog1.Filter = "WAV files (*.wav)|*.wav";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
                text_startSoundFile.Text = openFileDialog1.FileName;

        
        }

        private void pictureBox3_Click(object sender, EventArgs e)
        {
         

            if (checkBox2.Checked == false) return;

            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "c:\\";
            openFileDialog1.Filter = "WAV files (*.wav)|*.wav";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog(this) == DialogResult.OK)
                text_newMessageSoundFile.Text = openFileDialog1.FileName;
            
        }


    }
}
