using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace I2P_Messenger.Forms
{
    public partial class Setting_UserDetails : UserControl
    {
        public Setting_UserDetails()
        {
            InitializeComponent();
            init();
        }

        private void init()
        {
            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            text_nickname.Text = mySettings.UserNickname;
            numeric_age.Minimum = 0;
            numeric_age.Maximum = 125;
            numeric_age.Value = Convert.ToInt32(mySettings.UserAge);

            if(mySettings.UserGender.CompareTo("Female")==0)
            {
                check_female.Checked=true;
                check_male.Checked=false;
            }
            else
            {
                check_male.Checked=true;
                check_female.Checked=false;
            }
            text_interests.Text = mySettings.UserInterests;
            rtf_other_informations.Text = mySettings.UserOtherInformation;
        }

        public bool save_UserDetails()
        {
            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            mySettings.UserNickname = text_nickname.Text;
            mySettings.UserAge = Convert.ToString(numeric_age.Value);

            if (check_male.Checked == true)
                mySettings.UserGender = "Male";

            if (check_female.Checked == true)
                mySettings.UserGender = "Female";

            mySettings.UserInterests = text_interests.Text;
            mySettings.UserOtherInformation = rtf_other_informations.Text;
            mySettings.Save();
            return true;
        }


        private void label1_Click(object sender, EventArgs e)
        {

        }
        private void btnOK_Click(object sender, EventArgs e)
        {
        
        }

        private void check_male_CheckedChanged(object sender, EventArgs e)
        {

        }

        private void check_male_Click(object sender, EventArgs e)
        {
            if (check_male.Checked == true)
            {
                check_female.Checked = false;
            }
            else
            {
                check_female.Checked = true;
            }

        }

        private void check_female_Click(object sender, EventArgs e)
        {
            if (check_female.Checked == true)
                check_male.Checked = false;
            else
                check_male.Checked = true;
        }
    }
}
