using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace I2P_Messenger.Forms
{
    public partial class Setting_Connection : UserControl
    {
        public Setting_Connection()
        {

            InitializeComponent();
            init();
        }
        private void init()
        {
            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            text_smHostIP.Text = mySettings.SamHost;
            numericSamPort.Minimum = 1;
            numericSamPort.Maximum = 65535;
            numericSamPort.Value =Convert.ToInt32( mySettings.SamPort);
            text_Destination.Text = mySettings.Destination;

            string[] temp = mySettings.TunnelName.Split('=');
            text_tunnelName.Text = temp[1];

            numeric_inbound_depth.Minimum = 0;
            numeric_inbound_depth.Maximum = 3;

            temp =  mySettings.Tunnel_Inbound_Depth.Split('=');
            numeric_inbound_depth.Value = Convert.ToInt32(temp[1]);

            temp = mySettings.Tunnel_Outbound_Depth.Split('=');
            numeric_outbound_depth.Minimum = 0;
            numeric_outbound_depth.Maximum = 3;
            numeric_outbound_depth.Value = Convert.ToInt32(temp[1]);

            temp = mySettings.Tunnel_Inbound_Quantity.Split('=');
            numeric_inbound_quantity.Minimum = 1;
            numeric_inbound_quantity.Maximum = 3;
            numeric_inbound_quantity.Value = Convert.ToInt32(temp[1]);

            temp = mySettings.Tunnel_Outbound_Quantity.Split('=');
            numeric_outbound_quantity.Minimum = 1;
            numeric_outbound_quantity.Maximum = 3;
            numeric_outbound_quantity.Value = Convert.ToInt32(temp[1]);

            temp = mySettings.Tunnel_Inbound_BackupQuantity.Split('=');
            numeric_inbound_backupQuantity.Minimum = 0;
            numeric_inbound_backupQuantity.Maximum = 3;
            numeric_inbound_backupQuantity.Value = Convert.ToInt32(temp[1]);

            temp = mySettings.Tunnel_Outbound_BackupQuantity.Split('=');
            numeric_outbound_backupQuantity.Minimum = 0;
            numeric_outbound_backupQuantity.Maximum = 3;
            numeric_outbound_backupQuantity.Value = Convert.ToInt32(temp[1]);

            temp = mySettings.Tunnel_Inbound_AllowZeroHop.Split('=');
            if (temp[1].CompareTo("true") == 0)
                checkBox_inbound_allowzerohops.Checked = true;
            else
                checkBox_inbound_allowzerohops.Checked = false;

            
            temp = mySettings.Tunnel_Outbound_AllowZeroHop.Split('=');
            if (temp[1].CompareTo("true") == 0)
                checkBox_outound_allowzerohops.Checked = true;
            else
                checkBox_outound_allowzerohops.Checked = false;
        }
        public bool save_connectionSettings()
        {
            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            mySettings.SamHost = text_smHostIP.Text;
            mySettings.SamPort = Convert.ToString(numericSamPort.Value);
            mySettings.Destination = text_Destination.Text;
            mySettings.TunnelName = "inbound.nickname=" + text_tunnelName.Text;
            mySettings.Tunnel_Inbound_Depth = "inbound.length=" + Convert.ToString(numeric_inbound_depth.Value);
            mySettings.Tunnel_Outbound_Depth = "outbound.length=" + Convert.ToString(numeric_outbound_depth.Value);
            mySettings.Tunnel_Inbound_Quantity = "inbound.quantity=" + Convert.ToString(numeric_inbound_quantity.Value);
            mySettings.Tunnel_Outbound_Quantity = "outbound.quantity=" + Convert.ToString(numeric_outbound_quantity.Value);
            mySettings.Tunnel_Inbound_BackupQuantity = "inbound.backupQuantity=" + Convert.ToString(numeric_inbound_backupQuantity.Value);
            mySettings.Tunnel_Outbound_BackupQuantity = "outbound.backupQuantity=" + Convert.ToString(numeric_outbound_backupQuantity.Value);

            if (checkBox_inbound_allowzerohops.Checked == true)
                mySettings.Tunnel_Inbound_AllowZeroHop = "inbound.allowZeroHop=true";
            else
                mySettings.Tunnel_Inbound_AllowZeroHop = "inbound.allowZeroHop=false";


            if(checkBox_outound_allowzerohops.Checked==true)
                mySettings.Tunnel_Outbound_AllowZeroHop = "outbound.allowZeroHop=true";
            else
                mySettings.Tunnel_Outbound_AllowZeroHop = "outbound.allowZeroHop=false";

            mySettings.Save();
            return true;
        }

       

    }
}
