using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace I2P_Messenger.Forms
{
    public partial class ConfigWindow2 : Form
    {
        private Setting_Connection m_ConnectionCtrl;
        private Setting_UserDetails m_UserDetails;
        private Setting_General m_General;
        private Setting_Sound m_Sound;
        private Setting_Security m_security;

        private Settings cMySettings;


        /*
        private Settings_ConnectionCtrl m_ConnectionCtrl;
        private Settings_DirectoryControl m_DirectoryCtrl;
        private Settings_InterfaceCtrl m_InterfaceCtrl;
        private Settings_MiscControl m_MiscCtrl;
        */ 
        // ********* 1.) DECLARE YOUR NEW CONTROL WINDOW HERE (SEE EXAMPLES ABOVE) *********//



                
        private class mySettingMenuItem
        {
            // *** Attribute ***
            private string m_Description = "";
            private System.Drawing.Image m_Image = null;
            private byte m_ID = 0;

            // *** Properties ***
            public string Description
            {
                set { m_Description = value;}
                get { return m_Description; }
            } //public string Description()

            public System.Drawing.Image SettingImage
            {
                set { m_Image = value; }
                get { return m_Image; }
            } //public System.Drawing.Image SettingImage

            public byte ID
            {
                set
                {
                    if (value < 255)
                        m_ID = value;
                    else
                        m_ID = 1;
                }
                get { return m_ID; }
            }

        } //private class mySettingMenuItem


        public ConfigWindow2(Settings mysetting)
        {
            //RShare.MainForm.SetUILanguage();
            InitializeComponent();
          
            InitNavigationGrid();

            cMySettings = mysetting;
            m_ConnectionCtrl = new Setting_Connection();
            m_UserDetails = new Setting_UserDetails();
            m_General = new Setting_General();
            m_Sound = new Setting_Sound();
            m_security = new Setting_Security();
            //m_DirectoryCtrl = new Settings_DirectoryControl(this.btnApply);
            //m_InterfaceCtrl = new Settings_InterfaceCtrl(this.btnApply);
            //m_MiscCtrl = new Settings_MiscControl(this.btnApply);
            // ********* 2.) OPEN YOUR NEW CONTROL WINDOW HERE (SEE EXAMPLES ABOVE) *********//




            /*
            if (toolStripContainer.ContentPanel.Controls.Count == 0 || (toolStripContainer.ContentPanel.Controls.Count > 0 && !(toolStripContainer.ContentPanel.Controls[0] is Settings_ConnectionCtrl)))
            {
                toolStripContainer.ContentPanel.Controls.Clear();
                toolStripContainer.ContentPanel.Controls.Add(m_ConnectionCtrl);
                m_ConnectionCtrl.Focus();
            }
             */
    
        }


        private void InitNavigationGrid()
        {
            // Defining the Columns
            NavigationDataGridview.Columns.Add("ColSetIcon", "");
            NavigationDataGridview.Columns["ColSetIcon"].Width = 17;

            NavigationDataGridview.Columns.Add("ColSetText", "");
            NavigationDataGridview.Columns["ColSetText"].Width = 100;

            // The invisible cell "ColSetID" is an _unique_ Identifier for each Setting-Screen
            NavigationDataGridview.Columns.Add("ColSetID", "");
            NavigationDataGridview.Columns["ColSetID"].Width = 0;
            NavigationDataGridview.Columns["ColSetID"].Visible = false;

            System.Collections.ArrayList mySettingList = new System.Collections.ArrayList();

            mySettingMenuItem myItem = new mySettingMenuItem();

            // *** Adding "General" (ID: 101) to navigation ***
            myItem = new mySettingMenuItem();
            myItem.Description = "General";
            myItem.SettingImage = Properties.Resources.command;
            myItem.ID = 101;
            mySettingList.Add(myItem);

            // *** Adding "Connections" (ID: 102) to navigation ***
            myItem = new mySettingMenuItem();
            myItem.Description = "Connection";
            myItem.SettingImage = Properties.Resources.Tools;
            myItem.ID = 102;
            mySettingList.Add(myItem);
            
            // *** Adding "UserDetails" (ID: 103) to navigation ***
            myItem = new mySettingMenuItem();
            myItem.Description = "User Datails";
            myItem.SettingImage = Properties.Resources.self;
            myItem.ID = 103;
            mySettingList.Add(myItem);
            
            // *** Adding "Sound" (ID: 104) to navigation ***
            myItem = new mySettingMenuItem();
            myItem.Description = "Sound";
            myItem.SettingImage = Properties.Resources.play;
            myItem.ID = 104;
            mySettingList.Add(myItem);

            // *** Adding "Security" (ID: 104) to navigation ***
            myItem = new mySettingMenuItem();
            myItem.Description = "Security";
            myItem.SettingImage = Properties.Resources.ssl_yes;
            myItem.ID = 105;
            mySettingList.Add(myItem);

           
            // ********* 3.) ADD THE NAVIGATION ITEM HERE (NEXT FREE ID IS 105) - SEE EXAMPLES ABOVE//



            DataGridViewRow settingsRow;
            DataGridViewCell settingsCell;

            for (int i = 0; i < mySettingList.Count; i++)
            {
                settingsRow = new DataGridViewRow();
                settingsRow.Height = 17;

                settingsCell = new DataGridViewImageCell();
                settingsRow.Cells.Add(settingsCell);
                settingsCell.Value = ((mySettingMenuItem)mySettingList[i]).SettingImage;

                settingsCell = new DataGridViewTextBoxCell();
                settingsRow.Cells.Add(settingsCell);
                settingsCell.Value = ((mySettingMenuItem)mySettingList[i]).Description;
                settingsCell.Tag = ((mySettingMenuItem)mySettingList[i]).Description;

                settingsCell = new DataGridViewTextBoxCell();
                settingsRow.Cells.Add(settingsCell);
                settingsCell.Value = ((mySettingMenuItem)mySettingList[i]).ID.ToString();

                NavigationDataGridview.Rows.Add(settingsRow);

            } //for (int i = 0; i < mySettingList.Count; i++)

        } //private void InitNavigationGrid()

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void SettingsDialog_FormClosed(object sender, FormClosedEventArgs e)
        {
            Dispose();
        }

        
        private void NavigationDataGridview_SelectionChanged(object sender, EventArgs e)
        {
            if (NavigationDataGridview.SelectedRows.Count == 1)
            {
                byte SelectedNavID = Convert.ToByte(NavigationDataGridview.CurrentRow.Cells["ColSetID"].Value);

                switch (SelectedNavID)
                {
                    case 101://General
                        if (toolStripContainer.ContentPanel.Controls.Count == 0 || (toolStripContainer.ContentPanel.Controls.Count > 0 && !(toolStripContainer.ContentPanel.Controls[0] is Setting_General)))
                        {
                            toolStripContainer.ContentPanel.Controls.Clear();
                            toolStripContainer.ContentPanel.Controls.Add(m_General);
                            m_General.Focus();
                        }
                        break;
                    case 102: //ConnectionCtrl
                        if (toolStripContainer.ContentPanel.Controls.Count == 0 || (toolStripContainer.ContentPanel.Controls.Count > 0 && !(toolStripContainer.ContentPanel.Controls[0] is Setting_Connection)))
                        {
                            toolStripContainer.ContentPanel.Controls.Clear();
                            toolStripContainer.ContentPanel.Controls.Add(m_ConnectionCtrl);
                            m_ConnectionCtrl.Focus();
                        }
                        break;
                    
                    case 103: //UserDetails
                        if (toolStripContainer.ContentPanel.Controls.Count == 0 || (toolStripContainer.ContentPanel.Controls.Count > 0 && !(toolStripContainer.ContentPanel.Controls[0] is Setting_UserDetails)))
                        {
                            toolStripContainer.ContentPanel.Controls.Clear();
                            toolStripContainer.ContentPanel.Controls.Add(m_UserDetails);
                            m_UserDetails.Focus();
                        }
                        break;
                        
                    case 104://Sound
                        if (toolStripContainer.ContentPanel.Controls.Count == 0 || (toolStripContainer.ContentPanel.Controls.Count > 0 && !(toolStripContainer.ContentPanel.Controls[0] is Setting_Sound)))
                        {
                            toolStripContainer.ContentPanel.Controls.Clear();
                            toolStripContainer.ContentPanel.Controls.Add(m_Sound);
                            m_Sound.Focus();
                        }
                        break;
                    
                    case 105://Security
                        if (toolStripContainer.ContentPanel.Controls.Count == 0 || (toolStripContainer.ContentPanel.Controls.Count > 0 && !(toolStripContainer.ContentPanel.Controls[0] is Setting_Security)))
                        {
                            toolStripContainer.ContentPanel.Controls.Clear();
                            toolStripContainer.ContentPanel.Controls.Add(m_security);
                            m_security.Focus();
                        }
                        break;
                     

                    // ********* 4.) ADD AN CASE WITH THE ID (SEE 3.) OF YOUR NAVIGATION ITEM AND OPEN YOUR CONTROL *********//


                    
                    default:
                        break;
                }
                


            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            bool allOK = false;

            allOK = m_ConnectionCtrl.save_connectionSettings();
            if (allOK == false)
            {
                MessageBox.Show ("Cant save settings, check if they are correct");
                return;
            }

            allOK = m_UserDetails.save_UserDetails();
            if (allOK == false)
            {
                MessageBox.Show ("Cant save settings, check if they are correct");
                return;
            }
            
            allOK=m_General.save_Setting_General();
            if (allOK == false)
            {
                MessageBox.Show ("Cant save settings, check if they are correct");
                return;
            }
            
            allOK=m_Sound.save_sound_settings();
            if (allOK == false)
            {
                MessageBox.Show ("Cant save settings, check if they are correct");
                return;
            }


            allOK = m_security.save_Security_Setting();
            if (allOK == false)
            {
                MessageBox.Show("Cant save settings, check if they are correct");
                return;
            }
            
            cMySettings.reInit();
            Close();
        }
        

    }
}