using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace I2P_Messenger.Forms
{
    public partial class RequestAuthorizationWindow : Form
    {
        string ID;
        string Destination;
        Core cCore;
        bool allowToCloseWindows;

        public RequestAuthorizationWindow(string Destination,string ID,Core cCore)
        {
            InitializeComponent();
            this.ID = ID;
            this.Destination = Destination;
            this.cCore = cCore;
            allowToCloseWindows = false;
        }

        private void cmd_ok_Click(object sender, EventArgs e)
        {
            if (radioButton1.Checked == true)
            {//accept
                if (textBox1.Text.Length > 0)
                {
                    usereintrag NeuerEintrag = new usereintrag(textBox1.Text, Destination);
                    NeuerEintrag.set_ID(ID);
                    NeuerEintrag.set_Status(usereintrag.userStatus.CONNECTED);
                    cCore.functions_forUsers.add_user(NeuerEintrag);
                    cCore.call_UserStatusChanged();
                    allowToCloseWindows = true;
                    Close();
                }
                else
                    MessageBox.Show("Sorry you must enter a Nickname !!!");
            }
            else if (radioButton2.Checked == true)
            {//don't accept but add to contact list
                if (textBox1.Text.Length > 0)
                {
                    usereintrag NeuerEintrag = new usereintrag(textBox1.Text, Destination);
                    NeuerEintrag.set_Status(usereintrag.userStatus.YOU_BLOCKED_HIM);
                    cCore.functions_forUsers.add_user(NeuerEintrag);
                    cCore.call_UserStatusChanged();

                    cCore.Protocol.send(ID, "User dont't accept your request, you were blocked !!!", Protocol.ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM);
                    cCore.closeStreamByID(ID);
                    allowToCloseWindows = true;
                    Close();
                }
                else
                    MessageBox.Show("Sorry you must enter a Nickname !!!");

            }
            else if (radioButton3.Checked == true)
            {
                //don't accept and don't add to contact list
                cCore.Protocol.send(ID, "User dont't accept your request, you were blocked !!!", Protocol.ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM);
                cCore.closeStreamByID(ID);
                allowToCloseWindows = true;
                Close();

            }
        }

        private void cmd_abbruch_Click(object sender, EventArgs e)
        {/*
            cCore.Protocol.send(ID, "User dont't accept your request, you were blocked !!!", Protocol.ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM);
            cCore.closeStreamByID(ID);
            Close();
         */
        }

        private void RequestAuthorizationWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (allowToCloseWindows == false)
            {
                e.Cancel = true;
            }
        }
    }
}