using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace I2P_Messenger.Forms
{
    public partial class configWindow : Form
    {
        public configWindow()
        {
            InitializeComponent();

            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            
            text_smHostIP.Text = mySettings.SamHost;
            text_samPort.Text = mySettings.SamPort;
            text_Destination.Text = mySettings.Destination;
            numericUpDown1.Value = mySettings.MaxLogMessages;
        }


        private void cmd_ok_Click(object sender, EventArgs e)
        {
            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();

            if (text_Destination.Text.CompareTo(mySettings.Destination) != 0)
            {
               DialogResult result;
               result = MessageBox.Show("When your Destination Changend you get a new Identity. After you must Restart I2P_Messenger for get a effect !!!", "Info", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning);
               if (result ==DialogResult.Cancel)
                   return;
            }
 
            
            mySettings.SamHost =text_smHostIP.Text;
            mySettings.SamPort = text_samPort.Text;
            mySettings.Destination = text_Destination.Text;
            mySettings.MaxLogMessages = Convert.ToInt32(numericUpDown1.Value);
            mySettings.Save();
            Close();
        }

        private void cmd_abbrechen_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void configWindow_Load(object sender, EventArgs e)
        {

        }
    }
}