using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;


using i2p_connection;

namespace I2P_Messenger.Forms
{
    public partial class ChatWindow : Form
    {
        public delegate void UserStatusChangedHandler();
        public delegate void newMessageRecivedHandler();

        delegate void rtf_chat_callback(usereintrag.struct_message message);
        delegate void rtf_chat_clear_callback();
        delegate void set_form_text_callback(string text);
        delegate void set_rtf_chat_ScrollToCaret_callback();

        delegate void rtf_send_clear_callback();

        private Core cCore;
        private Protocol cProtocol;
        private string Destination;
        private bool ready_toChat;
        private bool is_cloosing;

        public ChatWindow(string Destination, Core cCore)
        {
            InitializeComponent();
            this.cCore = cCore;
            this.cProtocol = cProtocol = cCore.Protocol;
            this.Destination = Destination;
            ready_toChat = false;
            cmd_send.Enabled = false;
            is_cloosing=false;

            cCore.UserStatusChanged += new Core.UserStatusChangedHandler(OnUserStatuschanged);

            for (int i = 0; i < cCore.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)cCore.users[i];
                if (eintrag.get_Destination() == Destination)
                {
                    eintrag.set_newUnreadMessage(false);
                    eintrag.newMessageRecived += new usereintrag.newMessageRecivedHandler(onNewMessageRecived);

                    if (eintrag.get_chat_RTF_color() != null && eintrag.get_chat_RTF_Font() != null)
                    {
                        rtf_send.ForeColor = eintrag.get_chat_RTF_color();
                        rtf_send.Font = eintrag.get_chat_RTF_Font();
                    }

                    cCore.users[i] = eintrag;

                    showallMessages();
                    OnUserStatuschanged();
                    break;
                }
            
            }


        }

        public void OnUserStatuschanged()
        {
            foreach (usereintrag eintrag in cCore.users)
            {
                if (eintrag.get_Destination() == Destination)
                {
                    usereintrag.userStatus t = eintrag.get_aktStatus();

                    switch (t)
                    {
                        case usereintrag.userStatus.CONNECTED:
                            set_form_text(eintrag.get_Nickname() + "( Online )");
                            ready_toChat = true;
                            break;

                        case usereintrag.userStatus.YOU_WERE_BLOCKED:
                            set_form_text(eintrag.get_Nickname() + "( You were blocked )");
                            ready_toChat = false;
                            break;

                        case usereintrag.userStatus.LIKE_TO_CHAT:
                            set_form_text(eintrag.get_Nickname() + "( User want to Chat )");
                            ready_toChat = true;
                            break;

                        case usereintrag.userStatus.SHORT_AWAY:
                            set_form_text(eintrag.get_Nickname() + "( User ist shortly away )");
                            ready_toChat = true;
                            break;

                        case usereintrag.userStatus.DONT_DISTURB:
                            set_form_text(eintrag.get_Nickname() + "( User don't want to be disturb )");
                            ready_toChat = false;
                            break;


                        default:
                            set_form_text(eintrag.get_Nickname() + "( Offline )");
                            ready_toChat = false;
                            cmd_send.Enabled = false;
                            break;

                    }
                }
            }
        }

        private void showallMessages()
        {
            for (int i = 0; i < cCore.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)cCore.users[i];
                if (eintrag.get_Destination() == Destination)
                {
                    eintrag.set_newUnreadMessage(false);
                    set_rtf_chat_clear();
                    foreach (usereintrag.struct_message message in eintrag.Messages)
                    {
                        set_rtf_chat(message);
                    }
                    set_rtf_chat_ScrollToCaret();
                    break;
                }
            }
        }

        public void onNewMessageRecived()
        {
            for (int i = 0; i < cCore.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)cCore.users[i];
                if (eintrag.get_Destination() == Destination)
                {
                    eintrag.set_newUnreadMessage(false);
                    usereintrag.struct_message message = (usereintrag.struct_message)eintrag.Messages[eintrag.Messages.Count-1];
                    set_rtf_chat(message);
                    set_rtf_chat_ScrollToCaret();
                    break;
                }
            }
        }

        private void set_rtf_chat(usereintrag.struct_message message)
        {
            if (this.rtf_chat.InvokeRequired)
            {
                rtf_chat_callback d = new rtf_chat_callback(set_rtf_chat);
                this.Invoke(d, new object[] { message });
            }
            else
            {

                Font t = new Font("Microsoft Sans Serif", 8);
                rtf_chat.SelectionFont = t;
                rtf_chat.SelectionColor = Color.Black;
                rtf_chat.SelectedText = message.nickname+" ";


                rtf_chat.SelectionLength = 0;
                rtf_chat.SelectedRtf = message.text;
             }
        }

        private void set_form_text(string text)
        {   
            if(is_cloosing==true)return;

            if (this.InvokeRequired)
            {
                set_form_text_callback d = new set_form_text_callback(set_form_text);
                this.Invoke(d, new object[] { text });
            }
            else
                this.Text = text;
        }

        private void set_rtf_send_clear()
        {
            if(is_cloosing==true)return;

            if (this.rtf_send.InvokeRequired)
            {
                rtf_send_clear_callback d = new rtf_send_clear_callback(set_rtf_send_clear);
                this.Invoke(d, new object[] { });
            }
            else
                rtf_send.Clear();
        }

        private void set_rtf_chat_clear()
        {
            if(is_cloosing==true)return;

            if (this.rtf_chat.InvokeRequired)
            {
                rtf_chat_clear_callback d = new rtf_chat_clear_callback(set_rtf_chat_clear);
                this.Invoke(d,new object[]{});
            }
            else
                rtf_chat.Clear();
        }

        private void set_rtf_chat_ScrollToCaret()
        {
            if (is_cloosing == true) return;

            if (this.rtf_chat.InvokeRequired)
            {
                set_rtf_chat_ScrollToCaret_callback d = new set_rtf_chat_ScrollToCaret_callback(set_rtf_chat_ScrollToCaret);
                this.Invoke(d, new object[] { });
            }
            else
                rtf_chat.ScrollToCaret();
        }


        private void splitContainer1_Panel1_Paint(object sender, PaintEventArgs e)
        {
               
        }

        private void ChatWindow_FormClosing(object sender, FormClosingEventArgs e)
        {
            is_cloosing=true;
            for (int i = 0; i < cCore.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)cCore.users[i];
                if (eintrag.get_Destination() == Destination)
                {
                    eintrag.newMessageRecived -= new usereintrag.newMessageRecivedHandler(onNewMessageRecived);
                    cCore.UserStatusChanged -= new Core.UserStatusChangedHandler(OnUserStatuschanged);
                    cCore.users[i] = eintrag;
                    cCore.set_have_allreadyOneChatwindow(false, Destination);
                    break;
                }
            }


        }

        private void cmd_send_Click(object sender, EventArgs e)
        {
            if (ready_toChat == false)
            {
                MessageBox.Show("Sorry but User ist Offline");
                return;
            }

            DateTime time = DateTime.Now;

            for (int i = 0; i < cCore.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)cCore.users[i];
                if (eintrag.get_Destination()==Destination)
                {
                    rtf_send.Select(0, 0);
                    rtf_send.SelectionLength = 0;
                    Font t = new Font("Microsoft Sans Serif", 8);
                    
                    
                    rtf_send.SelectionFont = t;
                    rtf_send.SelectionColor = Color.Black;
                    rtf_send.SelectedText = time.ToLongTimeString()+" : ";

                    eintrag.add_sendMessage(rtf_send.Rtf);
                    cCore.users[i] = eintrag;

                    cProtocol.send(eintrag.get_id(), rtf_send.Rtf, Protocol.ProtocoTags.cChat.enumMessages.chatMessage);
                    break;
                }
            }
  
            set_rtf_send_clear();
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
            FontDialog t= new FontDialog();
            t.Font = rtf_send.Font;
            
            if (t.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    if (rtf_send.SelectionLength > 0)
                        rtf_send.SelectionFont = t.Font;
                    else
                    {
                        rtf_send.Font = t.Font;
                        save_CurrentRTF_styleForUser();
                    }
                }
                catch
                {
                    MessageBox.Show("Font","Sorry you can't use this Font");
                }
            }
            
        }

        private void pictureBox2_Click(object sender, EventArgs e)
        {
            ColorDialog MyDialog = new ColorDialog();
            MyDialog.Color = rtf_send.ForeColor;

            if (MyDialog.ShowDialog() == DialogResult.OK)
            {
                if (rtf_send.SelectionLength > 0)
                {
                    rtf_send.SelectionColor = MyDialog.Color;
                }
                else
                {
                    rtf_send.ForeColor = MyDialog.Color;
                    save_CurrentRTF_styleForUser();
                }
            }
         
     
        }

        private void splitContainer1_SplitterMoved(object sender, SplitterEventArgs e)
        {

        }

        private void rtf_send_TextChanged(object sender, EventArgs e)
        {
            if (rtf_send.TextLength > 0 && ready_toChat==true)
                cmd_send.Enabled = true;
            else
                cmd_send.Enabled = false;

        }

        private void rtf_send_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Alt == true && e.KeyCode == Keys.S && rtf_send.TextLength > 0 && this.ready_toChat==true)
                cmd_send_Click(sender,e);
            
        }

        private void pictureBox3_Click(object sender, EventArgs e)
        {
            string[] Files;

            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = "c:\\";
            openFileDialog1.Filter = "All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.Multiselect = true;

            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                
                if (openFileDialog1.OpenFile() != null)
                {
                    Files = openFileDialog1.FileNames; 
                    if(cCore.try_toStartaFileTransfer(Files,Destination)==true)
                    {
                        //Fenster ffnen....
                    }
                    else
                        MessageBox.Show("Only one Filetransfer (send or recive)at the same time");

                }
            }

        }
        private void save_CurrentRTF_styleForUser()
        {

            for (int i = 0; i < cCore.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)cCore.users[i];
                if (eintrag.get_Destination() == Destination)
                {
                    eintrag.set_chat_RTF_Color(rtf_send.ForeColor);
                    eintrag.set_chat_RTF_Font(rtf_send.Font);

                    cCore.users[i] = eintrag;
                    return;
                }
            }
        }
    }
}
