using System;
using System.Collections.Generic;
using System.Text;

namespace I2P_Messenger
{
    public class Settings
    {
        public user_settings USER;
        public connection_settings CONNECTION;
        public general_settings GENERAL;
        public sound_settings SOUND;
        public security_setting SECURITY;
        
        public Settings()
        {
            init();
        }
        
        private void init()
        {
            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            I2P_Messenger.Properties.Sound mySound = new I2P_Messenger.Properties.Sound();
            
            USER = new user_settings(mySettings.UserNickname, mySettings.UserAge, mySettings.UserGender,
                mySettings.UserInterests,mySettings.UserOtherInformation);
            
            CONNECTION = new connection_settings(mySettings.SamHost, mySettings.SamPort, mySettings.Destination,
                mySettings.TunnelName,mySettings.Tunnel_Inbound_Depth,mySettings.Tunnel_Outbound_Depth,
                mySettings.Tunnel_Inbound_Quantity,mySettings.Tunnel_Outbound_Quantity,
                mySettings.Tunnel_Inbound_BackupQuantity,mySettings.Tunnel_Outbound_BackupQuantity,
                mySettings.Tunnel_Inbound_AllowZeroHop,mySettings.Tunnel_Outbound_AllowZeroHop);
            
            GENERAL = new general_settings(mySettings.MaxLogMessages, mySettings.MaxChatMessagePerUser,
                mySettings.UserlistTryToConnectThreadSleep_inMicroseconds, mySettings.XmlUserListPfad);

            SOUND = new sound_settings(mySound.Activate_userList_sounds,mySound.Activate_newMessageSound,
                mySound.Activate_startSound,mySound.User_go_OnlineSoundFile,mySound.User_go_OfflineSoundFile,
                mySound.NewMessageSoundFile,mySound.StartSoundFile);

            SECURITY = new security_setting(mySettings.Block_al_unknown_Users, mySettings.Request_Authorization);
        }

        public void reInit()
        {
            
            lock(this)
            {
                I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
                I2P_Messenger.Properties.Sound mySound = new I2P_Messenger.Properties.Sound();

                USER = new user_settings(mySettings.UserNickname, mySettings.UserAge, mySettings.UserGender,
                    mySettings.UserInterests, mySettings.UserOtherInformation);

                CONNECTION = new connection_settings(mySettings.SamHost, mySettings.SamPort, mySettings.Destination,
                    mySettings.TunnelName, mySettings.Tunnel_Inbound_Depth, mySettings.Tunnel_Outbound_Depth,
                    mySettings.Tunnel_Inbound_Quantity, mySettings.Tunnel_Outbound_Quantity,
                    mySettings.Tunnel_Inbound_BackupQuantity, mySettings.Tunnel_Outbound_BackupQuantity,
                    mySettings.Tunnel_Inbound_AllowZeroHop, mySettings.Tunnel_Outbound_AllowZeroHop);

                GENERAL = new general_settings(mySettings.MaxLogMessages, mySettings.MaxChatMessagePerUser,
                    mySettings.UserlistTryToConnectThreadSleep_inMicroseconds, mySettings.XmlUserListPfad);

                SOUND = new sound_settings(mySound.Activate_userList_sounds, mySound.Activate_newMessageSound,
                    mySound.Activate_startSound, mySound.User_go_OnlineSoundFile, mySound.User_go_OfflineSoundFile,
                    mySound.NewMessageSoundFile, mySound.StartSoundFile);

                SECURITY = new security_setting(mySettings.Block_al_unknown_Users, mySettings.Request_Authorization);
            }
        }

        public class user_settings
        {
            private string UserNickname;
            private string UserAge;
            private string UserGender;
            private string UserInterests;
            private string UserOtherInformation;

            public user_settings(string UserNickname, string userAge, string UserGender, 
                string UserInterests,string UserOtherInformation)
            {
                this.UserAge = userAge;
                this.UserNickname = UserNickname;
                this.UserGender = UserGender;
                this.UserInterests = UserInterests;
                this.UserOtherInformation = UserOtherInformation;
            }

            public string OtherInformation
            {
                get{return UserOtherInformation;}
            }

            public string Interests
            {
                get{return UserInterests;}
            }

            public string Gender
            {
                get{return UserGender;}
            }
            public string Nickname
            {
                get{return UserNickname;}
            }

            public string Age
            {
                get{return UserAge;}
            }
        }

        public class connection_settings
        {
            private string pSamHost;
            private string pSamPort;
            private string pSamDestination;
            private string pTunnelName;
            private string pTunnel_Inbound_Depth;
            private string pTunnel_Outbound_Depth;
            private string pTunnel_Inbound_Quantity;
            private string pTunnel_Outbound_Quantity;
            private string pTunnel_Inbound_BackupQuantity;
            private string pTunnel_Outbound_BackupQuantity;
            private string pTunnel_Inbound_AllowZeroHop;
            private string pTunnel_Outbound_AllowZeroHop;

            public connection_settings(string pSamHost, string pSamPort, string pSamDestination,
                string pTunnelName, string pTunnel_Inbound_Depth, string pTunnel_Outbound_Depth,
                string pTunnel_Inbound_Quantity, string pTunnel_Outbound_Quantity,
                string pTunnel_Inbound_BackupQuantity,string pTunnel_Outbound_BackupQuantity,
                string pTunnel_Inbound_AllowZeroHop,string pTunnel_Outbound_AllowZeroHop)
            {
                this.pSamHost = pSamHost;
                this.pSamPort = pSamPort;
                this.pSamDestination = pSamDestination;
                this.pTunnelName = pTunnelName;
                this.pTunnel_Inbound_Depth = pTunnel_Inbound_Depth;
                this.pTunnel_Outbound_Depth = pTunnel_Outbound_Depth;
                this.pTunnel_Inbound_Quantity=pTunnel_Inbound_Quantity;
                this.pTunnel_Outbound_Quantity = pTunnel_Outbound_Quantity;
                this.pTunnel_Inbound_BackupQuantity = pTunnel_Inbound_BackupQuantity;
                this.pTunnel_Outbound_BackupQuantity = pTunnel_Outbound_BackupQuantity;
                this.pTunnel_Inbound_AllowZeroHop = pTunnel_Inbound_AllowZeroHop;
                this.pTunnel_Outbound_AllowZeroHop=pTunnel_Outbound_AllowZeroHop;
            }

            public string SamHost
            {
                get{return pSamHost;}
            }
            public string SamPort
            {
                get{return pSamPort;}
            }
            public string SamDestination
            {
                get{return pSamDestination;}
            }
            public string TunnelName
            {
                get{return pTunnelName;}
            }
            public string Tunnel_Inbound_Depth
            {
                get { return pTunnel_Inbound_Depth; }
            }
            public string Tunnel_Outbound_Depth
            {
                get { return Tunnel_Outbound_Depth; }
            }
            public string Tunnel_Inbound_Quantity
            {
                get {return pTunnel_Inbound_Quantity;}
            }
            public string Tunnel_Outbound_Quantity
            {
                get { return pTunnel_Outbound_Quantity;}
            }
            public string Tunnel_Inbound_BackupQuantity
            {
                get { return pTunnel_Inbound_BackupQuantity;}
            }
            public string Tunnel_Outbound_BackupQuantity
            {
                get { return pTunnel_Outbound_BackupQuantity; }
            }
            public string Tunnel_Inbound_AllowZeroHop
            {
                get { return pTunnel_Inbound_AllowZeroHop; }
            }
            public string Tunnel_Outbound_AllowZeroHop
            {
                get { return pTunnel_Outbound_AllowZeroHop; }
            }
            public string allTunnelOptions
            {
                get
                {
                    string SessionOption;
                    SessionOption = pTunnelName + " ";
                    SessionOption += pTunnel_Inbound_AllowZeroHop + " ";
                    SessionOption += pTunnel_Outbound_AllowZeroHop + " ";
                    SessionOption += pTunnel_Inbound_BackupQuantity + " ";
                    SessionOption += pTunnel_Outbound_BackupQuantity + " ";
                    SessionOption += pTunnel_Inbound_Depth + " ";
                    SessionOption += pTunnel_Outbound_Depth + " ";
                    SessionOption += pTunnel_Outbound_Quantity + " ";
                    return SessionOption;
                }
            }
        
        }

        public class general_settings
        {
            private int pMaxLogMessages;
            private int pMaxChatMessagePerUser;
            private int pUserlistTryToConnectThreadSleep_inMicroseconds;
            private string pXmlUserListPfad;

            public general_settings(int pMaxLogMessages, int pMaxChatMessagePerUser,
                int pUserlistTryToConnectThreadSleep_inMicroseconds, string pXmlUserListPfad)
            {
                this.pMaxLogMessages = pMaxLogMessages;
                this.pMaxChatMessagePerUser = pMaxChatMessagePerUser;
                this.pUserlistTryToConnectThreadSleep_inMicroseconds=pUserlistTryToConnectThreadSleep_inMicroseconds;
                this.pXmlUserListPfad = pXmlUserListPfad;
            }

            public int MaxLogMessages
            {
                get{return pMaxLogMessages;}
            }
            public int MaxChatMessagePerUser
            {
                get{return pMaxChatMessagePerUser;}
            }
            public int UserlistTryToConnectThreadSleep_inMicroseconds
            {
                get{return pUserlistTryToConnectThreadSleep_inMicroseconds;}
            }
            public string XmlUserListPfad
            {
                get{return pXmlUserListPfad;}
            }
        }

        public class sound_settings
        {
            bool pActivate_userList_sounds;
            bool pActivate_newMessageSound;
            bool pActivate_startSound;

            string pUser_go_OnlineSoundFile;
            string pUser_go_OfflineSoundFile;
            string pNewMessageSoundFile;
            string pStartSoundFile;

            public sound_settings(bool pActivate_userList_sounds,bool pActivate_newMessageSound,
                bool pActivate_startSound, string pUser_go_OnlineSoundFile, 
                string pUser_go_OfflineSoundFile,string pNewMessageSoundFile,
                string pStartSoundFile)
            {
                this.pActivate_userList_sounds=pActivate_userList_sounds;
                this.pActivate_newMessageSound = pActivate_newMessageSound;
                this.pActivate_startSound = pActivate_startSound;
                this.pUser_go_OnlineSoundFile = pUser_go_OnlineSoundFile;
                this.pUser_go_OfflineSoundFile = pUser_go_OfflineSoundFile;
                this.pNewMessageSoundFile = pNewMessageSoundFile;
                this.pStartSoundFile = pStartSoundFile;
            }

            public bool Activate_userList_sounds
            {
                get { return pActivate_userList_sounds; }
            }
            public bool Activate_newMessageSound
            {
                get { return pActivate_newMessageSound; }
            }
            public bool Activate_startSound
            {
                get { return pActivate_startSound; }
            }
            public string User_go_OnlineSoundFile
            {
                get { return pUser_go_OnlineSoundFile; }
            }
            public string User_go_OfflineSoundFile
            {
                get { return pUser_go_OfflineSoundFile; }
            }
            public string NewMessageSoundFile
            {
                get { return pNewMessageSoundFile; }
            }
            public string StartSoundFile
            {
                get { return pStartSoundFile; }
            }

        }
        
        public class security_setting
        {
            private bool pBlock_al_unknown_Users;
            private bool pRequest_Authorization;

            public security_setting(bool Block_al_unknown_Users, bool Request_Authorization)
            {
                this.pBlock_al_unknown_Users = Block_al_unknown_Users;
                this.pRequest_Authorization = Request_Authorization;
            }

            public bool Block_al_unknown_Users
            {
                get { return pBlock_al_unknown_Users; }
            }
            public bool Request_Authorization
            {
                get { return pRequest_Authorization; }
            }


        }
        
    }
}
