using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;

using i2p_connection;
using I2P_Messenger.Forms;

namespace I2P_Messenger
{
   public class LogManager
    {

       public event LogWindow.newLogMessageRecived newLogMessageRecived;
       public delegate void LogReceivedHandler(string message);            

       private ArrayList Messages = new ArrayList();
       private i2p_connection_Class cI2P;

       public LogManager(i2p_connection_Class cI2P)
       {
           this.cI2P = cI2P;
           cI2P.LogReceivedHandlerClient += new i2p_connection_Class.LogReceivedHandler(onLogReceivedHandler);
       }
       ~LogManager()
       {
           cI2P.LogReceivedHandlerClient -= new i2p_connection_Class.LogReceivedHandler(onLogReceivedHandler);
       }

        public void add_to_Log(string Message)
        {
            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            if(Messages.Count== mySettings.MaxLogMessages)
            {
                Messages.RemoveAt(Messages.Count-1);
            }
            //Messages.Add(Message);
            Messages.Insert(0, Message);

            if(newLogMessageRecived!=null)                
                newLogMessageRecived();
            

        }
        public string get_LogMessages()
        {
            string temp="";
            
            foreach (string Message in Messages)
            {
                temp += Message;
            }
            
            return temp;
        }
       public void clear_messages()
       {
           Messages.Clear();

           if (newLogMessageRecived != null)
               newLogMessageRecived();
       }

       public int get_anz_of_messages()
       {
           return Messages.Count;
       }
       
       public void onLogReceivedHandler(string message)
       {
           DateTime time = DateTime.Now;
           add_to_Log("\n\n\nTime: "+time.ToLongTimeString()+message);
       }
    }
}
