using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
/*
 
 [4]---------------------> <__File Transfer__> 
  |    [ ] [ ] [ ]
  |     |
  |     0--[ ]-[ ]------------> Commands          
  |     0   |   |
  |     0   0   0                 = want to send a Files
  |     0   0   1                 = agree (all Files)
  |     0   0   2                 = disagree (all Files)
  |     0   0   3                 = get_file /get next_file(fromBlock)
  |     0   0   4                 = abort Filetransfer
 
  |     1--[ ]-[ ]------------> Messages          
  |     1   |   | 
  |     1   0   0                 = Fileinfo(FILENAME=&Filename|FILESIZE=$sizeInByte)
  |     1   0   1                 = allFileinfosAreSended 
  |     1   0   2                 = usedblocksize in bytes
  |     1   0   3                 = FileDataBytes
  |     1   0   4                 = UserCantAcceptAtTheMoment
 
 /*
                        Filetransfer
 Sender                                                       Reciver
 
 send want to send a Files                                      recive 
 send all Fileinfos                                             recive
 send allFileinfosAreSended                                     showUser the Infos
                                                                send agree or disagree (all Files)
 if(disagree) then exit
    else
    send usedblocksize in bytes                                 recive
   
    foreach file
    {
      send Fileinfo(FILENAME=&Filename|FILESIZE=$sizeInByte)    recive
                                                                send (get all blocks) or (get all blocks from &blocknumber)
      send FileDataBytes
    }
*/
 
 /*
  //------------------------------------------
                    // FileTransfer Befehle
                        /*
                            case "4000":
                                //want_to_send_a_Files: (filerecive)
                                break;

                            case "4001":
                                //Agree;
                                if (cCore.filetransfer.sendFile != null)
                                    cCore.filetransfer.sendFile.userAgreed();
                                break;

                            case "4002":
                                //Disagree
                                if (cCore.filetransfer.sendFile != null)
                                    cCore.filetransfer.sendFile.userDisagreed();
                                break;        

                            case "4003":
                                //get_all_blocks
                                if (cCore.filetransfer.sendFile != null)
                                    cCore.filetransfer.sendFile.get_file(Convert.ToInt32(nutzdaten));
                                break;                    

                            case "4004":
                                //abort Filetransfer
                                if(cCore.filetransfer.sendFile!=null)
                                    cCore.filetransfer.sendFile.abort_Transfer();
                                break;
                            
                    //------------------------------------------
                    // FileTransfer Messages
                            case "4100":
                                //Fileinfo
                                break;

                            case "4101":
                                //allFileinfosAreSended
                                break;
                                
                            case "4102":
                                //usedblocksizeInBytes
                                break;
                            
                            case "4103":
                                //FileDatabytes
                                break;
                    */
                    //------------------------------------------
  
  
  
  

 
 
 

namespace I2PChat_2
{
    public class Filetransfer
    {
        private Core cCore;
        private string Destination;

        public enum modus { SENDFILE, RECIVEFILE};

        private modus aktModus;
        public SendFile sendFile;
        public ReciveFile reciveFile;

        public Filetransfer(Core cCore, string Destination)
        {
            this.cCore = cCore;
            this.Destination = Destination;
        }

        public void nit_ForSendFiles(modus Modus, string[] FileNamesArray, long BlockSizeInBytes)
        {
            if (Modus == modus.SENDFILE)
            {
                aktModus = Modus;
                this.sendFile = new SendFile(cCore, FileNamesArray, Destination, BlockSizeInBytes);
            }
            else
                return;
        }

        public void init_ForReciveFiles(modus Modus)
        {
            if (Modus == modus.RECIVEFILE)
            {
                aktModus = Modus;
                this.reciveFile = new ReciveFile();
            }
            else
                return;
        }

        public class SendFile
        {
            private string[] FileNameArray;
            private string ID;
            private string Destination;
            private long BlockSizeInBytes;
            private Core cCore;
            private int FileIndex; //aktuell zu sendende Datei

            public SendFile(Core cCore,string[] FileNameArray, string Destination,long BlockSizeInBytes)
            {
                this.cCore = cCore;
                this.FileNameArray = FileNameArray;
                this.BlockSizeInBytes=BlockSizeInBytes;
                this.Destination=Destination;
                this.ID=cCore.get_ID_byDestination(Destination);
                this.FileIndex = 0;

                //generelle Info das dateien bertragen werden sollen
                cCore.Protocol.send_Befehl(ID,"",Protocol.Befehle.FileTransfer_want_to_send_a_Files);
                for(int i=0;i<FileNameArray.GetUpperBound(0);i++)
                {  // einzelne dateiinfos bertragen 
                    cCore.Protocol.send_Message(ID,"FILENAME="+FileNameArray[i]+"FILESIZE="+get_FileSize(i),Protocol.Messages.FileTransfer_Fileinfo);
                }
                //alle dateiinfos bertragen
                cCore.Protocol.send_Message(ID, "", Protocol.Messages.FileTransfer_allFileinfosAreSended);
            }

            public void userAgreed()
            {
                //sende BlockSize
                cCore.Protocol.send_Message(ID, BlockSizeInBytes.ToString(), Protocol.Messages.FileTransfer_usedblocksizeInBytes);
            }

            public void get_file(int fromBlock)
            {
                if (FileIndex < FileNameArray.GetUpperBound(0))
                {
                    transferData(FileIndex,fromBlock);
                    FileIndex++;
                }
                else
                    return;
            }

            private void transferData(int index, int fromBlock)
            {
                int SizeSended = 0;
                int Size = this.get_FileSize(index);
                byte[] buffer = new byte[this.BlockSizeInBytes];

               
                cCore.Protocol.send_Message(ID, "FILENAME=" + FileNameArray[index] + "FILESIZE=" + get_FileSize(index), Protocol.Messages.FileTransfer_Fileinfo);

                 if (!File.Exists(FileNameArray[index]))
                 {
                     Stream stream;
                     stream = File.Open(FileNameArray[index].ToString(), FileMode.Open);
                     
                     BinaryReader bin;
                     bin = new BinaryReader(stream);

                     while (SizeSended < Size)
                     {
                         SizeSended += bin.Read(buffer, Convert.ToInt32(SizeSended), buffer.Length);
                         cCore.Protocol.send_Message(ID, buffer, Protocol.Messages.FileTransfer_FileDatabytes);
                     }
                 }
            }

            public void userDisagreed()
            {
                
            }


            public int get_FileSize(int FileIndex)
            {
                    FileInfo file = new FileInfo(FileNameArray[FileIndex]);
                    return Convert.ToInt32(file.Length);
            
            }


            public int get_FilesCount()
            {
                return FileNameArray.GetUpperBound(0);
            }

            public long get_SizeSumOfAllFiles()
            {
                long Size=0;

                for (int i = 0; i < FileNameArray.GetUpperBound(0); i++)
                {
                    FileInfo file = new FileInfo(FileNameArray[i]);
                    Size += file.Length;
                }
                return Size;
            }


            public void abort_Transfer()
            {
            
            }

        }
        public class ReciveFile
        {
        
        }




    }
}
