using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;

using System.Drawing;

namespace I2P_Messenger
{
    public class usereintrag
    {
        public struct struct_message
        {
            public string text;
            public string nickname;

            public struct_message(string text, string nickname)
            {
                this.text = text;
                this.nickname = nickname;
            }
        }

        public event newMessageRecivedHandler newMessageRecived;
        public delegate void newMessageRecivedHandler();

        private string Nickname;
        private string Destination;
        private string ID;
        private string last_ID;
        private string MyNickname;
        private Font chat_RTF_Font;
        private Color chat_RTF_Color;
            
        public enum UserDetails
        {
            UserNickname, UserAge, UserGender, UserInterests, UserOtherInformation,
            ProcolVersion, ClientVersion, ClientName
        };

        private string UserNickname;
        private string UserAge;
        private string UserGender;
        private string UserInterests;
        private string UserOtherInformation;
        private string ProcolVersion;
        private string ClientVersion;
        private string ClientName;


        private bool AllUserDetailsRecived;

        private bool haveACurrentChatWindow;
        private bool haveACurrentUserDetailWindow;

        public ArrayList Messages;
        
        public enum userStatus { CONNECTED, DISCONNECTED, CANT_REACH, TRY_TO_CONNECT, YOU_BLOCKED_HIM, 
                                YOU_WERE_BLOCKED, DONT_DISTURB, LIKE_TO_CHAT, INVISIBLE, SHORT_AWAY };
        
        private bool newUnreadMessage;

        userStatus aktStatus;

        public bool get_haveACurrentChatWindow()
        {
            return haveACurrentChatWindow;
        }

        public void set_haveACurrentChatWindow(bool b)
        {
            haveACurrentChatWindow = b;
        }

        public void set_haveACurrentUserDetailWindow(bool b)
        {
            haveACurrentUserDetailWindow = b;
        }
        public bool get_haveACurrentUserDetailWindow()
        {
            return haveACurrentUserDetailWindow;
        }


        public void set_newUnreadMessage(bool b)
        {
            newUnreadMessage = b;
        }

        public bool get_newUnreadMessage()
        {
            return newUnreadMessage;
        }


        public usereintrag(string Nickname, string Destination)
        {
            this.Nickname = Nickname;
            this.Destination = Destination;
            ID = null;
            haveACurrentChatWindow = false;
            haveACurrentUserDetailWindow = false;
            AllUserDetailsRecived = false;

            I2P_Messenger.Properties.Settings mySettings = new I2P_Messenger.Properties.Settings();
            MyNickname = mySettings.UserNickname;

            aktStatus = usereintrag.userStatus.DISCONNECTED;
            Messages = new ArrayList();
            this.newUnreadMessage = false;

        }

        public string get_Destination()
        {
            return Destination;
        }

        public string get_Nickname()
        {
            return Nickname;
        }

        public void set_Nickname(string newName)
        {
            this.Nickname = newName;
        }

        public userStatus get_aktStatus()
        {
            return aktStatus;
        }

        public void add_message(string text)
        {
            struct_message new_message = new struct_message(text, Nickname);
            Messages.Add(new_message);

            if (newMessageRecived != null)
                newMessageRecived();
            else
                newUnreadMessage = true;
        }
        public void add_messageFromSystem(string text)
        {
            string Message;
            //Message = string.Format("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1031{\\fonttbl{\\f0\\fnil\\fcharset0 Microsoft Sans Serif;}}\r\n{\\colortbl ;\\red255\\green0\\blue0;}\r\n\\viewkind4\\uc1\\pard\\cf1\\b\\f0\\fs29 {}\\par\r\n\\pard\\cf0\\b0\\fs17\\par\r\n}\r\n", text);
            Message = "{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1031{\\fonttbl{\\f0\\fnil\\fcharset0 Microsoft Sans Serif;}}\r\n{\\colortbl ;\\red255\\green0\\blue0;}\r\n\\viewkind4\\uc1\\pard\\cf1\\b\\f0\\fs29 "+text+"\\par\r\n}\r\n";
                    
            struct_message new_message = new struct_message(Message, "Message from Core");

            Messages.Add(new_message);

            if (newMessageRecived != null)
                newMessageRecived();
            else
                newUnreadMessage = true;

        }
        public void add_sendMessage(string text)
        {
            struct_message new_message = new struct_message(text, MyNickname);
            Messages.Add(new_message);

            if (newMessageRecived != null)
                newMessageRecived();

        }

        public void set_ID(string ID)
        {
            if(ID!=null)
                this.last_ID = this.ID;
            
            this.ID = ID;
        }

        public string get_id()
        {
            return ID;
        }
        public string get_lastID()
        {
            return last_ID;
        }

        public void set_chat_RTF_Font(Font newFont)
        {
            this.chat_RTF_Font = newFont;
        }

        public Font get_chat_RTF_Font()
        {
            return this.chat_RTF_Font;
        }
        public void set_chat_RTF_Color(Color newColor)
        {
            this.chat_RTF_Color = newColor;
        }
        public Color get_chat_RTF_color()
        {
            return this.chat_RTF_Color;
        }
        

        private void CheckIfAllUserDetailsRecived()
        {
            if (this.UserNickname != null && this.UserAge != null && this.UserGender != null
                    && this.UserInterests != null && this.UserOtherInformation != null &&
                    ProcolVersion != null && ClientName != null && ClientVersion != null)

                AllUserDetailsRecived = true;
            else
                AllUserDetailsRecived = false;
        }

        public bool get_AllUserDetailsRecived()
        {
            return AllUserDetailsRecived;
        }

        public void set_Status(userStatus Status)
        {
            switch (Status)
            {
                case userStatus.DISCONNECTED:
                    aktStatus = userStatus.DISCONNECTED;
                    break;

                case userStatus.CONNECTED:
                    aktStatus = userStatus.CONNECTED;   
                    break;

                case userStatus.CANT_REACH:
                    aktStatus = userStatus.CANT_REACH;
                    break;

                case userStatus.TRY_TO_CONNECT:
                    aktStatus = userStatus.TRY_TO_CONNECT;
                    break;

                case userStatus.YOU_WERE_BLOCKED:
                    aktStatus = userStatus.YOU_WERE_BLOCKED;
                    break;
                    
                case userStatus.YOU_BLOCKED_HIM:
                    aktStatus = userStatus.YOU_BLOCKED_HIM;
                    break;

                case userStatus.DONT_DISTURB:
                    aktStatus = userStatus.DONT_DISTURB;
                    break;

                case userStatus.INVISIBLE:
                    aktStatus = userStatus.INVISIBLE;
                    break;

                case userStatus.LIKE_TO_CHAT:
                    aktStatus = userStatus.LIKE_TO_CHAT;
                    break;

                case userStatus.SHORT_AWAY:
                    aktStatus = userStatus.SHORT_AWAY;
                    break;
            }
        }

        public void set_userDetail(UserDetails Detail, string DetailText)
        {
            switch (Detail)
            {
                case UserDetails.ClientName:
                    this.ClientName = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;

                case UserDetails.ClientVersion:
                    this.ClientVersion = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;

                case UserDetails.ProcolVersion:
                    this.ProcolVersion = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;

                case UserDetails.UserAge:
                    this.UserAge = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;

                case UserDetails.UserGender:
                    this.UserGender = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;

                case UserDetails.UserInterests:
                    this.UserInterests = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;

                case UserDetails.UserNickname:
                    this.UserNickname = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;

                case UserDetails.UserOtherInformation:
                    this.UserOtherInformation = DetailText;
                    CheckIfAllUserDetailsRecived();
                    break;
            }

        }
        public string get_userDetail(UserDetails Detail)
        {
            switch (Detail)
            {
                case UserDetails.ClientName:
                    return this.ClientName;

                case UserDetails.ClientVersion:
                    return this.ClientVersion;

                case UserDetails.ProcolVersion:
                    return this.ProcolVersion;

                case UserDetails.UserAge:
                    return this.UserAge;

                case UserDetails.UserGender:
                    return this.UserGender;

                case UserDetails.UserInterests:
                    return this.UserInterests;

                case UserDetails.UserNickname:
                    return this.UserNickname;

                case UserDetails.UserOtherInformation:
                    return this.UserOtherInformation;
            }
            return null;

        }
    }

}
