using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;


using I2P_Messenger;

namespace i2p_connection
{
    public enum Status
    {
        SAM_CONNECTED,
        SAM_DISCONNECTED,
        SESSION_CREATED,
        SESSION_CLOSED
    }
    public enum SessionStyle
    {
        STREAM,
        DATAGRAM,
        RAW
    }
    public enum Direction
    {
        BOTH,
        RECEIVE,
        CREATE
    }

    public class i2p_connection_Class
    {
        
        public event LogReceivedHandler LogReceivedHandlerClient;
        public event StatusReceivedHandler StatusReceivedHandlerClient;
        public event StreamDataReceivedHandler StreamDataReceivedHandlerClient;
        public event StreamConnectedReceivedHandler StreamConnectedReceivedHandlerClient;
        public event StreamStatusReceivedHandler StreamStatusReceivedClient;
        public event NamingReplyReceived NamingReplyReceivedClient;
        public event StreamClosedReceivedHandler StreamClosedReceivedHandlerClient;

        

        public delegate void HelloReplyReceivedHandler(bool ok);
        public delegate void DestReplyReceivedHandler(string publicKey, string privateKey); 
        public delegate void NamingReplyReceivedHandler(string name, string result, string valueString, string message);
        public delegate void SessionStatusReceivedHandler(string result, string destination, string message);
        public delegate void StreamClosedReceivedHandler(string result, string id, string message);
        public delegate void StreamConnectedReceivedHandler(string remoteDestination, string id);
        public delegate void StreamDataReceivedHandler(string id, byte[] data, int offset, int length);
        public delegate void StreamStatusReceivedHandler(string result, string id, string message);
        public delegate void UnknownMessageReceivedHandler(string Buffer);
        public delegate void LogReceivedHandler(string Message);
        public delegate void StatusReceivedHandler(Status Status);
        public delegate void NamingReplyReceived(string name, string result, string valueString, string message);

        
       
        
        private Samreader _samReader;

        private object _helloLock = new Object();
        private string _helloOk;

        private object _sessionCreateLock = new Object();
        private string _sessionCreateOk;

        private object _streamConnectionLock = new Object();
        private string _StreamConnectionOk;

        private Socket socket;
        private string SamHost;
        private string SamPort;
        private string SessionOption;
        private int highestUsedID;

        struct ID_eintrag
        {
            public int ID;
            public bool free;
        }

        private ArrayList USED_IDS;
        
        
        public string get_nextFreeID()
        {
            for (int i = 0; i < USED_IDS.Count; i++)
            {
                ID_eintrag eintrag = (ID_eintrag)USED_IDS[i];
                if (eintrag.free == true)
                {
                    eintrag.free = false;
                    USED_IDS[i] = eintrag;
                    return eintrag.ID.ToString();
                }
            }

            //neuer eintrag hinzufgen
            ID_eintrag neuer_eintrag = new ID_eintrag();
            highestUsedID++;
            neuer_eintrag.ID = highestUsedID;
            neuer_eintrag.free = false;
            USED_IDS.Add(neuer_eintrag);
            return neuer_eintrag.ID.ToString();

        }

        public i2p_connection_Class(string SamHost,string SamPort,string SessionOption)
        {
            this.SamHost = SamHost;
            this.SamPort = SamPort;
            this.SessionOption = SessionOption;
            USED_IDS = new ArrayList();
            highestUsedID = 0;

        }
        public int init()
        {
            Status status = new Status();
            socket = ConnectSocket(SamHost, Convert.ToInt32(SamPort));
            if (socket == null)
            {
                status = Status.SAM_DISCONNECTED;
                StatusReceivedHandlerClient(status);
                LogReceivedHandlerClient("\t\t\t<-- Can't connect SAM !!! -->");
                return 1;
            }
            else
            {
                status = Status.SAM_CONNECTED;
                StatusReceivedHandlerClient(status);
                LogReceivedHandlerClient("\t\t\t<-- SAM is connected !!! -->");
            }

            _samReader = new Samreader(socket);
            _samReader.DestReplyReceived += new DestReplyReceivedHandler(OnDestReplyReceived);
            _samReader.HelloReplyReceived += new HelloReplyReceivedHandler(OnHelloReplyReceived);
            _samReader.NamingReplyReceived += new NamingReplyReceivedHandler(OnNamingReplyReceived);
            _samReader.SessionStatusReceived += new SessionStatusReceivedHandler(OnSessionStatusReceived);
            _samReader.StreamClosedReceived += new StreamClosedReceivedHandler(OnStreamClosedReceived);
            _samReader.StreamConnectedReceived += new StreamConnectedReceivedHandler(OnStreamConnectedReceived);
            _samReader.StreamDataReceived += new StreamDataReceivedHandler(OnStreamDataReceived);
            _samReader.StreamStatusReceived += new StreamStatusReceivedHandler(OnStreamStatusReceived);
            _samReader.UnknownMessageReceived += new UnknownMessageReceivedHandler(OnUnknownMessageReceived);

            _samReader.LogReceivedHandlerClient += new LogReceivedHandler(LogReceivedHandlerClient);

            _samReader.sendSamConnectionHandshake();
            _samReader.StartReading();
            return 0;
        }
        public void unload()
        {
            try
            {
                _samReader.unload();
            }
            catch
            { }
            
        }
        
        private static Socket ConnectSocket(string server, int port)
        {
            Socket s = null;
            IPHostEntry hostEntry = null;
            try
            {
                hostEntry = Dns.GetHostEntry(server);
                foreach (IPAddress address in hostEntry.AddressList)
                {
                    IPEndPoint ipe = new IPEndPoint(address, port);
                    Socket tempSocket =
                        new Socket(ipe.AddressFamily, SocketType.Stream, ProtocolType.Tcp);

                    tempSocket.Connect(ipe);

                    if (tempSocket.Connected)
                    {
                        s = tempSocket;
                        break;
                    }
                    else
                    {
                        continue;
                    }
                }
            }
            catch
            {
            }
            return s;
        }
        
        public virtual void OnDestReplyReceived(string publicKey, string privateKey )
        {
            string text;
            
            text="\t\t\t <-- OnDestReplyReceived -->";
            text+="\npublicKey:\t" + publicKey;
            text+="\nprivateKey:\t" + privateKey;

            LogReceivedHandlerClient(text);
            
		}

		public virtual void OnHelloReplyReceived(bool ok)
        {
            lock (_helloLock)
            {

                if (ok==true)
                {
                    _helloOk = Boolean.TrueString; ;
                }
                else
                {
                    _helloOk = Boolean.FalseString;
                }
                Monitor.PulseAll(_helloLock);
            }

            LogReceivedHandlerClient("\t\t\t<-- OnHelloReplyReceived -->"); 
		}

		public virtual void OnNamingReplyReceived(string name, string result, string valueString, string message)
        {
            string text;

            text="\t\t\t<-- OnNamingReplyReceived -->";
            text+="\nName\t: " + name;
            text+="\nResult\t: " + result;
            text+="\nValueString\t: " + valueString;
            text+="\nMessage\t: " + message;
            LogReceivedHandlerClient(text);
            NamingReplyReceivedClient(name, result, valueString, message);
          
		}

		public virtual void OnSessionStatusReceived(string result, string destination, string message) 
        {
            string text;
            Status status = new Status();

            text="\t\t\t<-- OnSessionStatusReceived -->";
            text+="\nResult:" + result;
            text+="\nDestination:" + destination;
            text+="\nMessage:" + message;

            LogReceivedHandlerClient(text);

            lock (_sessionCreateLock)
            {
                if (result.CompareTo("OK") == 0)
                {
                    status = Status.SESSION_CREATED;
                    _sessionCreateOk = Boolean.TrueString;
                }
                else
                {
                    status = Status.SESSION_CLOSED;
                    _sessionCreateOk = Boolean.FalseString;
                }

                Monitor.PulseAll(_sessionCreateLock);
            }
            StatusReceivedHandlerClient(status);
		}

		public virtual void OnStreamClosedReceived(string result, string id, string message) 
        {
            string text;

            text="\t\t\t<-- OnStreamClosedReceive -->";
            text+="\nResult:\t" + result;
            text+="\nID:\t" + id;
            text+="\nMessage:\t" + message;

            LogReceivedHandlerClient(text);
            
            lock (_streamConnectionLock)
            {
                _StreamConnectionOk = Boolean.FalseString;
                Monitor.PulseAll(_streamConnectionLock);
            }

            if (Convert.ToInt32(id) > 0)
            {
                for (int i = 0; i < USED_IDS.Count; i++)
                {
                    ID_eintrag eintrag = (ID_eintrag)USED_IDS[i];

                    if (eintrag.ID == Convert.ToInt32(id))
                    {
                        eintrag.free = true;
                        USED_IDS[i] = eintrag;
                        break;
                    }
                }
            }
            StreamClosedReceivedHandlerClient(result, id, message);
		}

		public virtual void OnStreamConnectedReceived(string remoteDestination, string id) 
        {
            string text;

            text="\t\t\t<-- OnStreamConnectedReceived -->";
            text+="\nRemoteDestination:\t" + remoteDestination;
            text+="\nID\t" + id;


            LogReceivedHandlerClient(text);
            StreamConnectedReceivedHandlerClient(remoteDestination, id);

            lock (_streamConnectionLock)
            {
                _StreamConnectionOk = Boolean.TrueString;
                Monitor.PulseAll(_streamConnectionLock);
            }
		}

		public virtual void OnStreamDataReceived(string id, byte[] data, int offset, int length) 
        {
            string LogMessage;
            string temp;


            System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
            temp = enc.GetString(data);
            temp = temp.Substring(offset, length);

            LogMessage = "\t\t\t<-- OnStreamDataReceived -->\n";
            LogMessage += "\nID\t" + id;
            LogMessage += "\n"+temp;
            LogReceivedHandlerClient(LogMessage);
            
            StreamDataReceivedHandlerClient(id, data, offset, length);
		}

		public virtual void OnStreamStatusReceived(string result, string id, string message) 
        {

            string text;

            text="\t\t\t<-- OnStreamStatusReceived -->";
            text+="\nResult:\t" + result;
            text+="\nID:\t" + id;
            text+="\nMessage:\t"+message;



            LogReceivedHandlerClient(text);

            lock (_streamConnectionLock)
            {
                if (result.CompareTo("OK") == 0)
                {
                    _StreamConnectionOk = Boolean.TrueString;
                }
                else
                {
                    _StreamConnectionOk = Boolean.FalseString;

                    if (Convert.ToInt32(id) > 0)
                    {

                        for (int i = 0; i < USED_IDS.Count; i++)
                        {
                            ID_eintrag eintrag = (ID_eintrag)USED_IDS[i];

                            if (eintrag.ID == Convert.ToInt32(id))
                            {
                                eintrag.free = true;
                                USED_IDS[i] = eintrag;
                                break;
                            }
                        }
                    }
                }

                Monitor.PulseAll(_streamConnectionLock);
            }
            StreamStatusReceivedClient(result, id, message);
		}

        public virtual void OnUnknownMessageReceived(string Buffer)
        {
            string text;

            text = "\t\t\t<-- OnUnknownMessageReceived -->";
            text+=Buffer;
            LogReceivedHandlerClient(text);
        }

        public void Create_Session(SessionStyle Style, string Destination, Direction direction)
        {
            WaitForHelloReply();
            _samReader.createSession(Style, Destination, direction,SessionOption);
            
        }
        public void Stream_Connect(string ID, string Destination)
        {
            WaitForHelloReply();
            _samReader.Connect_Stream(ID, Destination);
        }
        public void Naming_Lookup(string Name)
        {
            WaitForSessionCreateReply();
            _samReader.Naming_Lookup(Name);
        }
        public void Stream_Send(string ID, string Data)
        {
            WaitForSessionCreateReply();
            _samReader.sendStream(ID, Data);
            
        }

        public void Stream_close(string ID)
        {
            if (Convert.ToInt32(ID) > 0)
            {

                for (int i = 0; i < USED_IDS.Count; i++)
                {
                    ID_eintrag eintrag = (ID_eintrag)USED_IDS[i];

                    if (eintrag.ID == Convert.ToInt32(ID))
                    {
                        eintrag.free = true;
                        USED_IDS[i] = eintrag;
                        break;
                    }
                }
            }
            _samReader.closeStream(ID);
        }
        
        public virtual bool WaitForHelloReply()
        {
            while (true)
            {
                lock (_helloLock)
                {
                    if (_helloOk == null)
                        Monitor.Wait(_helloLock);
                    else
                        return Boolean.Parse(_helloOk);
                }
            }
        }
        
        public virtual bool WaitForSessionCreateReply()
        {
            while (true)
            {
                lock (_sessionCreateLock)
                {
                    if (_sessionCreateOk == null)
                        Monitor.Wait(_sessionCreateLock);
                    else
                        return Boolean.Parse(_sessionCreateOk);
                }
            }
        }

        public virtual bool WaitForstreamConnectionReply()
        {
            while (true)
            {
                lock (_streamConnectionLock)
                {
                    if (_StreamConnectionOk == null)
                        Monitor.Wait(_streamConnectionLock);
                    else
                        return Boolean.Parse(_StreamConnectionOk);
                }
            }
        }
        


        class Samreader
        {
            public event LogReceivedHandler LogReceivedHandlerClient;
            

            public event DestReplyReceivedHandler       DestReplyReceived;
		    public event HelloReplyReceivedHandler      HelloReplyReceived;
		    public event NamingReplyReceivedHandler     NamingReplyReceived;
		    public event SessionStatusReceivedHandler   SessionStatusReceived;
		    public event StreamClosedReceivedHandler    StreamClosedReceived;
		    public event StreamConnectedReceivedHandler StreamConnectedReceived;
		    public event StreamDataReceivedHandler      StreamDataReceived;
		    public event StreamStatusReceivedHandler    StreamStatusReceived;
		    public event UnknownMessageReceivedHandler  UnknownMessageReceived;

            private string samMessage = "HELLO VERSION MIN=1.0 MAX=1.0\n";
            private bool active = false;

            private object _helloLock = new Object();
            private string _helloOk;
            
            private object _sessionCreateLock = new Object();
            private string _sessionCreateOk;


            private object _streamConnectionLock = new Object();
            private string _StreamConnectionOk;

            private NameValueCollection _namingReplies = new NameValueCollection();
            private object _namingReplyLock = new Object();
            private Socket socket;

            private NetworkStream _samStream;



            public Samreader(Socket socket)
            {
                this.socket = socket;
                active = true;
                _samStream = new NetworkStream(socket);
  
            }

            public void createSession(SessionStyle Style, string Destination,Direction direction,string SessionOption)
            {
                if (active == true)
                {
                    WaitForHelloReply();

                    byte[] temp;
                    string text;
                    string logMessage;

                    WaitForHelloReply();
                    text = "SESSION CREATE STYLE=" + Style + " DESTINATION=" + Destination + " DIRECTION=" + direction + " " + SessionOption + "\n";
                    temp = StrToByteArray(text);

                    logMessage = "\t\t\t<-- createSession -->\n";
                    logMessage += text;

                    LogReceivedHandlerClient(logMessage);
                    _samStream.Write(temp, 0, temp.Length);
                    _samStream.Flush();
                }
  
            }
            public void unload()
            {
                active = false;
                _samStream.Close();
                socket.Close();
            }

            public void Connect_Stream(string ID, string Destination)
            {
                if (active == true)
                {
                    lock (this)
                    {
                        byte[] temp;
                        string text;
                        string LogMessage;

                        WaitForSessionCreateReply();

                        text = "STREAM CONNECT ID=" + ID + " DESTINATION=" + Destination + "\n";
                        temp = StrToByteArray(text);

                        LogMessage = "\t\t\t<-- Connect Stream-->\n";
                        LogMessage += text;
                        LogReceivedHandlerClient(LogMessage);

                        if (_samStream.CanWrite == true)
                        {
                            _samStream.Write(temp, 0, temp.Length);
                            _samStream.Flush();
                        }
                        else
                            LogReceivedHandlerClient("\t\t<-- Connect_Stream can't write in _samStream -->");

                    }
                }
            }
            public void Naming_Lookup(string Name)
            {
                if (active == true)
                {
                    byte[] temp;
                    string text;
                    string LogMessage;

                    WaitForSessionCreateReply();
                    text = "NAMING LOOKUP NAME=" + Name + "\n";
                    temp = StrToByteArray(text);

                    LogMessage = "\t\t\t<-- Naming Lookup-->\n";
                    LogMessage += text;

                    LogReceivedHandlerClient(LogMessage);
                    _samStream.Write(temp, 0, temp.Length);
                    _samStream.Flush();
                }

            }
            public void sendSamConnectionHandshake()
            {
                if (active == true)
                {
                    string LogMessage;
                    byte[] temp;
                    temp = StrToByteArray(samMessage);

                    LogMessage = "\t\t\t<-- sendSamConnectionHandshake-->\n";
                    LogMessage += samMessage;
                    LogReceivedHandlerClient(LogMessage);

                    _samStream.Write(temp, 0, temp.Length);
                    _samStream.Flush();
                }
            }
            public void sendStream(string ID, string DATA)
            {
                if (active == true)
                {
                    string LogMessage;
                    string text;
                    byte[] temp;

                    WaitForSessionCreateReply();
                    text = "STREAM SEND ID=" + ID + " SIZE=" + DATA.Length + "\n" + DATA;
                    temp = StrToByteArray(text);
                    LogMessage = "\t\t\t<-- Send Stream-->\n";
                    LogMessage += "\nID:\t" + ID;
                    LogMessage += "\n"+text;


                    LogReceivedHandlerClient(LogMessage);
                    _samStream.Write(temp, 0, temp.Length);
                    _samStream.Flush();
                }

            }

            public void closeStream(string ID)
            {
                if (active == true)
                {
                    string LogMessage;
                    string text;
                    byte[] temp;

                    WaitForSessionCreateReply();
                    text = "STREAM CLOSE ID=" + ID + "\n";
                    temp = StrToByteArray(text);

                    LogMessage = "\t\t\t<-- Close Stream-->\n";
                    LogMessage += text;
                    LogReceivedHandlerClient(LogMessage);

                    _samStream.Write(temp, 0, temp.Length);
                    _samStream.Flush();
                }
            }
            public void StartReading()
            {
                ThreadStart threadStart = new ThreadStart(RunThread);
                Thread thread = new Thread(threadStart);
                thread.Name = "SAM Reader";
                thread.Start();
            }
            private void RunThread()
            {
                byte[] buff;
                byte[] byteArray;
                  
                while (active == true)
                    {
                        buff = new Byte[1024];
                        string line = null;

                        MemoryStream mem = new MemoryStream();// Recivebuffer                  
                        
                        try
                        {
                            lock (this)
                            {
                                if (socket.Connected == false) 
                                    LogReceivedHandlerClient("\t\t\t\t<-- Verbindung Socket ist abgebrochen -->");
                                
                                while (socket.Available > 0)
                                {
                                    int bytesRead = socket.Receive(buff, buff.Length, SocketFlags.None);
                                    if (bytesRead <= 0) continue;
                                    mem.Write(buff, 0, bytesRead);
                                }
                                
                                if (mem.Length > 0)
                                {

                                    System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
                                    line = enc.GetString(mem.ToArray());

                                    if (line != null)
                                    {
                                        int firstIndexOf;
                                        int currentIndex;
                                        string currentPacket;
                                        int nutzdatenlange;

                                        currentIndex = 0;
                                        firstIndexOf = 0;
                                        nutzdatenlange = 0;

                                        do
                                        {
                                            
                                            firstIndexOf=line.IndexOf('\n',currentIndex);
                                            if (firstIndexOf == -1) firstIndexOf = 0;

                                            currentPacket = line.Substring(currentIndex, firstIndexOf - currentIndex);
                                            if (currentPacket.IndexOf("STREAM RECEIVED") != -1 && currentPacket.IndexOf("SIZE") != -1)
                                            {
                                                nutzdatenlange = Convert.ToInt32(currentPacket.Substring(currentPacket.IndexOf("SIZE")+5,currentPacket.Length-(currentPacket.IndexOf("SIZE")+5)));

                                                while ((firstIndexOf+1 + nutzdatenlange) > mem.Length)
                                                {
                                                    if (socket.Connected == false)
                                                    {
                                                        LogReceivedHandlerClient("\t\t\t\t<-- The Socketconnection ist Brocken -->");
                                                        break;
                                                    }
                                                    while (socket.Available > 0)
                                                    {
                                                        int bytesRead = socket.Receive(buff, buff.Length, SocketFlags.None);
                                                        if (bytesRead <= 0) continue;
                                                        mem.Write(buff, 0, bytesRead);
                                                    }

                                                }
                                                line = enc.GetString(mem.ToArray());

                                                mem.Seek(firstIndexOf+1, SeekOrigin.Begin);
                                                byteArray = new byte[nutzdatenlange];
                                                mem.Read(byteArray, 0,nutzdatenlange);
                                                
                                                analyse(currentPacket,byteArray);
                                                currentIndex = firstIndexOf + 1 + nutzdatenlange;
                                            }
                                            else
                                            {
                                                byteArray = new byte[0];
                                                analyse(currentPacket, byteArray);
                                                currentIndex = firstIndexOf + 1;
                                            }

                                        } while (line.IndexOf('\n', currentIndex) != -1);
                                        mem.Close();
                                    }
                                }
                                else
                                    Thread.Sleep(900);
                            }

                        }
                        catch
                        {
                            LogReceivedHandlerClient("\t\t<-- Error reading from SAM: -->\n" + line);
                        }
                        
                    }
            }

            public  bool WaitForHelloReply()
            {
                while (true)
                {
                    lock (_helloLock)
                    {
                        if (_helloOk == null)
                            Monitor.Wait(_helloLock);
                        else
                            return Boolean.Parse(_helloOk);
                    }
                }
            }
            public virtual bool WaitForSessionCreateReply()
            {
                while (true)
                {
                    lock (_sessionCreateLock)
                    {
                        if (_sessionCreateOk == null)
                            Monitor.Wait(_sessionCreateLock);
                        else
                            return Boolean.Parse(_sessionCreateOk);
                    }
                }
            }

            public virtual bool WaitForstreamConnectionReply()
            {
                while (true)
                {
                    lock (_streamConnectionLock)
                    {
                        if (_StreamConnectionOk == null)
                            Monitor.Wait(_StreamConnectionOk);
                        else
                            return Boolean.Parse(_StreamConnectionOk);
                    }
                }
            }


            private void analyse(string Buffer, Byte[] buff)
            {

                string []temp= Buffer.Split(' ');

                    switch (temp[0])
                    {
                        case "HELLO":


                            if (temp[2].CompareTo("RESULT=OK") == 0)
                            {
                                lock (_helloLock)
                                {
                                    _helloOk = Boolean.TrueString;
                                    Monitor.PulseAll(_helloLock);
                                }
                                HelloReplyReceived(true);
                            }
                            else
                            {
                                lock (_helloLock)
                                {
                                    _helloOk = Boolean.FalseString;  
                                    Monitor.PulseAll(_helloLock);
                                }
                                HelloReplyReceived(false);
                            }
                   
                            
                            break;
                        case "SESSION":
                            if (temp[1].CompareTo("STATUS") == 0)
                            {
                                lock (_sessionCreateLock)
                                {
                                    string[] temp2;
                                    string result;
                                    string destination;

                                    //result Code
                                    temp2 = temp[2].Split('=');
                                    result = temp2[1];

                                    //Destination
                                    temp2 = temp[3].Split('=');
                                    destination = temp2[1];

                                    if (result.CompareTo("OK") == 0)
                                    {
                                        _sessionCreateOk = Boolean.TrueString;
                                    }
                                    else
                                    {
                                        _sessionCreateOk = Boolean.FalseString;
                                    }
                                    Monitor.PulseAll(_sessionCreateLock);
                                    if (temp.GetUpperBound(0)>3)
                                    {
                                        SessionStatusReceived(result, destination, temp[4]);
                                    }
                                    else
                                        SessionStatusReceived(result, destination, "");
                                }
                            }
                            break;
                        case "STREAM":
                            if (temp[1].CompareTo("STATUS") == 0)
                            {
                                string[] temp2;
                                string Result;
                                string ID;

                                temp2 = temp[2].Split('=');
                                Result = temp2[1];
                                
                                temp2 = temp[3].Split('=');
                                ID = temp2[1];
                                if (temp.GetUpperBound(0) > 3)
                                    StreamStatusReceived(Result,ID,temp[4]);
                                else
                                    StreamStatusReceived(Result, ID, "");
                                break;
                            }
                            else if (temp[1].CompareTo("CONNECTED") == 0)
                            {
                                string[] temp2;
                                string Destination;
                                string ID;

                                temp2 = temp[2].Split('=');
                                Destination = temp2[1];

                                temp2 = temp[3].Split('=');
                                ID = temp2[1];

                                lock (_streamConnectionLock)
                                {
                                    _StreamConnectionOk = Boolean.TrueString;
                                    Monitor.PulseAll(_streamConnectionLock);
                                }
                                StreamConnectedReceived(Destination,ID);
                                break;
                            }
                            else if (temp[1].CompareTo("CLOSED") == 0)
                            {
                                string[] temp2;
                                string Result="";
                                string ID="";
                                string Message ="";

                                temp2 = temp[2].Split('=');
                                if(temp2[0].CompareTo("RESULT")==0)
                                    Result = temp2[1];
                                else if(temp2[0].CompareTo("ID") == 0)
                                    ID = temp2[1];

                                temp2 = temp[3].Split('=');

                                if (temp2[0].CompareTo("RESULT") == 0)
                                    Result = temp2[1];
                                else if (temp2[0].CompareTo("ID") == 0)
                                    ID = temp2[1];

                                if (Buffer.IndexOf("MESSAGE") != -1)
                                {
                                    Message = Buffer.Substring(Buffer.IndexOf("MESSAGE") + 8);
                                }

                                StreamClosedReceived(Result, ID, Message);
                                break;                             
                           }
                            else if (temp[1].CompareTo("RECEIVED") == 0)
                            {
                                string[] temp2;
                                string ID;
                                int Size;
                                
                                temp2 = temp[2].Split('=');
                                ID = temp2[1];

                                temp2 = temp[3].Split('=');
                                Size=Convert.ToInt32(temp2[1]);

                                StreamDataReceived(ID, buff, 0, Size);
                            }
                            break;
                        case "DATAGRAMM":
                            //wird spter impl.
                            break;
                        case "RAW":
                            //wird spter impl.
                            break;
                        case "NAMING":
                            if (temp[1].CompareTo("REPLY") == 0)
                            {
                                string Result;
                                string Name;
                                string Value;
                                string[] temp2;

                                temp2 = temp[2].Split('=');
                                Result = temp2[1];
                                
                                temp2 = temp[3].Split('=');
                                Name = temp2[1];

                                temp2 = temp[4].Split('=');
                                Value = temp2[1];

                                if (temp.GetUpperBound(0) > 4)
                                    NamingReplyReceived(Name, Result, Value, temp[5]);
                                else
                                    NamingReplyReceived(Name, Result, Value, "");
                            }
                            break;
                            
                        default:
                            {
                                UnknownMessageReceived(Buffer);
                                break;
                            }
                    }
                
            }   
        }

        public static byte[] StrToByteArray(string str)
        {
            System.Text.ASCIIEncoding encoding = new System.Text.ASCIIEncoding();
            return encoding.GetBytes(str);
        }

    }
}
