/*******************************************************************************************
                                   <-- Effected SAM Messages -->
 
    
                             4. Bytes vor the Paket length (because SAM perhaps buffering multiple send message together)
                                          |
                                          |
    STREAM SEND ID=$ID Size=$numBytes\n[....----$numBytes of Data]
                                              |
                                              |
                             The first 4. Bytes (Hex) of the Data are reservend for the Protocol
 
 * 
 * 

    STREAM RECIVED DESTINATION=$base64key SIZE=$numBytes\n[-----$numBytes of Data]]
                                                             |
                                                             |
                           The first 4. Bytes (Hex) of the Data are reservend for the Protocol
 
 
 Notize:
    SIZE=$numBytes must include the 4 Bytes...
 */


/********************************************************************************************
                                        <-- The Protocol Design-->     
 [ ] [ ] [ ]  [ ]  <-(4. Bytes Hex)
  |   |   |    |
  |-----------------------------------> Category like Chat,Filetransfer....
      |   |    |                      
      |---|----|----------------------> [0] for Command || [1] for Message
          |    |
          |----|----------------------> Command Or Message ID
               |
               |----------------------> Command Or Message ID
  
 
  

 [ ]  [ ] [ ] [ ]
  |
  |
 [0]---------------------> <__Divers__>
  |   [ ] [ ] [ ]
  |    |   
  |    0 --------------------> Commands
  |    0  [ ] [ ]
  |    0   |   |
  |    0   0   0                  = get_Protocollversion
  |    0   0   1                  = get_Clientversion
  |    0   0   2                  = get_Clientname
  |    |
  |    1 --------------------> Messages
  |    1  [ ] [ ]
  |    1   |   |
  |    1   0   0                  = answer of get_Protocollversion
  |    1   0   1                  = answer of get_Clientversion
  |    1   0   2                  = answer of get_Clientname
  |        
  |  
 [1]---------------------> <__ClientStatus__>
  |    [ ] [ ] [ ]
  |     |
  |     0--[ ]-[ ]------------> Commands
  |     0   |   |
  |     0   0   0                 = get_onlineStatus 
  |     0   0   1                 = BLOCK_HIM 
  |     0   0   2                 = UNBLOCK_HIM 
  |     |
  |     1---------------------> Messages
  |     1  [ ] [ ]
  |     |   |   |
  |     1   0   0                 = online   
  |     1   0   1                 = short away
  |     1   0   2                 = dont't disturb
  |     1   0   3                 = invisible  
  |     1   0   4                 = like to chat
  |
  |
 [2]---------------------> <__Chat__>
  |    [ ] [ ] [ ]
  |     |
  |     0--[ ]-[ ]------------> Commands
  |     |
  |     |
  |     1---------------------> Messages
  |     1  [ ] [ ]
  |     1   |   | 
  |     1   0   0                = chat_message
  |
  |
 [3]---------------------> <__User Details__> 
  |    [ ] [ ] [ ]
  |     |
  |     0--[ ]-[ ]------------> Commands
  |     0   |   |
  |     0   0   0                 = get_Nickname
  |     0   0   1                 = get_allUserdetails
  |     |
  |     |
  |     1---------------------> Messages
  |     1  [ ] [ ] 
  |     1   |   | 
  |     1   0   0                 = answer of Nickname
  |     1   0   1                 = answer age
  |     1   0   2                 = answer Gender
  |     1   0   3                 = answer Interests
  |     1   0   4                 = answer other Informations (rtf)
  |
  |
                 more will coming soon ;-)
 
 */


using System;
using System.Collections.Generic;
using System.Text;
using System.Globalization;


using i2p_connection;

namespace I2P_Messenger
{
    public class Protocol
    {
        public delegate void StreamDataReceivedHandler(string id, byte[] data, int offset, int length);

        private const string Protocollversion = "0.1";
        private const string ClientName = "I2P-Messenger";
        private const string ClientVersion = "Beta 0.1";


        private i2p_connection_Class cI2P;
        private Core cCore;


        public Protocol(i2p_connection_Class cI2P, Core cCore)
        {
            this.cI2P = cI2P;
            this.cCore = cCore;
            
            cI2P.StreamDataReceivedHandlerClient += new i2p_connection_Class.StreamDataReceivedHandler(onStreamDataReceived);

        }

        public class ProtocoTags
        {
            public cDivers DIVERS;
            public cClientStatus CLIENTSTATUS;
            public cChat CHAT;
            public cUserDetails USERDETAILS;


            public ProtocoTags()
            {
                DIVERS = new cDivers();
                CLIENTSTATUS = new cClientStatus();
                CHAT = new cChat();
                USERDETAILS = new cUserDetails();
            }

            public class cDivers
            {
                public enumCommands Commands;
                public enumMessages Messages;
                
                public enum enumCommands { get_ClientName, get_ClientVersion, get_ProtocollVersion };
                public enum enumMessages {Protocollversion,Clientversion,Clientname}

                public cDivers()
                {
                    Commands = new enumCommands();
                    Messages = new enumMessages();
                }
            }
            public class cClientStatus
            {
                public enumCommands Commands;
                public enumMessages Messages;

                public enum enumCommands { get_onlineStatus,BLOCK_HIM,UNBLOCK_HIM };
                public enum enumMessages {online,short_away,dont_disturb,like_to_chat,invisible};
                public cClientStatus()
                {
                    this.Commands = new enumCommands();
                    this.Messages = new enumMessages();
                }
            }
            public class cChat
            {
                public enumCommands Commands;
                public enumMessages Messages;
                public enum enumCommands { };
                public enum enumMessages {chatMessage};
                
                public cChat()
                {
                    Commands = new enumCommands();
                    Messages = new enumMessages();
                }
            }
            public class cUserDetails
            {
                public enum enumCommands { get_Nickname, get_allUserdetails};
                public enum enumMessages { Nickname, age, Gender, Interests, other_Informations };

                public enumCommands Commands;
                public enumMessages Messages;

                public cUserDetails()
                {
                    Commands = new enumCommands();
                    Messages = new enumMessages();
                }
            }

        }

        public void send(string ID, string Data, ProtocoTags.cDivers.enumCommands Tag)
        {
            //Divers Commands
            switch (Tag)
            {
                case ProtocoTags.cDivers.enumCommands.get_ProtocollVersion:
                    Data = Data.Insert(0, ToHex(Data.Length) + "0000");
                    break;

                case ProtocoTags.cDivers.enumCommands.get_ClientVersion:
                    Data = Data.Insert(0, ToHex(Data.Length) + "0001");
                    break;

                case ProtocoTags.cDivers.enumCommands.get_ClientName:
                    Data = Data.Insert(0, ToHex(Data.Length) + "0002");
                    break;
            }
            cI2P.Stream_Send(ID, Data);
        }
        public void send(string ID, string Data, ProtocoTags.cDivers.enumMessages Tag)
         {  //Divers Messages

             switch(Tag)
             {
                   
                case ProtocoTags.cDivers.enumMessages.Protocollversion:
                    Data = Data.Insert(0, ToHex(Data.Length) + "0100");
                    break;

                case ProtocoTags.cDivers.enumMessages.Clientversion:
                    Data = Data.Insert(0, ToHex(Data.Length) + "0101");
                    break;

                case ProtocoTags.cDivers.enumMessages.Clientname:
                    Data = Data.Insert(0, ToHex(Data.Length) + "0102");
                    break;
                }
                cI2P.Stream_Send(ID, Data);
         }
        public void send(string ID, string Data, ProtocoTags.cClientStatus.enumCommands Tag)
        {  //Clientstatus Commands
            switch (Tag)
            {
                case ProtocoTags.cClientStatus.enumCommands.get_onlineStatus:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1000");
                    break;
                case ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1001");
                    break;

                case ProtocoTags.cClientStatus.enumCommands.UNBLOCK_HIM:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1002");
                    break;

            }
            cI2P.Stream_Send(ID, Data);
        }
        public void send(string ID, string Data, ProtocoTags.cClientStatus.enumMessages Tag)
        {
            switch (Tag)
            {
                case ProtocoTags.cClientStatus.enumMessages.online:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1100");
                    break;

                case ProtocoTags.cClientStatus.enumMessages.short_away:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1101");
                    break;

                case ProtocoTags.cClientStatus.enumMessages.dont_disturb:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1102");
                    break;

                case ProtocoTags.cClientStatus.enumMessages.invisible:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1103");
                    break;

                case ProtocoTags.cClientStatus.enumMessages.like_to_chat:
                    Data = Data.Insert(0, ToHex(Data.Length) + "1104");
                    break;
            }
            cI2P.Stream_Send(ID, Data);
        }
        public void send(string ID, string Data, ProtocoTags.cChat.enumCommands Tag)
        {
            //chat Commands
        }
        public void send(string ID, string Data, ProtocoTags.cChat.enumMessages Tag)
        {   //chat Messages
            switch (Tag)
            {
                case ProtocoTags.cChat.enumMessages.chatMessage:
                    Data = Data.Insert(0, ToHex(Data.Length) + "2100");
                    break;

            }
            cI2P.Stream_Send(ID, Data);
        }
        public void send(string ID, string Data, ProtocoTags.cUserDetails.enumCommands Tag)
        {//userDetails Commands
            switch (Tag)
            {
                case ProtocoTags.cUserDetails.enumCommands.get_Nickname:
                    Data = Data.Insert(0, ToHex(Data.Length) + "3000");
                    break;
                
                case ProtocoTags.cUserDetails.enumCommands.get_allUserdetails:
                    Data = Data.Insert(0, ToHex(Data.Length) + "3001");
                    break;
            }
            cI2P.Stream_Send(ID, Data);
        }
        public void send(string ID, string Data, ProtocoTags.cUserDetails.enumMessages Tag)
        {//userDetails Messages

            switch (Tag)
            {
                case ProtocoTags.cUserDetails.enumMessages.Nickname:
                    Data = Data.Insert(0, ToHex(Data.Length) + "3100");
                    break;

                case ProtocoTags.cUserDetails.enumMessages.age:
                    Data = Data.Insert(0, ToHex(Data.Length) + "3101");
                    break;

                case ProtocoTags.cUserDetails.enumMessages.Gender:
                    Data = Data.Insert(0, ToHex(Data.Length) + "3102");
                    break;

                case ProtocoTags.cUserDetails.enumMessages.Interests:
                    Data = Data.Insert(0, ToHex(Data.Length) + "3103");
                    break;
                
                case ProtocoTags.cUserDetails.enumMessages.other_Informations:
                    Data = Data.Insert(0, ToHex(Data.Length) + "3104");
                    break;
            }
            cI2P.Stream_Send(ID, Data);
        }

        public void onStreamDataReceived(string id, byte[] data, int offset, int length)
        {
            string temp;
            int packetlength;
            string protocolinformation;
            string nutzdaten;


            System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
            temp = enc.GetString(data);
            temp = temp.Substring(offset, length);

            do
            {
                packetlength = fromHex_toInt(temp.Substring(0, 4));
                protocolinformation = fromHex_toString(temp.Substring(4, 4));
               
                nutzdaten = temp.Substring(8, packetlength);
                temp = temp.Remove(0, packetlength + 8);


                switch (protocolinformation)
                {
                    // Befehle allgemein
                            case "0000":
                                    //get Protcolversion
                                      send(id, Protocollversion, ProtocoTags.cDivers.enumMessages.Protocollversion);
                                    break;
                               
                            case "0001":
                                    //get Clientversion
                                    send(id, ClientVersion,ProtocoTags.cDivers.enumMessages.Clientversion);
                                    break;
                                
                            case "0002":
                                    //get_clientname
                                    send(id, ClientName, ProtocoTags.cDivers.enumMessages.Clientname);
                                    break;
                                
                    //-------------------------------------------------------------
                    // antworten allgemein
                            case "0100":
                                    //Protcolversion
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.ProcolVersion, nutzdaten);
                                    break;
                                
                            case "0101":
                                    //Clientversion
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.ClientVersion, nutzdaten);
                                    break;
                            case "0102":
                                    //Clientname
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.ClientName, nutzdaten);
                                    break;

                    //--------------------------------------------------------------
                    // Client Befehle
                                case "1000":
                                    //get onlinestatus
                                    if (cCore.functions_forUsers.get_UserStatusByID(id) == usereintrag.userStatus.YOU_BLOCKED_HIM)
                                        send(id, "", ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM);
                                    else
                                    {
                                        send(id, "", ProtocoTags.cClientStatus.enumCommands.UNBLOCK_HIM);
                                                                                
                                        Core.enum_OnlineStatus t = cCore.get_ClientOnlineStatus();
                                        switch (t)
                                        {
                                            case Core.enum_OnlineStatus.ONLINE:
                                                send(id, "", ProtocoTags.cClientStatus.enumMessages.online);
                                                break;

                                            case Core.enum_OnlineStatus.OFFLINE:
                                                //impossible
                                                break;

                                            case Core.enum_OnlineStatus.TRY_TO_COONNECT:
                                                //allso impossible
                                                break;

                                            case Core.enum_OnlineStatus.DONT_DISTURB:
                                                send(id, "", ProtocoTags.cClientStatus.enumMessages.dont_disturb);
                                                break;

                                            case Core.enum_OnlineStatus.SHORT_AWAY:
                                                send(id, "", ProtocoTags.cClientStatus.enumMessages.short_away);
                                                break;

                                            case Core.enum_OnlineStatus.LIKE_TO_CHAT:
                                                send(id, "", ProtocoTags.cClientStatus.enumMessages.like_to_chat);
                                                break;

                                            case Core.enum_OnlineStatus.INVISIBLE:
                                                send(id, "", ProtocoTags.cClientStatus.enumMessages.invisible);
                                                break;
                                        }

                                        
                                    }
                                    break;    
                            
                            case "1001":
                                //BLOCK_HIM
                                cCore.functions_forUsers.set_userStatusByID(id, usereintrag.userStatus.YOU_WERE_BLOCKED);
                                if (nutzdaten.Length > 0)
                                    cCore.call_MessageFromCore(nutzdaten);    
                                break;

                            case "1002":
                                //UNBLOCK_HIM (only needed if you dont close the Stream)
                                //normal you unblock him if you connect him
                                cCore.functions_forUsers.set_userStatusByID(id, usereintrag.userStatus.CONNECTED);
                                break;

                    //--------------------------------------------------------------
                    // Client Messages;

                            case "1100"://online
                                cCore.functions_forUsers.set_userStatusByID(id, usereintrag.userStatus.CONNECTED);
                                break;
                             
                            case "1101": //short away
                                cCore.functions_forUsers.set_userStatusByID(id,usereintrag.userStatus.SHORT_AWAY);
                                break;

                            case "1102": //dont disturb
                                cCore.functions_forUsers.set_userStatusByID(id,usereintrag.userStatus.DONT_DISTURB);
                                break;

                            case "1103": //invisible
                                cCore.functions_forUsers.set_userStatusByID(id, usereintrag.userStatus.INVISIBLE);
                                break;

                            case "1104": //like tor chat
                                cCore.functions_forUsers.set_userStatusByID(id, usereintrag.userStatus.LIKE_TO_CHAT);
                                break;

                    //--------------------------------------------------------------
                    // Chat Messages
                            case "2100":
                                    //incoming chatmessage
                                    cCore.add_message(id, nutzdaten);
                                    break;
                    //---------------------------------------------------------------            

                    //---------------------------
                    //Befehle Userdetails

                            case "3000":
                                    //get Nickname
                                    send(id, cCore.MySettings.USER.Nickname, ProtocoTags.cUserDetails.enumMessages.Nickname);
                                    break;

                            case "3001":
                                    //get all userdetails
                                    send(id, cCore.MySettings.USER.Nickname, ProtocoTags.cUserDetails.enumMessages.Nickname);
                                    send(id, cCore.MySettings.USER.Age, ProtocoTags.cUserDetails.enumMessages.age);
                                    send(id, cCore.MySettings.USER.Gender, ProtocoTags.cUserDetails.enumMessages.Gender);
                                    send(id, cCore.MySettings.USER.Interests, ProtocoTags.cUserDetails.enumMessages.Interests);
                                    send(id, cCore.MySettings.USER.OtherInformation, ProtocoTags.cUserDetails.enumMessages.other_Informations);

                                    send(id, Protocollversion, ProtocoTags.cDivers.enumMessages.Protocollversion);
                                    send(id, ClientName, ProtocoTags.cDivers.enumMessages.Clientname);
                                    send(id, ClientVersion, ProtocoTags.cDivers.enumMessages.Clientversion);
                                    break;
                    //---------------------------
                    // Antworten UserDetails
                            case "3100":
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.UserNickname, nutzdaten);
                                    break;
                                
                            case "3101":
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.UserAge, nutzdaten);
                                    break;
                                
                            case "3102":
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.UserGender, nutzdaten);
                                    break;
                                
                            case "3103":
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.UserInterests, nutzdaten);
                                    break;
                                
                            case "3104":
                                    cCore.functions_forUsers.set_userDetails(id, usereintrag.UserDetails.UserOtherInformation, nutzdaten);
                                    break;
                    //------------------------------------------

                    
                }
            } while (temp.Length!=0);
        }


        public string ToHex(int value)
        {
            return String.Format("{0:X4}", value);
        }
        public string fromHex_toString(string value)
        {
            int temp;

            try
            {
               temp = Int32.Parse(value, NumberStyles.HexNumber);
            }
            catch
            {
                cCore.callErrorMessageFromCore("Fehler in fromHex_toString");
                return "";
            }

            return (ToHex(temp));
        }
        public int fromHex_toInt(string value)
        {
            int temp;
            try
            {
                 temp= Int32.Parse(value, NumberStyles.HexNumber);
            }
            catch
            {
                cCore.callErrorMessageFromCore("Fehler in fromHex_toInt");
                return 0;
            }
            return temp;
        }

    }
}
