using System;
using System.Collections.Generic;
using System.Text;

using i2p_connection;

namespace I2P_Messenger
{
        public class cfunctions_forUsers
        {
            private Core cCore;

            public cfunctions_forUsers(Core cCore)
            {
                this.cCore = cCore;
            }

            public string get_DestinationByID(string ID)
            {
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_id() == ID)
                        return eintrag.get_Destination();
                }
                return "";
            }
            public void add_user(usereintrag eintrag)
            {

                cCore.call_UserStatusChanged();
                cCore.users.Add(eintrag);
            }

            public void set_userStatusByID(string ID, usereintrag.userStatus Status)
            {
                for (int i = 0; i < cCore.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)cCore.users[i];
                    if (eintrag.get_id() == ID)
                    {
                        eintrag.set_Status(Status);
                        if (Status == usereintrag.userStatus.YOU_WERE_BLOCKED)
                            eintrag.set_ID(null);

                        cCore.users[i] = eintrag;
                        cCore.call_UserStatusChanged();
                        return;
                    }
                }
            }
            public void set_userStatusByDestination(string Destination, usereintrag.userStatus Status)
            {
                for (int i = 0; i < cCore.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)cCore.users[i];
                    if (eintrag.get_Destination() == Destination)
                    {
                        eintrag.set_Status(Status);
                        cCore.users[i] = eintrag;
                        cCore.call_UserStatusChanged();
                        return;
                    }
                }
            }
            
            public void set_allUserOffline()
            {
                for (int i = 0; i < cCore.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)cCore.users[i];
                    if (eintrag.get_aktStatus() != usereintrag.userStatus.YOU_BLOCKED_HIM)
                        eintrag.set_Status(usereintrag.userStatus.DISCONNECTED);
                    eintrag.set_ID(null);
                    cCore.users[i] = eintrag;
                }
                cCore.call_UserStatusChanged();
            }

            public void set_userDetails(string ID, usereintrag.UserDetails UserDetails, string DetailText)
            {
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_id() == ID)
                    {
                        switch (UserDetails)
                        {
                            case usereintrag.UserDetails.UserNickname:
                                eintrag.set_userDetail(usereintrag.UserDetails.UserNickname, DetailText);
                                break;

                            case usereintrag.UserDetails.UserAge:
                                eintrag.set_userDetail(usereintrag.UserDetails.UserAge, DetailText);
                                break;

                            case usereintrag.UserDetails.UserGender:

                                eintrag.set_userDetail(usereintrag.UserDetails.UserGender, DetailText);
                                break;

                            case usereintrag.UserDetails.UserInterests:
                                eintrag.set_userDetail(usereintrag.UserDetails.UserInterests, DetailText);
                                break;

                            case usereintrag.UserDetails.UserOtherInformation:
                                eintrag.set_userDetail(usereintrag.UserDetails.UserOtherInformation, DetailText);
                                break;

                            case usereintrag.UserDetails.ProcolVersion:
                                eintrag.set_userDetail(usereintrag.UserDetails.ProcolVersion, DetailText);
                                break;

                            case usereintrag.UserDetails.ClientVersion:
                                eintrag.set_userDetail(usereintrag.UserDetails.ClientVersion, DetailText);
                                break;

                            case usereintrag.UserDetails.ClientName:
                                eintrag.set_userDetail(usereintrag.UserDetails.ClientName, DetailText);
                                break;

                            default:
                                cCore.callErrorMessageFromCore("Set Unknown UserDetail, detail ignored");
                                break;

                        }

                        if (eintrag.get_AllUserDetailsRecived() == true)
                            cCore.callAllUserDetailsRecived(eintrag.get_Destination());

                        return;
                    }
                }
            }

            public bool have_allreadyOneUserDetailWindow(string Destination)
            {
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_Destination() == Destination)
                    {
                        return eintrag.get_haveACurrentUserDetailWindow();
                    }
                }
                return true;
            }
            public void set_haveallreadyOneUserDetailWindow(bool status, string Destination)
            {
                for (int i = 0; i < cCore.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)cCore.users[i];
                    if (eintrag.get_Destination() == Destination)
                    {
                        eintrag.set_haveACurrentUserDetailWindow(status);
                        cCore.users[i] = eintrag;
                        return;
                    }
                }

            }

            public void removeUserByDestination(string Destination)
            {
                for (int i = 0; i < cCore.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)cCore.users[i];
                    if (eintrag.get_Destination() == Destination)
                    {
                        //falls eine verbindung steht oder versucht wird aufzubauen diese schlieen
                        if (eintrag.get_aktStatus() == usereintrag.userStatus.CONNECTED ||
                            eintrag.get_aktStatus() == usereintrag.userStatus.TRY_TO_CONNECT)
                            cCore.closeStreamByID(eintrag.get_id());

                        cCore.users.RemoveAt(i);
                        break;
                    }

                }
                cCore.call_UserStatusChanged();
                return;
            }

            public string get_NicknameByDestination(string Destination)
            {
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_Destination() == Destination)
                    {
                        return eintrag.get_Nickname();
                    }
                }
                return "";

            }

            public void changeNicknameByDestination(string Destination, string newNickname)
            {
                for (int i = 0; i < cCore.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)cCore.users[i];
                    if (eintrag.get_Destination() == Destination)
                    {
                        eintrag.set_Nickname(newNickname);
                        cCore.users[i] = eintrag;
                        cCore.call_UserStatusChanged();
                        return;
                    }
                }
            }

            public string get_ID_byDestination(string Destination)
            {
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_Destination() == Destination)
                    {
                        return eintrag.get_id();
                    }

                }
                return null;
            }

            public void block_userByDestination(string Destination)
            {
                for (int i = 0; i < cCore.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)cCore.users[i];

                    if (eintrag.get_Destination() == Destination)
                    {
                        if (eintrag.get_aktStatus() == usereintrag.userStatus.CONNECTED)
                        {
                            cCore.functions_forUsers.set_userStatusByDestination(Destination, usereintrag.userStatus.YOU_BLOCKED_HIM);
                            cCore.Protocol.send(eintrag.get_id(), "", Protocol.ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM);
                            cCore.closeStreamByID(eintrag.get_id());
                        }
                        else if (eintrag.get_aktStatus() == usereintrag.userStatus.TRY_TO_CONNECT) 
                        {
                            cCore.functions_forUsers.set_userStatusByDestination(Destination, usereintrag.userStatus.YOU_BLOCKED_HIM);
                            cCore.closeStreamByID(eintrag.get_id());
                        }
                        else if(eintrag.get_aktStatus()==usereintrag.userStatus.DISCONNECTED ||
                            eintrag.get_aktStatus()==usereintrag.userStatus.CANT_REACH)
                        {
                            cCore.functions_forUsers.set_userStatusByDestination(Destination, usereintrag.userStatus.YOU_BLOCKED_HIM);
                        }
                        eintrag.set_ID(null);
                        cCore.users[i] = eintrag;
                        cCore.call_UserStatusChanged();
                        return;
                        
                    }
                }

            }

            public usereintrag.userStatus get_UserStatusByID(string ID)
            {
                foreach(usereintrag eintrag  in  cCore.users)
                {
                    if (eintrag.get_id() == ID)
                    {
                        return eintrag.get_aktStatus();
                    }
                }
                return usereintrag.userStatus.DISCONNECTED;
            
            
            }

            public usereintrag.userStatus get_UserStatusByDestination(string Destination)
            {
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_Destination() == Destination)
                    {
                        return eintrag.get_aktStatus();
                    }
                }
                return usereintrag.userStatus.DISCONNECTED;


            }

            public string get_userDetail(string Destination, usereintrag.UserDetails UserDetails)
            {
                foreach (usereintrag eintrag in cCore.users)
                {
                    if (eintrag.get_Destination() == Destination)
                    {
                        switch (UserDetails)
                        {
                            case usereintrag.UserDetails.UserNickname:
                                return eintrag.get_userDetail(usereintrag.UserDetails.UserNickname);

                            case usereintrag.UserDetails.UserAge:
                                return eintrag.get_userDetail(usereintrag.UserDetails.UserAge);

                            case usereintrag.UserDetails.UserGender:
                                return eintrag.get_userDetail(usereintrag.UserDetails.UserGender);

                            case usereintrag.UserDetails.UserInterests:
                                return eintrag.get_userDetail(usereintrag.UserDetails.UserInterests);

                            case usereintrag.UserDetails.UserOtherInformation:
                                return eintrag.get_userDetail(usereintrag.UserDetails.UserOtherInformation);

                            case usereintrag.UserDetails.ClientName:
                                return eintrag.get_userDetail(usereintrag.UserDetails.ClientName);

                            case usereintrag.UserDetails.ClientVersion:
                                return eintrag.get_userDetail(usereintrag.UserDetails.ClientVersion);

                            case usereintrag.UserDetails.ProcolVersion:
                                return eintrag.get_userDetail(usereintrag.UserDetails.ProcolVersion);


                            default:
                                cCore.callErrorMessageFromCore("Get Unknown UserDetail, detail ignored");
                                break;
                        }
                    }
                }
                return null;
            }

        }
    }

