using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.IO;
using System.Xml;
using System.Threading;
using System.Media;

using i2p_connection;

namespace I2P_Messenger
{

    public class Core
    {
        public event UserStatusChangedHandler UserStatusChanged;
        public event ErrorMessageFromCoreHandler ErrorMessageFromCore;
        public event MessageFromCoreHandler MessageFromCore;
        public event RequestAuthorizationHandler RequestAuthorization;

        public event AllUserDetailsRecivedHandler AllUserDetailsRecived;
        public event OnlineStatusChangedHandler OnlineStatusChanged;

        public delegate void StreamClosedReceivedHandler(string result, string id, string message);
        public delegate void StreamConnectedReceivedHandler(string remoteDestination, string id);
        public delegate void StreamStatusReceivedHandler(string result, string id, string message);
        public delegate void NamingReplyReceived(string name, string result, string valueString, string message);
        public delegate void UserStatusChangedHandler();
        public delegate void ErrorMessageFromCoreHandler(string Message);
        public delegate void AllUserDetailsRecivedHandler(string Destination);
        public delegate void StatusReceivedHandler(Status Status);
        public delegate void OnlineStatusChangedHandler();
        public delegate void MessageFromCoreHandler(string Message);

        public delegate void RequestAuthorizationHandler(string Destination, string ID,Core cCore);
        


        public Settings MySettings;
        public ArrayList users = new ArrayList();
        public Protocol Protocol;

        public cfunctions_forUsers functions_forUsers;

        //public Filetransfer filetransfer;
        private enum_OnlineStatus ClientOnlineStatus;

        public enum enum_OnlineStatus {ONLINE,OFFLINE,TRY_TO_COONNECT,SHORT_AWAY,DONT_DISTURB,LIKE_TO_CHAT,INVISIBLE}

        private i2p_connection_Class cI2P;
        private string myDestination;
        private bool isActive;
        private int UserlistTryToConnectThreadSleep_inMicroseconds;
        private int maxMessagesPerUser;

        private SoundPlayer Sound_StartSound;
        private SoundPlayer Sound_UserGoOnline;
        private SoundPlayer Sound_UserGoOffline;
        private SoundPlayer Sound_newMessage;

        public Core(i2p_connection_Class cI2P, Settings MySettings)
        {
            this.cI2P = cI2P;
            this.MySettings = MySettings;
            this.Protocol = new Protocol(cI2P, this);
            this.ClientOnlineStatus = enum_OnlineStatus.OFFLINE;
            this.functions_forUsers = new cfunctions_forUsers(this);

            cI2P.StreamClosedReceivedHandlerClient += new i2p_connection_Class.StreamClosedReceivedHandler(onStreamClosedReceived);
            cI2P.StreamConnectedReceivedHandlerClient += new i2p_connection_Class.StreamConnectedReceivedHandler(onStreamConnectedReceivedHandler);
            cI2P.StreamStatusReceivedClient += new i2p_connection_Class.StreamStatusReceivedHandler(OnStreamStatusReceived);
            cI2P.NamingReplyReceivedClient += new i2p_connection_Class.NamingReplyReceived(onNamingReplyReceived);
            cI2P.StatusReceivedHandlerClient += new i2p_connection_Class.StatusReceivedHandler(onStatusReceivedHandler);
        }

        public void start_core()
        {
            UserlistTryToConnectThreadSleep_inMicroseconds = MySettings.GENERAL.UserlistTryToConnectThreadSleep_inMicroseconds;
            maxMessagesPerUser = MySettings.GENERAL.MaxChatMessagePerUser;

            loadFromXml();
            call_UserStatusChanged();
        }
        public void init_sound()
        {
        
            if (MySettings.SOUND.Activate_userList_sounds == true)
            {
                if (File.Exists(MySettings.SOUND.User_go_OnlineSoundFile))
                    Sound_UserGoOnline = new SoundPlayer(MySettings.SOUND.User_go_OnlineSoundFile);
                else
                    ErrorMessageFromCore("File not exits: " + MySettings.SOUND.User_go_OnlineSoundFile);
                

                if (File.Exists(MySettings.SOUND.User_go_OfflineSoundFile))
                    Sound_UserGoOffline = new SoundPlayer(MySettings.SOUND.User_go_OfflineSoundFile);
                else
                    ErrorMessageFromCore("File not exits: " + MySettings.SOUND.User_go_OfflineSoundFile);
            }
            if (MySettings.SOUND.Activate_startSound == true)
                if(File.Exists(MySettings.SOUND.StartSoundFile))
                    Sound_StartSound = new SoundPlayer(MySettings.SOUND.StartSoundFile);
                else
                    ErrorMessageFromCore("File not exits: " + MySettings.SOUND.StartSoundFile);

            if (MySettings.SOUND.Activate_newMessageSound == true)
                if (File.Exists(MySettings.SOUND.NewMessageSoundFile)) 
                    Sound_newMessage = new SoundPlayer(MySettings.SOUND.NewMessageSoundFile);
                else
                    ErrorMessageFromCore("File not exits: " + MySettings.SOUND.NewMessageSoundFile);

            if (Sound_StartSound != null)
                Sound_StartSound.Play();
        }
        public void closeCore()
        {
            close_allopendStreams();
            isActive = false;
        }
        public void stopCore()
        {
            close_allopendStreams();
            isActive = false;

            cI2P.StreamClosedReceivedHandlerClient -= new i2p_connection_Class.StreamClosedReceivedHandler(onStreamClosedReceived);
            cI2P.StreamConnectedReceivedHandlerClient -= new i2p_connection_Class.StreamConnectedReceivedHandler(onStreamConnectedReceivedHandler);
            cI2P.StreamStatusReceivedClient -= new i2p_connection_Class.StreamStatusReceivedHandler(OnStreamStatusReceived);
            cI2P.StatusReceivedHandlerClient -= new i2p_connection_Class.StatusReceivedHandler(onStatusReceivedHandler);
            ClientOnlineStatus = enum_OnlineStatus.OFFLINE;
            Protocol = null;
            this.functions_forUsers.set_allUserOffline();

            if (OnlineStatusChanged != null)
                OnlineStatusChanged();


        }
        public void call_MessageFromCore(string Message)
        {
            MessageFromCore(Message);
        }

        public void restartCore(i2p_connection_Class cI2P, Settings MySettings)
        {
            this.cI2P = cI2P;
            this.MySettings = MySettings;
            this.Protocol = new Protocol(cI2P, this);
            this.ClientOnlineStatus = enum_OnlineStatus.OFFLINE;

            cI2P.StreamClosedReceivedHandlerClient += new i2p_connection_Class.StreamClosedReceivedHandler(onStreamClosedReceived);
            cI2P.StreamConnectedReceivedHandlerClient += new i2p_connection_Class.StreamConnectedReceivedHandler(onStreamConnectedReceivedHandler);
            cI2P.StreamStatusReceivedClient += new i2p_connection_Class.StreamStatusReceivedHandler(OnStreamStatusReceived);
            cI2P.NamingReplyReceivedClient += new i2p_connection_Class.NamingReplyReceived(onNamingReplyReceived);
            cI2P.StatusReceivedHandlerClient += new i2p_connection_Class.StatusReceivedHandler(onStatusReceivedHandler);

            UserlistTryToConnectThreadSleep_inMicroseconds = MySettings.GENERAL.UserlistTryToConnectThreadSleep_inMicroseconds;
            maxMessagesPerUser = MySettings.GENERAL.MaxChatMessagePerUser;
            call_UserStatusChanged();
        }
        public void loadFromXml()
        {
            try
            {
                if (File.Exists(MySettings.GENERAL.XmlUserListPfad))
                {
                    XmlDocument downloadsXmlDocument = new XmlDocument();
                    downloadsXmlDocument.Load(MySettings.GENERAL.XmlUserListPfad);


                    foreach (XmlNode userNode in downloadsXmlDocument.SelectSingleNode("UserList").SelectNodes("User"))
                    {
                        string Destination;
                        string Nickname;
                        string Status;

                        Destination = userNode.Attributes["Destination"].Value;
                        Nickname = userNode.Attributes["Nickname"].Value;
                        Status = userNode.Attributes["Status"].Value;

                        usereintrag eintrag = new usereintrag(Nickname, Destination);
                        this.functions_forUsers.add_user(eintrag);
                        if(Status==usereintrag.userStatus.YOU_BLOCKED_HIM.ToString())
                            functions_forUsers.set_userStatusByDestination(Destination,usereintrag.userStatus.YOU_BLOCKED_HIM);
                        else if (Status==usereintrag.userStatus.YOU_WERE_BLOCKED.ToString())
                            functions_forUsers.set_userStatusByDestination(Destination,usereintrag.userStatus.YOU_WERE_BLOCKED);
                    }
                }
            }
            catch
            {
                
            }

        }
        public void saveToXml()
        {
            try
            {
                if (File.Exists(MySettings.GENERAL.XmlUserListPfad))
                {
                    string backupFilePath = string.Format("{0}.bak", MySettings.GENERAL.XmlUserListPfad);
                    if (File.Exists(backupFilePath))
                    {
                        string backupBackupFilePath = string.Format("{0}.bak", backupFilePath);
                        if (File.Exists(backupBackupFilePath))
                            File.Delete(backupBackupFilePath);
                        File.Move(backupFilePath, backupBackupFilePath);
                    }
                    File.Move(MySettings.GENERAL.XmlUserListPfad, backupFilePath);
                }
            }
            catch
            {
            }

            XmlWriterSettings downloadsXmlWriterSettings = new XmlWriterSettings();
            downloadsXmlWriterSettings.CloseOutput = true;
            downloadsXmlWriterSettings.Indent = true;
            XmlWriter downloadsXmlWriter = XmlWriter.Create(MySettings.GENERAL.XmlUserListPfad, downloadsXmlWriterSettings);
            downloadsXmlWriter.WriteStartDocument();
            downloadsXmlWriter.WriteStartElement("UserList");
            foreach (usereintrag eintrag in users)
            {
                downloadsXmlWriter.WriteStartElement("User");
                downloadsXmlWriter.WriteAttributeString("Nickname", eintrag.get_Nickname());
                downloadsXmlWriter.WriteAttributeString("Destination", eintrag.get_Destination());
                
                if(eintrag.get_aktStatus()==usereintrag.userStatus.YOU_BLOCKED_HIM ||eintrag.get_aktStatus()==usereintrag.userStatus.YOU_WERE_BLOCKED)
                    downloadsXmlWriter.WriteAttributeString("Status", eintrag.get_aktStatus().ToString());
                else
                    downloadsXmlWriter.WriteAttributeString("Status", "");
                
                downloadsXmlWriter.WriteEndElement();
            }
            downloadsXmlWriter.WriteEndElement();
            downloadsXmlWriter.WriteEndDocument();
            downloadsXmlWriter.Flush();
            downloadsXmlWriter.Close();
        }
        
        public void onStatusReceivedHandler(Status Status)
        {
            /*
            SAM_CONNECTED,
            SAM_DISCONNECTED,
            SESSION_CREATED,
            SESSION_CLOSED
             */

            switch (Status)
            {
                case Status.SAM_CONNECTED:
                    this.ClientOnlineStatus = enum_OnlineStatus.TRY_TO_COONNECT;
                    break;

                case Status.SAM_DISCONNECTED:
                    this.ClientOnlineStatus = enum_OnlineStatus.OFFLINE;
                    break;

                case Status.SESSION_CREATED:
                    this.ClientOnlineStatus = enum_OnlineStatus.ONLINE;

                    isActive = true;
                    startThread();
                    break;

                case Status.SESSION_CLOSED:
                    this.ClientOnlineStatus = enum_OnlineStatus.OFFLINE;
                    break;
            }

            if (OnlineStatusChanged != null)
                OnlineStatusChanged();
        }
        public void onStreamClosedReceived(string result, string id, string message)
        {
            /*
            if (result.CompareTo("OK") != 0)
                return;
            */
            for (int i = 0; i < this.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)this.users[i];
                if (eintrag.get_id() == id)
                {
                    //verbindung erfolgreich geschlossen
                    eintrag.set_ID(null);
                    if (eintrag.get_aktStatus() != usereintrag.userStatus.YOU_WERE_BLOCKED)
                        eintrag.set_Status(usereintrag.userStatus.DISCONNECTED);

                    this.users[i] = eintrag;
                    if (Sound_UserGoOffline != null)
                        Sound_UserGoOffline.Play();


                    if (message.Length > 0)
                        eintrag.add_messageFromSystem(message);

                    call_UserStatusChanged();
                    return;
                }
                else if (eintrag.get_lastID() == id && message.Length > 0)
                {   //Vorherige verbindung
                    eintrag.add_messageFromSystem(message);
                    call_UserStatusChanged();
                    
                }
            }
        }
        public void onStreamConnectedReceivedHandler(string remoteDestination, string id)
        {
            if (Sound_UserGoOnline != null)
                Sound_UserGoOnline.Play();

            if (destinationAlreadyExits(remoteDestination) == false)
            {  //user noch nicht in liste

                if (MySettings.SECURITY.Block_al_unknown_Users == true)
                {
                    Protocol.send(id, "User only allow known user to Connect him.\nSo you were blocked !!!", Protocol.ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM);
                    cI2P.Stream_close(id);
                }
                else
                {
                    RequestAuthorization(remoteDestination, id,this);
                }
            }
            else
            {
                //user bereits in der liste

                for (int i = 0; i < this.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)this.users[i];
                    if (eintrag.get_Destination() == remoteDestination)
                    {
                        if (eintrag.get_aktStatus() == usereintrag.userStatus.DISCONNECTED || eintrag.get_aktStatus() == usereintrag.userStatus.CANT_REACH ||
                            eintrag.get_aktStatus()==usereintrag.userStatus.YOU_WERE_BLOCKED)
                        {
                            if (eintrag.get_id() == id || eintrag.get_id() == null)
                            {
                                eintrag.set_Status(usereintrag.userStatus.CONNECTED);
                                eintrag.set_ID(id);
                                this.users[i] = eintrag;
                                call_UserStatusChanged();
                                Protocol.send(id, "", Protocol.ProtocoTags.cClientStatus.enumCommands.get_onlineStatus);
                                return;
                            }
                            else
                            {
                                closeStreamByID(id);
                                return;
                            }
                        }
                        else if (eintrag.get_aktStatus() == usereintrag.userStatus.CONNECTED)
                        {/*bereits eine verbindung zum anderen chatteilnehmer
                           dass kann passieren wenn beide eine connect anfrage in geringen zeibabstand stellen
                         */

                            /*
                            //Debug Message
                            string message;

                            message = "Teilnehmer bereits verbunden !";
                            message += "\nold ID: " + eintrag.get_id();
                            message += "\nnew ID: " + id;
                            message += "\nalter stream geschlossen";
                            call_MessageFromCore(message);
                            */
                            closeStreamByID(eintrag.get_id());
                            
                            eintrag.set_ID(id);
                            eintrag.set_Status(usereintrag.userStatus.CONNECTED);
                            this.users[i] = eintrag;
                            call_UserStatusChanged();
                            Protocol.send(id, "", Protocol.ProtocoTags.cClientStatus.enumCommands.get_onlineStatus);
                            

                            //closeStreamByID(id);
                            return;


                        }
                        else if (eintrag.get_aktStatus() == usereintrag.userStatus.YOU_BLOCKED_HIM)
                        {
                         
                            Protocol.send(id, "", Protocol.ProtocoTags.cClientStatus.enumCommands.BLOCK_HIM);
                            closeStreamByID(id);
                            return;
                        }


                        else if (eintrag.get_aktStatus() == usereintrag.userStatus.TRY_TO_CONNECT)
                        {
                            closeStreamByID(eintrag.get_id());
                            eintrag.set_Status(usereintrag.userStatus.CONNECTED);
                            eintrag.set_ID(id);
                            this.users[i] = eintrag;
                            Protocol.send(id, "", Protocol.ProtocoTags.cClientStatus.enumCommands.get_onlineStatus);
                            call_UserStatusChanged();
                            return;
                        }
                    }
                }


            }





        }

        public void closeStreamByID(string ID)
        {
            cI2P.Stream_close(ID);
        }


        public void OnStreamStatusReceived(string result, string id, string message)
        {
            for (int i = 0; i < this.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)this.users[i];
                if (eintrag.get_id() == id)
                {
                    //eintrag gefunden
                    if (result.CompareTo("OK") == 0)
                    {
                        eintrag.set_Status(usereintrag.userStatus.CONNECTED);
                        //Protocol.send(id, "", Protocol.ProtocoTags.cClientStatus.enumCommands.UNBLOCK_HIM);
                        Protocol.send(id, "", Protocol.ProtocoTags.cClientStatus.enumCommands.get_onlineStatus);

                        if (Sound_UserGoOnline != null)
                            Sound_UserGoOnline.Play();
                    }
                    else if (result.CompareTo("CANT_REACH_PEER") == 0)
                    {
                        
                        eintrag.set_Status(usereintrag.userStatus.CANT_REACH);
                        eintrag.set_ID(null);

                        
                    }
                    else
                    {
                        if (eintrag.get_aktStatus() != usereintrag.userStatus.DISCONNECTED)
                            if (Sound_UserGoOffline != null)
                                Sound_UserGoOffline.Play();

                        eintrag.set_Status(usereintrag.userStatus.DISCONNECTED);
                        eintrag.set_ID(null);

                        
                    }

                    this.users[i] = eintrag;
                    call_UserStatusChanged();
                    return;
                }
            }

        }
        public void onNamingReplyReceived(string name, string result, string valueString, string message)
        {

            if (name.CompareTo("ME") == 0)
            {
                if (result.CompareTo("OK") == 0)
                {
                    myDestination = valueString;
                }

            }
        }
       

        public bool try_toStartaFileTransfer(string[] Filenames,string Destination)
        {/*
            if(this.filetransfer==null)
            {
                filetransfer = new Filetransfer(this, Destination);
                filetransfer.nit_ForSendFiles(Filetransfer.modus.SENDFILE, Filenames, 1000);
                return true;
            }
            else*/
                return false;
        }
        public enum_OnlineStatus get_ClientOnlineStatus()
        {
            return ClientOnlineStatus;
        }

        public void set_clientOnlineStatus(enum_OnlineStatus status)
        {
            ClientOnlineStatus = status;
            
            foreach(usereintrag eintrag in users)
            {
                if (eintrag.get_aktStatus() != usereintrag.userStatus.DISCONNECTED &&
                    eintrag.get_aktStatus() != usereintrag.userStatus.TRY_TO_CONNECT &&
                    eintrag.get_aktStatus() != usereintrag.userStatus.CANT_REACH &&
                    eintrag.get_aktStatus() !=usereintrag.userStatus.YOU_BLOCKED_HIM)
                {
                    switch (status)
                    {
                        case enum_OnlineStatus.DONT_DISTURB:
                            Protocol.send(eintrag.get_id(), "", Protocol.ProtocoTags.cClientStatus.enumMessages.dont_disturb);
                            break;

                        case enum_OnlineStatus.INVISIBLE:
                            Protocol.send(eintrag.get_id(), "", Protocol.ProtocoTags.cClientStatus.enumMessages.invisible);
                            break;

                        case enum_OnlineStatus.LIKE_TO_CHAT:
                            Protocol.send(eintrag.get_id(), "", Protocol.ProtocoTags.cClientStatus.enumMessages.like_to_chat);
                            break;

                        case enum_OnlineStatus.ONLINE:
                            Protocol.send(eintrag.get_id(), "", Protocol.ProtocoTags.cClientStatus.enumMessages.online);
                            break;

                        case enum_OnlineStatus.OFFLINE:
                            //impossible
                            break;

                        case enum_OnlineStatus.SHORT_AWAY:
                            Protocol.send(eintrag.get_id(), "", Protocol.ProtocoTags.cClientStatus.enumMessages.short_away);
                            break;

                        case enum_OnlineStatus.TRY_TO_COONNECT:
                            //impossible
                            break;

                    }
                }
            }
            if (OnlineStatusChanged != null)
                OnlineStatusChanged();
        }

        public void call_UserStatusChanged()
        {
            if (UserStatusChanged != null)
                UserStatusChanged();
          
        }
        public string get_myDestination()
        {
            return myDestination;
        }
        public bool destinationAlreadyExits(string destination)
        {
            foreach (usereintrag eintrag in users)
            {
                if (eintrag.get_Destination() == destination)
                    return true;
            }
            return false;
        }
        public void add_message(string id, string message)
        {
            for (int i = 0; i < this.users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)this.users[i];
                if (eintrag.get_id() == id)
                {
                    if (eintrag.Messages.Count == maxMessagesPerUser)
                        eintrag.Messages.RemoveAt(0);

                    eintrag.add_message(message);
                    if (Sound_newMessage != null)
                        Sound_newMessage.Play();

                    this.users[i] = eintrag;
                    call_UserStatusChanged();
                    return;
                }
            }
        }
        public bool have_allreadyOneChatwindow(string Destination)
        {
            foreach (usereintrag eintrag in users)
            {
                if (eintrag.get_Destination() == Destination)
                {
                    return eintrag.get_haveACurrentChatWindow();
                }
            }
            return true;

        }
        public void set_have_allreadyOneChatwindow(bool status, string Destination)
        {
            for (int i = 0; i < users.Count; i++)
            {
                usereintrag eintrag = (usereintrag)users[i];
                if (eintrag.get_Destination() == Destination)
                {
                    eintrag.set_haveACurrentChatWindow(status);
                    users[i] = eintrag;
                    return;
                }
            }


        }
        public void callErrorMessageFromCore(string message)
        {
            ErrorMessageFromCore(message);
        }
        public void callAllUserDetailsRecived(string Destination)
        {
            AllUserDetailsRecived(Destination);
        }



        private void close_allopendStreams()
        {
            foreach (usereintrag eintrag in users)
            {
                if (eintrag.get_aktStatus() == usereintrag.userStatus.CONNECTED ||
                    eintrag.get_aktStatus() == usereintrag.userStatus.TRY_TO_CONNECT)
                    cI2P.Stream_close(eintrag.get_id());
            }
        }
        private void RunThread()
        {
            while (isActive == true)
            {
                for (int i = 0; i < this.users.Count; i++)
                {
                    usereintrag eintrag = (usereintrag)this.users[i];

                    //if (eintrag.get_newUnreadMessage() == true)
                    //    call_UserStatusChanged();

                    if (eintrag.get_aktStatus() == usereintrag.userStatus.DISCONNECTED ||
                        eintrag.get_aktStatus() == usereintrag.userStatus.CANT_REACH)
                    {
                        eintrag.set_Status(usereintrag.userStatus.TRY_TO_CONNECT);
                        eintrag.set_ID(cI2P.get_nextFreeID());
                        this.users[i] = eintrag;
                        cI2P.Stream_Connect(eintrag.get_id(), eintrag.get_Destination());
                        call_UserStatusChanged();
                    }
                }
                Thread.Sleep(UserlistTryToConnectThreadSleep_inMicroseconds);
            }
        }
        private void startThread()
        {
            ThreadStart threadStart = new ThreadStart(RunThread);
            Thread thread = new Thread(threadStart);
            thread.Name = "I2P userlist status";
            thread.Start();

        }

        
        

        ~Core()
        {
          
            cI2P.StreamClosedReceivedHandlerClient -= new i2p_connection_Class.StreamClosedReceivedHandler(onStreamClosedReceived);
            cI2P.StreamConnectedReceivedHandlerClient -= new i2p_connection_Class.StreamConnectedReceivedHandler(onStreamConnectedReceivedHandler);
            cI2P.StreamStatusReceivedClient -= new i2p_connection_Class.StreamStatusReceivedHandler(OnStreamStatusReceived);
            cI2P.StatusReceivedHandlerClient -= new i2p_connection_Class.StatusReceivedHandler(onStatusReceivedHandler);
            isActive = false;
            saveToXml();
            Protocol = null;
        }




       
       
    }
}

