/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.util.ResettableGZIPOutputStream;

public class ReusableGZIPOutputStream
extends ResettableGZIPOutputStream {
    private static final boolean ENABLE_CACHING = !System.getProperty("java.vendor").startsWith("Apache");
    private static final LinkedBlockingQueue<ReusableGZIPOutputStream> _available = ENABLE_CACHING ? new LinkedBlockingQueue(16) : null;
    private ByteArrayOutputStream _buffer = (ByteArrayOutputStream)this.out;

    public static ReusableGZIPOutputStream acquire() {
        ReusableGZIPOutputStream rv = null;
        if (ENABLE_CACHING) {
            rv = _available.poll();
        }
        if (rv == null) {
            rv = new ReusableGZIPOutputStream();
        }
        return rv;
    }

    public static void release(ReusableGZIPOutputStream out) {
        out.reset();
        if (ENABLE_CACHING) {
            _available.offer(out);
        }
    }

    private ReusableGZIPOutputStream() {
        super(new ByteArrayOutputStream(40960));
    }

    public void reset() {
        super.reset();
        this._buffer.reset();
        this.def.setLevel(9);
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public byte[] getData() {
        return this._buffer.toByteArray();
    }
}

