/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.i2p.util.LookaheadInputStream;

public class ResettableGZIPInputStream
extends InflaterInputStream {
    private static final int FOOTER_SIZE = 8;
    private static final boolean DEBUG = false;
    private LookaheadInputStream _lookaheadStream;
    private CRC32 _crc32;
    private byte[] _buf1 = new byte[1];
    private boolean _complete = false;

    public ResettableGZIPInputStream() {
        super(new LookaheadInputStream(8), new Inflater(true));
        this._lookaheadStream = (LookaheadInputStream)this.in;
        this._crc32 = new CRC32();
    }

    public ResettableGZIPInputStream(InputStream compressedStream) throws IOException {
        this();
        this.initialize(compressedStream);
    }

    public void initialize(InputStream compressedStream) throws IOException {
        this.len = 0;
        this.inf.reset();
        this._complete = false;
        this._crc32.reset();
        this._buf1[0] = 0;
        this._lookaheadStream.initialize(compressedStream);
        this.verifyHeader();
    }

    public int read() throws IOException {
        if (this._complete) {
            return -1;
        }
        int read = this.read(this._buf1, 0, 1);
        if (read == -1) {
            return -1;
        }
        return this._buf1[0];
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this._complete) {
            return -1;
        }
        int read = super.read(buf, off, len);
        if (read == -1) {
            this.verifyFooter();
            return -1;
        }
        this._crc32.update(buf, off, read);
        if (this._lookaheadStream.getEOFReached()) {
            this.verifyFooter();
            this.inf.reset();
            this._complete = true;
        }
        return read;
    }

    long getCurrentCRCVal() {
        return this._crc32.getValue();
    }

    void verifyFooter() throws IOException {
        long expectedCRCVal;
        byte[] footer = this._lookaheadStream.getFooter();
        if (footer[0] != (byte)((expectedCRCVal = this._crc32.getValue()) & 0xFFL)) {
            throw new IOException("footer[0]=" + footer[0] + " expectedCRC[0]=" + (expectedCRCVal & 0xFFL));
        }
        if (footer[1] != (byte)(expectedCRCVal >>> 8)) {
            throw new IOException("footer[1]=" + footer[1] + " expectedCRC[1]=" + (expectedCRCVal >>> 8 & 0xFFL));
        }
        if (footer[2] != (byte)(expectedCRCVal >>> 16)) {
            throw new IOException("footer[2]=" + footer[2] + " expectedCRC[2]=" + (expectedCRCVal >>> 16 & 0xFFL));
        }
        if (footer[3] != (byte)(expectedCRCVal >>> 24)) {
            throw new IOException("footer[3]=" + footer[3] + " expectedCRC[3]=" + (expectedCRCVal >>> 24 & 0xFFL));
        }
        int expectedSizeVal = this.inf.getTotalOut();
        if (footer[4] != (byte)expectedSizeVal) {
            throw new IOException("footer[4]=" + footer[4] + " expectedSize[0]=" + (expectedSizeVal & 0xFF));
        }
        if (footer[5] != (byte)(expectedSizeVal >>> 8)) {
            throw new IOException("footer[5]=" + footer[5] + " expectedSize[1]=" + (expectedSizeVal >>> 8 & 0xFF));
        }
        if (footer[6] != (byte)(expectedSizeVal >>> 16)) {
            throw new IOException("footer[6]=" + footer[6] + " expectedSize[2]=" + (expectedSizeVal >>> 16 & 0xFF));
        }
        if (footer[7] != (byte)(expectedSizeVal >>> 24)) {
            throw new IOException("footer[7]=" + footer[7] + " expectedSize[3]=" + (expectedSizeVal >>> 24 & 0xFF));
        }
    }

    private void verifyHeader() throws IOException {
        int c = this.in.read();
        if (c != 31) {
            throw new IOException("First magic byte was wrong [" + c + "]");
        }
        c = this.in.read();
        if (c != 139) {
            throw new IOException("Second magic byte was wrong [" + c + "]");
        }
        c = this.in.read();
        if (c != 8) {
            throw new IOException("Compression format is invalid [" + c + "]");
        }
        int flags = this.in.read();
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME0 [" + c + "]");
        }
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME1 [" + c + "]");
        }
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME2 [" + c + "]");
        }
        c = this.in.read();
        if (c == -1) {
            throw new IOException("EOF on MTIME3 [" + c + "]");
        }
        c = this.in.read();
        if (c != 0 && c != 2 && c != 4) {
            throw new IOException("Invalid extended flags [" + c + "]");
        }
        c = this.in.read();
        if (0 != (flags & 0x20)) {
            int _len = 0;
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the extra header");
            }
            _len = c;
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the extra header");
            }
            _len += c << 8;
            for (int i = 0; i < _len; ++i) {
                c = this.in.read();
                if (c != -1) continue;
                throw new IOException("EOF reading the extra header's body");
            }
        }
        if (0 != (flags & 0x10)) {
            c = this.in.read();
            while (c != 0) {
                if (c == -1) {
                    throw new IOException("EOF reading the name");
                }
                c = this.in.read();
            }
        }
        if (0 != (flags & 8)) {
            c = this.in.read();
            while (c != 0) {
                if (c == -1) {
                    throw new IOException("EOF reading the comment");
                }
                c = this.in.read();
            }
        }
        if (0 != (flags & 0x40)) {
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the CRC16");
            }
            c = this.in.read();
            if (c == -1) {
                throw new IOException("EOF reading the CRC16");
            }
        }
    }
}

