/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class EepPost {
    private I2PAppContext _context;
    private Log _log;
    private static final String CRLF = "\r\n";

    public EepPost() {
        this(I2PAppContext.getGlobalContext());
    }

    public EepPost(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(EepPost.class);
    }

    public void postFiles(String url, String proxyHost, int proxyPort, Map fields, Runnable onCompletion) {
        I2PThread postThread = new I2PThread(new Runner(url, proxyHost, proxyPort, fields, onCompletion));
        postThread.start();
    }

    private long calcContentLength(String sep, Map fields) {
        long len = 0L;
        for (String key : fields.keySet()) {
            Object val = fields.get(key);
            if (val instanceof File) {
                File f = (File)val;
                len += (long)("--" + sep + CRLF + "Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + f.getName() + "\"" + CRLF).length();
                len += (long)"Content-Type: application/octet-stream\r\n\r\n".length();
                len += f.length();
                len += (long)CRLF.length();
                continue;
            }
            len += (long)("--" + sep + CRLF + "Content-Disposition: form-data; name=\"" + key + "\"" + CRLF + CRLF).length();
            len += (long)val.toString().length();
            len += (long)CRLF.length();
        }
        return len += (long)(2 + sep.length() + 2 + CRLF.length());
    }

    private void sendFields(OutputStream out, String separator, Map fields) throws IOException {
        for (String field : fields.keySet()) {
            Object val = fields.get(field);
            if (val instanceof File) {
                this.sendFile(out, separator, field, (File)val);
                continue;
            }
            this.sendField(out, separator, field, val.toString());
        }
        out.write(("--" + separator + "--" + CRLF).getBytes());
    }

    private void sendFile(OutputStream out, String separator, String field, File file) throws IOException {
        out.write(("--" + separator + CRLF).getBytes());
        out.write(("Content-Disposition: form-data; name=\"" + field + "\"; filename=\"" + file.getName() + "\"" + CRLF).getBytes());
        out.write("Content-Type: application/octet-stream\r\n\r\n".getBytes());
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int read = -1;
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
        }
        out.write(CRLF.getBytes());
        in.close();
    }

    private void sendField(OutputStream out, String separator, String field, String val) throws IOException {
        out.write(("--" + separator + CRLF).getBytes());
        out.write(("Content-Disposition: form-data; name=\"" + field + "\"" + CRLF + CRLF).getBytes());
        out.write(val.getBytes());
        out.write(CRLF.getBytes());
    }

    private String getHeader(boolean isProxy, String path, String host, int port, String separator, long length) {
        StringBuilder buf = new StringBuilder(512);
        buf.append("POST ");
        if (isProxy) {
            buf.append("http://").append(host);
            if (port != 80) {
                buf.append(":").append(port);
            }
        }
        buf.append(path);
        buf.append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(host);
        if (port != 80) {
            buf.append(":").append(port);
        }
        buf.append(CRLF);
        buf.append("Connection: close\r\n");
        buf.append("Content-length: ").append(length).append(CRLF);
        buf.append("Content-type: multipart/form-data, boundary=").append(separator);
        buf.append(CRLF);
        buf.append(CRLF);
        return buf.toString();
    }

    private String getSeparator() {
        byte[] separator = new byte[32];
        I2PAppContext.getGlobalContext().random().nextBytes(separator);
        StringBuilder sep = new StringBuilder(48);
        for (int i = 0; i < separator.length; ++i) {
            sep.append((char)(97 + (separator[i] & 0xF))).append((char)(97 + (separator[i] >>> 4 & 0xF)));
        }
        return sep.toString();
    }

    private class Runner
    implements Runnable {
        private String _url;
        private String _proxyHost;
        private int _proxyPort;
        private Map _fields;
        private Runnable _onCompletion;

        public Runner(String url, String proxy, int port, Map fields, Runnable onCompletion) {
            this._url = url;
            this._proxyHost = proxy;
            this._proxyPort = port;
            this._fields = fields;
            this._onCompletion = onCompletion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (EepPost.this._log.shouldLog(10)) {
                EepPost.this._log.debug("Running the post task");
            }
            Socket s = null;
            try {
                URL u = new URL(this._url);
                String h = u.getHost();
                int p = u.getPort();
                if (p <= 0) {
                    p = 80;
                }
                String path = u.getPath();
                boolean isProxy = true;
                if (this._proxyHost == null || this._proxyPort <= 0) {
                    isProxy = false;
                    this._proxyHost = h;
                    this._proxyPort = p;
                }
                if (EepPost.this._log.shouldLog(10)) {
                    EepPost.this._log.debug("Connecting to the server/proxy...");
                }
                s = new Socket(this._proxyHost, this._proxyPort);
                if (EepPost.this._log.shouldLog(10)) {
                    EepPost.this._log.debug("Connected");
                }
                OutputStream out = s.getOutputStream();
                String sep = EepPost.this.getSeparator();
                long length = EepPost.this.calcContentLength(sep, this._fields);
                if (EepPost.this._log.shouldLog(10)) {
                    EepPost.this._log.debug("Separator: " + sep + " content length: " + length);
                }
                String header = EepPost.this.getHeader(isProxy, path, h, p, sep, length);
                if (EepPost.this._log.shouldLog(10)) {
                    EepPost.this._log.debug("Header: \n" + header);
                }
                out.write(header.getBytes());
                out.flush();
                EepPost.this.sendFields(out, sep, this._fields);
                out.flush();
                if (EepPost.this._log.shouldLog(10)) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        EepPost.this._log.debug("recv: [" + line + "]");
                    }
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this._onCompletion != null) {
                    this._onCompletion.run();
                }
            }
        }
    }
}

