/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.DecayingBloomFilter;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public class DecayingHashSet
extends DecayingBloomFilter {
    private ConcurrentHashSet<ArrayWrapper> _current;
    private ConcurrentHashSet<ArrayWrapper> _previous;
    private final ReentrantReadWriteLock _reorganizeLock = new ReentrantReadWriteLock(true);

    public DecayingHashSet(I2PAppContext context, int durationMs, int entryBytes) {
        this(context, durationMs, entryBytes, "DHS");
    }

    public DecayingHashSet(I2PAppContext context, int durationMs, int entryBytes, String name) {
        super(durationMs, entryBytes, name, context);
        if (entryBytes <= 0 || entryBytes > 32) {
            throw new IllegalArgumentException("Bad size");
        }
        this._current = new ConcurrentHashSet(128);
        this._previous = new ConcurrentHashSet(128);
        this._decayEvent = new DecayEvent();
        this._keepDecaying = true;
        SimpleScheduler.getInstance().addEvent(this._decayEvent, this._durationMs);
        if (this._log.shouldLog(30)) {
            this._log.warn("New DHS " + name + " entryBytes = " + entryBytes + " cycle (s) = " + durationMs / 1000);
        }
        context.statManager().createRateStat("router.decayingHashSet." + name + ".size", "Size", "Router", new long[]{Math.max(60000, durationMs)});
        context.statManager().createRateStat("router.decayingHashSet." + name + ".dups", "1000000 * Duplicates/Size", "Router", new long[]{Math.max(60000, durationMs)});
    }

    public int getInsertedCount() {
        return this._current.size() + this._previous.size();
    }

    public double getFalsePositiveRate() {
        if (this._entryBytes <= 8) {
            return 0.0;
        }
        return 1.0 / Math.pow(2.0, 64.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(byte[] entry, int off, int len) {
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        if (len != this._entryBytes) {
            throw new IllegalArgumentException("Bad entry [" + len + ", expected " + this._entryBytes + "]");
        }
        ArrayWrapper w = new ArrayWrapper(entry, off, len);
        this.getReadLock();
        try {
            boolean bl = this.locked_add(w, true);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean add(long entry) {
        return this.add(entry, true);
    }

    public boolean isKnown(long entry) {
        return this.add(entry, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(long entry, boolean addIfNew) {
        ArrayWrapper w = new ArrayWrapper(entry);
        this.getReadLock();
        try {
            boolean bl = this.locked_add(w, addIfNew);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean locked_add(ArrayWrapper w, boolean addIfNew) {
        boolean seen = addIfNew ? !this._current.add(w) : this._current.contains(w);
        if (!seen) {
            seen = this._previous.contains(w);
        }
        if (seen) {
            ++this._currentDuplicates;
        }
        return seen;
    }

    public void clear() {
        this._current.clear();
        this._previous.clear();
        this._currentDuplicates = 0L;
    }

    public void stopDecaying() {
        this._keepDecaying = false;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decay() {
        int currentCount = 0;
        long dups = 0L;
        if (!this.getWriteLock()) {
            return;
        }
        try {
            ConcurrentHashSet<ArrayWrapper> tmp = this._previous;
            currentCount = this._current.size();
            this._previous = this._current;
            this._current = tmp;
            this._current.clear();
            dups = this._currentDuplicates;
            this._currentDuplicates = 0L;
        }
        finally {
            this.releaseWriteLock();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Decaying the filter " + this._name + " after inserting " + currentCount + " elements and " + dups + " false positives");
        }
        this._context.statManager().addRateData("router.decayingHashSet." + this._name + ".size", currentCount, 0L);
        if (currentCount > 0) {
            this._context.statManager().addRateData("router.decayingHashSet." + this._name + ".dups", 1000000L * dups / (long)currentCount, 0L);
        }
    }

    private void getReadLock() {
        this._reorganizeLock.readLock().lock();
    }

    private void releaseReadLock() {
        this._reorganizeLock.readLock().unlock();
    }

    private boolean getWriteLock() {
        try {
            boolean rv = this._reorganizeLock.writeLock().tryLock(5000L, TimeUnit.MILLISECONDS);
            if (!rv) {
                this._log.error("no lock, size is: " + this._reorganizeLock.getQueueLength(), new Exception("rats"));
            }
            return rv;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void releaseWriteLock() {
        this._reorganizeLock.writeLock().unlock();
    }

    public static void main(String[] args) {
        int kbps = 256;
        int iterations = 10;
        DecayingHashSet.testByLong(kbps, iterations);
        DecayingHashSet.testByBytes(kbps, iterations);
    }

    private static void testByLong(int kbps, int numRuns) {
        int messages = 600 * kbps;
        Random r = new Random();
        DecayingHashSet filter = new DecayingHashSet(I2PAppContext.getGlobalContext(), 600000, 8);
        int falsePositives = 0;
        long totalTime = 0L;
        for (int j = 0; j < numRuns; ++j) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < messages; ++i) {
                if (!((DecayingBloomFilter)filter).add(r.nextLong())) continue;
                System.out.println("False positive " + ++falsePositives + " (testByLong j=" + j + " i=" + i + ")");
            }
            totalTime += System.currentTimeMillis() - start;
            ((DecayingBloomFilter)filter).clear();
        }
        System.out.println("False postive rate should be " + ((DecayingBloomFilter)filter).getFalsePositiveRate());
        ((DecayingBloomFilter)filter).stopDecaying();
        System.out.println("After " + numRuns + " runs pushing " + messages + " entries in " + DataHelper.formatDuration(totalTime / (long)numRuns) + " per run, there were " + falsePositives + " false positives");
    }

    private static void testByBytes(int kbps, int numRuns) {
        byte[][] iv = new byte[600 * kbps][16];
        Random r = new Random();
        for (int i = 0; i < iv.length; ++i) {
            r.nextBytes(iv[i]);
        }
        DecayingHashSet filter = new DecayingHashSet(I2PAppContext.getGlobalContext(), 600000, 16);
        int falsePositives = 0;
        long totalTime = 0L;
        for (int j = 0; j < numRuns; ++j) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < iv.length; ++i) {
                if (!filter.add(iv[i])) continue;
                System.out.println("False positive " + ++falsePositives + " (testByBytes j=" + j + " i=" + i + ")");
            }
            totalTime += System.currentTimeMillis() - start;
            ((DecayingBloomFilter)filter).clear();
        }
        System.out.println("False postive rate should be " + ((DecayingBloomFilter)filter).getFalsePositiveRate());
        ((DecayingBloomFilter)filter).stopDecaying();
        System.out.println("After " + numRuns + " runs pushing " + iv.length + " entries in " + DataHelper.formatDuration(totalTime / (long)numRuns) + " per run, there were " + falsePositives + " false positives");
    }

    private static class ArrayWrapper {
        private final long _longhashcode;

        public ArrayWrapper(byte[] b, int offset, int len) {
            int idx = offset;
            int shift = Math.min(8, 64 / len);
            long lhc = 0L;
            for (int i = 0; i < len; ++i) {
                lhc ^= (long)b[idx++] << i * shift;
            }
            this._longhashcode = lhc;
        }

        public ArrayWrapper(long b) {
            this._longhashcode = b;
        }

        public int hashCode() {
            return (int)this._longhashcode;
        }

        public long longHashCode() {
            return this._longhashcode;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ArrayWrapper)) {
                return false;
            }
            return ((ArrayWrapper)o).longHashCode() == this._longhashcode;
        }
    }

    private class DecayEvent
    implements SimpleTimer.TimedEvent {
        private DecayEvent() {
        }

        public void timeReached() {
            if (DecayingHashSet.this._keepDecaying) {
                DecayingHashSet.this.decay();
                SimpleScheduler.getInstance().addEvent(this, DecayingHashSet.this._durationMs);
            }
        }
    }
}

