/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.stat.Rate;
import net.i2p.stat.StatLog;
import net.i2p.util.Log;

public class RateStat {
    private static final Log _log = new Log(RateStat.class);
    private String _statName;
    private String _groupName;
    private String _description;
    private Rate[] _rates;
    private StatLog _statLog;
    private static final String NL = System.getProperty("line.separator");

    public RateStat(String name, String description, String group, long[] periods) {
        this._statName = name;
        this._description = description;
        this._groupName = group;
        this._rates = new Rate[periods.length];
        for (int i = 0; i < periods.length; ++i) {
            this._rates[i] = new Rate(periods[i]);
            this._rates[i].setRateStat(this);
        }
    }

    public void setStatLog(StatLog sl) {
        this._statLog = sl;
    }

    public void addData(long value, long eventDuration) {
        if (this._statLog != null) {
            this._statLog.addData(this._groupName, this._statName, value, eventDuration);
        }
        for (int i = 0; i < this._rates.length; ++i) {
            this._rates[i].addData(value, eventDuration);
        }
    }

    public void coalesceStats() {
        for (int i = 0; i < this._rates.length; ++i) {
            this._rates[i].coalesce();
        }
    }

    public String getName() {
        return this._statName;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public String getDescription() {
        return this._description;
    }

    public long[] getPeriods() {
        long[] rv = new long[this._rates.length];
        for (int i = 0; i < this._rates.length; ++i) {
            rv[i] = this._rates[i].getPeriod();
        }
        return rv;
    }

    public double getLifetimeAverageValue() {
        if (this._rates == null || this._rates.length <= 0) {
            return 0.0;
        }
        return this._rates[0].getLifetimeAverageValue();
    }

    public long getLifetimeEventCount() {
        if (this._rates == null || this._rates.length <= 0) {
            return 0L;
        }
        return this._rates[0].getLifetimeEventCount();
    }

    public Rate getRate(long period) {
        for (int i = 0; i < this._rates.length; ++i) {
            if (this._rates[i].getPeriod() != period) continue;
            return this._rates[i];
        }
        return null;
    }

    public int hashCode() {
        return this._statName.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(4096);
        buf.append(this.getGroupName()).append('.').append(this.getName()).append(": ").append(this.getDescription()).append('\n');
        long[] periods = this.getPeriods();
        Arrays.sort(periods);
        for (int i = 0; i < periods.length; ++i) {
            buf.append('\t').append(periods[i]).append(':');
            Rate curRate = this.getRate(periods[i]);
            buf.append(curRate.toString());
            buf.append(NL);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RateStat)) {
            return false;
        }
        RateStat rs = (RateStat)obj;
        if (DataHelper.eq(this.getGroupName(), rs.getGroupName()) && DataHelper.eq(this.getDescription(), rs.getDescription()) && DataHelper.eq(this.getName(), rs.getName())) {
            for (int i = 0; i < this._rates.length; ++i) {
                if (this._rates[i].equals(rs.getRate(this._rates[i].getPeriod()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void store(OutputStream out, String prefix) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(NL);
        buf.append("################################################################################").append(NL);
        buf.append("# Rate: ").append(this._groupName).append(": ").append(this._statName).append(NL);
        buf.append("# ").append(this._description).append(NL);
        buf.append("# ").append(NL).append(NL);
        out.write(buf.toString().getBytes());
        buf.setLength(0);
        for (int i = 0; i < this._rates.length; ++i) {
            buf.append("#######").append(NL);
            buf.append("# Period : ").append(DataHelper.formatDuration(this._rates[i].getPeriod())).append(" for rate ").append(this._groupName).append(" - ").append(this._statName).append(NL);
            buf.append(NL);
            String curPrefix = prefix + "." + DataHelper.formatDuration(this._rates[i].getPeriod());
            this._rates[i].store(curPrefix, buf);
            out.write(buf.toString().getBytes());
            buf.setLength(0);
        }
    }

    public void load(Properties props, String prefix, boolean treatAsCurrent) throws IllegalArgumentException {
        for (int i = 0; i < this._rates.length; ++i) {
            long period = this._rates[i].getPeriod();
            String curPrefix = prefix + "." + DataHelper.formatDuration(period);
            try {
                this._rates[i].load(props, curPrefix, treatAsCurrent);
                continue;
            }
            catch (IllegalArgumentException iae) {
                this._rates[i] = new Rate(period);
                this._rates[i].setRateStat(this);
                if (!_log.shouldLog(30)) continue;
                _log.warn("Rate for " + prefix + " is corrupt, reinitializing that period");
            }
        }
    }
}

