/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

public class Frequency {
    private double _avgInterval;
    private double _minAverageInterval;
    private final long _period;
    private long _lastEvent;
    private final long _start = Frequency.now();
    private long _count;
    private final Object _lock = this;

    public Frequency(long period) {
        this._period = period;
        this._minAverageInterval = this._avgInterval = (double)(period + 1L);
    }

    public long getPeriod() {
        return this._period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEvent() {
        Object object = this._lock;
        synchronized (object) {
            return this._lastEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverageInterval() {
        Object object = this._lock;
        synchronized (object) {
            return this._avgInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMinAverageInterval() {
        Object object = this._lock;
        synchronized (object) {
            return this._minAverageInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverageEventsPerPeriod() {
        Object object = this._lock;
        synchronized (object) {
            if (this._avgInterval > 0.0) {
                return (double)this._period / this._avgInterval;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxAverageEventsPerPeriod() {
        Object object = this._lock;
        synchronized (object) {
            if (this._minAverageInterval > 0.0 && this._minAverageInterval <= (double)this._period) {
                return (double)this._period / this._minAverageInterval;
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStrictAverageInterval() {
        Object object = this._lock;
        synchronized (object) {
            long duration = Frequency.now() - this._start;
            if (duration <= 0L || this._count <= 0L) {
                return Double.MAX_VALUE;
            }
            return (double)duration / (double)this._count;
        }
    }

    public double getStrictAverageEventsPerPeriod() {
        double avgInterval = this.getStrictAverageInterval();
        if (avgInterval > 0.0) {
            return (double)this._period / avgInterval;
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEventCount() {
        Object object = this._lock;
        synchronized (object) {
            return this._count;
        }
    }

    public void eventOccurred() {
        this.recalculate(true);
    }

    public void recalculate() {
        this.recalculate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculate(boolean eventOccurred) {
        Object object = this._lock;
        synchronized (object) {
            long now = Frequency.now();
            long interval = now - this._lastEvent;
            if (interval > this._period) {
                interval = this._period;
            } else if (interval <= 0L) {
                interval = 1L;
            }
            if (interval >= this._period && !eventOccurred) {
                this._avgInterval = this._period + 1L;
            } else {
                double oldWeight = 1.0f - (float)interval / (float)this._period;
                double newWeight = (float)interval / (float)this._period;
                double oldInterval = this._avgInterval * oldWeight;
                double newInterval = (double)interval * newWeight;
                this._avgInterval = oldInterval + newInterval;
            }
            if (this._avgInterval < this._minAverageInterval || this._minAverageInterval <= 0.0) {
                this._minAverageInterval = this._avgInterval;
            }
            if (eventOccurred) {
                this._lastEvent = now;
                ++this._count;
            }
        }
    }

    private static final long now() {
        return System.currentTimeMillis();
    }
}

