/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;

public class BandwidthLimitsMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 23;
    private static final int LIMITS = 16;
    private int[] data = new int[16];

    public BandwidthLimitsMessage() {
    }

    public BandwidthLimitsMessage(int in, int out) {
        this();
        this.data[0] = in;
        this.data[1] = out;
    }

    public int[] getLimits() {
        return this.data;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            for (int i = 0; i < 16; ++i) {
                this.data[i] = (int)DataHelper.readLong(in, 4);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        try {
            for (int i = 0; i < 16; ++i) {
                DataHelper.writeLong(os, 4, this.data[i]);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 23;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BandwidthLimitsMessage) {
            BandwidthLimitsMessage msg = (BandwidthLimitsMessage)object;
            return DataHelper.eq(this.data, msg.getLimits());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[BandwidthLimitsMessage");
        buf.append("\n\tIn: ").append(this.data[0]);
        buf.append("\n\tOut: ").append(this.data[1]);
        buf.append("]");
        return buf.toString();
    }
}

