/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Hash;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class RoutingKeyGenerator {
    private Log _log;
    private I2PAppContext _context;
    private byte[] _currentModData;
    private long _lastChanged;
    private static final Calendar _cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("yyyyMMdd");

    public RoutingKeyGenerator(I2PAppContext context) {
        this._log = context.logManager().getLog(RoutingKeyGenerator.class);
        this._context = context;
    }

    public static RoutingKeyGenerator getInstance() {
        return I2PAppContext.getGlobalContext().routingKeyGenerator();
    }

    public byte[] getModData() {
        return this._currentModData;
    }

    public long getLastChanged() {
        return this._lastChanged;
    }

    public void setModData(byte[] modData) {
        this._currentModData = modData;
        this._lastChanged = this._context.clock().now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDateBasedModData() {
        Date today = null;
        long now = this._context.clock().now();
        Calendar calendar = _cal;
        synchronized (calendar) {
            _cal.setTime(new Date(now));
            _cal.set(1, _cal.get(1));
            _cal.set(6, _cal.get(6));
            _cal.set(11, 0);
            _cal.set(12, 0);
            _cal.set(13, 0);
            _cal.set(14, 0);
            today = _cal.getTime();
        }
        byte[] mod = null;
        String modVal = null;
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            modVal = _fmt.format(today);
        }
        mod = new byte[modVal.length()];
        for (int i = 0; i < modVal.length(); ++i) {
            mod[i] = (byte)(modVal.charAt(i) & 0xFF);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Routing modifier generated: " + modVal);
        }
        this.setModData(mod);
    }

    public Hash getRoutingKey(Hash origKey) {
        if (origKey == null) {
            throw new IllegalArgumentException("Original key is null");
        }
        if (this._currentModData == null) {
            this.generateDateBasedModData();
        }
        byte[] modVal = new byte[32 + this._currentModData.length];
        System.arraycopy(origKey.getData(), 0, modVal, 0, 32);
        System.arraycopy(this._currentModData, 0, modVal, 32, this._currentModData.length);
        return SHA256Generator.getInstance().calculateHash(modVal);
    }

    public static void main(String[] args) {
        Hash k1 = new Hash();
        byte[] k1d = new byte[32];
        RandomSource.getInstance().nextBytes(k1d);
        k1.setData(k1d);
        for (int i = 0; i < 10; ++i) {
            System.out.println("K1:  " + k1);
            Hash k1m = RoutingKeyGenerator.getInstance().getRoutingKey(k1);
            System.out.println("MOD: " + new String(RoutingKeyGenerator.getInstance().getModData()));
            System.out.println("K1M: " + k1m);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

