/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Destination;

public class Address
extends DataStructureImpl {
    private String _hostname;
    private Destination _destination;

    public String getHostname() {
        return this._hostname;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void setDestination(String base64) {
        try {
            Destination result = new Destination();
            result.fromBase64(base64);
            this._destination = result;
        }
        catch (DataFormatException dfe) {
            this._destination = null;
        }
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._hostname = DataHelper.readString(in);
        this._destination = new Destination();
        this._destination.readBytes(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._hostname == null || this._destination == null) {
            throw new DataFormatException("Not enough data to write address");
        }
        DataHelper.writeString(out, this._hostname);
        this._destination.writeBytes(out);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Address)) {
            return false;
        }
        Address addr = (Address)obj;
        return DataHelper.eq(this._hostname, addr.getHostname()) && DataHelper.eq(this._destination, addr.getDestination());
    }

    public int hashCode() {
        return DataHelper.hashCode(this._hostname) + DataHelper.hashCode(this._destination);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[Address: ");
        buf.append("\n\tHostname: ").append(this._hostname);
        buf.append("\n\tDestination: ").append(this._destination);
        buf.append("]");
        return buf.toString();
    }
}

