/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.YKGenerator;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;

public class ElGamalEngine {
    private Log _log;
    private I2PAppContext _context;
    private static final BigInteger _two = new NativeBigInteger(1, new byte[]{2});

    public ElGamalEngine(I2PAppContext context) {
        context.statManager().createRateStat("crypto.elGamal.encrypt", "how long does it take to do a full ElGamal encryption", "Encryption", new long[]{3600000L});
        context.statManager().createRateStat("crypto.elGamal.decrypt", "how long does it take to do a full ElGamal decryption", "Encryption", new long[]{3600000L});
        this._context = context;
        this._log = context.logManager().getLog(ElGamalEngine.class);
    }

    private ElGamalEngine() {
    }

    private BigInteger[] getNextYK() {
        return YKGenerator.getNextYK();
    }

    public byte[] encrypt(byte[] data, PublicKey publicKey) {
        if (data == null || data.length >= 223) {
            throw new IllegalArgumentException("Data to encrypt must be < 223 bytes at the moment");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Null public key specified");
        }
        long start = this._context.clock().now();
        byte[] d2 = new byte[33 + data.length];
        d2[0] = -1;
        Hash hash = this._context.sha().calculateHash(data);
        System.arraycopy(hash.getData(), 0, d2, 1, 32);
        System.arraycopy(data, 0, d2, 33, data.length);
        NativeBigInteger m = new NativeBigInteger(1, d2);
        if (m.compareTo(CryptoConstants.elgp) >= 0) {
            throw new IllegalArgumentException("ARGH.  Data cannot be larger than the ElGamal prime.  FIXME");
        }
        NativeBigInteger aalpha = new NativeBigInteger(1, publicKey.getData());
        BigInteger[] yk = this.getNextYK();
        BigInteger k = yk[1];
        BigInteger y = yk[0];
        BigInteger d = ((BigInteger)aalpha).modPow(k, CryptoConstants.elgp);
        d = d.multiply(m);
        d = d.mod(CryptoConstants.elgp);
        byte[] ybytes = y.toByteArray();
        byte[] dbytes = d.toByteArray();
        byte[] out = new byte[514];
        System.arraycopy(ybytes, 0, out, ybytes.length < 257 ? 257 - ybytes.length : 0, ybytes.length > 257 ? 257 : ybytes.length);
        System.arraycopy(dbytes, 0, out, dbytes.length < 257 ? 514 - dbytes.length : 257, dbytes.length > 257 ? 257 : dbytes.length);
        long end = this._context.clock().now();
        long diff = end - start;
        if (diff > 1000L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to encrypt ElGamal block (" + diff + "ms)");
        }
        this._context.statManager().addRateData("crypto.elGamal.encrypt", diff, diff);
        return out;
    }

    public byte[] decrypt(byte[] encrypted, PrivateKey privateKey) {
        if (encrypted == null || encrypted.length > 514) {
            throw new IllegalArgumentException("Data to decrypt must be <= 514 bytes at the moment");
        }
        long start = this._context.clock().now();
        byte[] ybytes = new byte[257];
        byte[] dbytes = new byte[257];
        System.arraycopy(encrypted, 0, ybytes, 0, 257);
        System.arraycopy(encrypted, 257, dbytes, 0, 257);
        NativeBigInteger y = new NativeBigInteger(1, ybytes);
        NativeBigInteger d = new NativeBigInteger(1, dbytes);
        NativeBigInteger a = new NativeBigInteger(1, privateKey.getData());
        BigInteger y1p = CryptoConstants.elgp.subtract(BigInteger.ONE).subtract(a);
        BigInteger ya = ((BigInteger)y).modPow(y1p, CryptoConstants.elgp);
        BigInteger m = ya.multiply(d);
        m = m.mod(CryptoConstants.elgp);
        byte[] val = m.toByteArray();
        int i = 0;
        for (i = 0; i < val.length && val[i] == 0; ++i) {
        }
        int payloadLen = val.length - i - 1 - 32;
        if (payloadLen < 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("Decrypted data is too small (" + (val.length - i) + ")");
            }
            return null;
        }
        Hash hash = Hash.create(val, i + 1);
        byte[] rv = new byte[payloadLen];
        System.arraycopy(val, i + 1 + 32, rv, 0, rv.length);
        Hash calcHash = this._context.sha().calculateHash(rv);
        boolean ok = calcHash.equals(hash);
        long end = this._context.clock().now();
        long diff = end - start;
        if (diff > 1000L && this._log.shouldLog(30)) {
            this._log.warn("Took too long to decrypt and verify ElGamal block (" + diff + "ms)");
        }
        this._context.statManager().addRateData("crypto.elGamal.decrypt", diff, diff);
        if (ok) {
            return rv;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Doesn't match hash [sent hash=" + hash + "]\ndata = " + Base64.encode(rv), new Exception("Doesn't match"));
        }
        return null;
    }

    public static void main(String[] args) {
        long eTime = 0L;
        long dTime = 0L;
        long gTime = 0L;
        int numRuns = 100;
        if (args.length > 0) {
            try {
                numRuns = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        RandomSource.getInstance().nextBoolean();
        I2PAppContext context = new I2PAppContext();
        System.out.println("Running " + numRuns + " times");
        for (int i = 0; i < numRuns; ++i) {
            long startG = Clock.getInstance().now();
            Object[] pair = KeyGenerator.getInstance().generatePKIKeypair();
            long endG = Clock.getInstance().now();
            PublicKey pubkey = (PublicKey)pair[0];
            PrivateKey privkey = (PrivateKey)pair[1];
            byte[] buf = new byte[128];
            RandomSource.getInstance().nextBytes(buf);
            long startE = Clock.getInstance().now();
            byte[] encr = context.elGamalEngine().encrypt(buf, pubkey);
            long endE = Clock.getInstance().now();
            byte[] decr = context.elGamalEngine().decrypt(encr, privkey);
            long endD = Clock.getInstance().now();
            eTime += endE - startE;
            dTime += endD - endE;
            gTime += endG - startG;
            if (!DataHelper.eq(decr, buf)) {
                System.out.println("PublicKey     : " + DataHelper.toString(pubkey.getData(), pubkey.getData().length));
                System.out.println("PrivateKey    : " + DataHelper.toString(privkey.getData(), privkey.getData().length));
                System.out.println("orig          : " + DataHelper.toString(buf, buf.length));
                System.out.println("d(e(orig)     : " + DataHelper.toString(decr, decr.length));
                System.out.println("orig.len      : " + buf.length);
                System.out.println("d(e(orig).len : " + decr.length);
                System.out.println("Not equal!");
                System.exit(0);
                continue;
            }
            System.out.println("*Run " + i + " is successful, with encr.length = " + encr.length + " [E: " + (endE - startE) + " D: " + (endD - endE) + " G: " + (endG - startG) + "]\n");
        }
        System.out.println("\n\nAll " + numRuns + " tests successful, average encryption time: " + eTime / (long)numRuns + " average decryption time: " + dTime / (long)numRuns + " average key generation time: " + gTime / (long)numRuns);
    }
}

