/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.InvalidKeyException;
import net.i2p.crypto.CryptixAESKeyCache;
import net.i2p.util.Clock;

public final class CryptixRijndael_Algorithm {
    static final String _NAME = "Rijndael_Algorithm";
    static final boolean _IN = true;
    static final boolean _OUT = false;
    static final boolean _RDEBUG = false;
    static final int _debuglevel = 0;
    static final PrintWriter _err;
    static final boolean _TRACE = false;
    static final int _BLOCK_SIZE = 16;
    static final int[] _alog;
    static final int[] _log;
    static final byte[] _S;
    static final byte[] _Si;
    static final int[] _T1;
    static final int[] _T2;
    static final int[] _T3;
    static final int[] _T4;
    static final int[] _T5;
    static final int[] _T6;
    static final int[] _T7;
    static final int[] _T8;
    static final int[] _U1;
    static final int[] _U2;
    static final int[] _U3;
    static final int[] _U4;
    static final byte[] _rcon;
    static final int[][][] _shifts;
    private static final char[] _HEX_DIGITS;

    static void debug(String s) {
        _err.println(">>> Rijndael_Algorithm: " + s);
    }

    static void trace(boolean in, String s) {
    }

    static void trace(String s) {
    }

    static final int mul(int a, int b) {
        return a != 0 && b != 0 ? _alog[(_log[a & 0xFF] + _log[b & 0xFF]) % 255] : 0;
    }

    static final int mul4(int a, byte[] b) {
        if (a == 0) {
            return 0;
        }
        a = _log[a & 0xFF];
        int a0 = b[0] != 0 ? _alog[(a + _log[b[0] & 0xFF]) % 255] & 0xFF : 0;
        int a1 = b[1] != 0 ? _alog[(a + _log[b[1] & 0xFF]) % 255] & 0xFF : 0;
        int a2 = b[2] != 0 ? _alog[(a + _log[b[2] & 0xFF]) % 255] & 0xFF : 0;
        int a3 = b[3] != 0 ? _alog[(a + _log[b[3] & 0xFF]) % 255] & 0xFF : 0;
        return a0 << 24 | a1 << 16 | a2 << 8 | a3;
    }

    public static final Object makeKey(byte[] k) throws InvalidKeyException {
        return CryptixRijndael_Algorithm.makeKey(k, 16);
    }

    public static final void blockEncrypt(byte[] in, byte[] result, int inOffset, int outOffset, Object sessionKey) {
        int[][] Ke = (int[][])((Object[])sessionKey)[0];
        int ROUNDS = Ke.length - 1;
        int[] Ker = Ke[0];
        int t0 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[0];
        int t1 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[1];
        int t2 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[2];
        int t3 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ker[3];
        for (int r = 1; r < ROUNDS; ++r) {
            Ker = Ke[r];
            int a0 = _T1[t0 >>> 24 & 0xFF] ^ _T2[t1 >>> 16 & 0xFF] ^ _T3[t2 >>> 8 & 0xFF] ^ _T4[t3 & 0xFF] ^ Ker[0];
            int a1 = _T1[t1 >>> 24 & 0xFF] ^ _T2[t2 >>> 16 & 0xFF] ^ _T3[t3 >>> 8 & 0xFF] ^ _T4[t0 & 0xFF] ^ Ker[1];
            int a2 = _T1[t2 >>> 24 & 0xFF] ^ _T2[t3 >>> 16 & 0xFF] ^ _T3[t0 >>> 8 & 0xFF] ^ _T4[t1 & 0xFF] ^ Ker[2];
            int a3 = _T1[t3 >>> 24 & 0xFF] ^ _T2[t0 >>> 16 & 0xFF] ^ _T3[t1 >>> 8 & 0xFF] ^ _T4[t2 & 0xFF] ^ Ker[3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
        }
        Ker = Ke[ROUNDS];
        int tt = Ker[0];
        result[outOffset++] = (byte)(_S[t0 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_S[t1 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_S[t2 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_S[t3 & 0xFF] ^ tt);
        tt = Ker[1];
        result[outOffset++] = (byte)(_S[t1 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_S[t2 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_S[t3 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_S[t0 & 0xFF] ^ tt);
        tt = Ker[2];
        result[outOffset++] = (byte)(_S[t2 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_S[t3 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_S[t0 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_S[t1 & 0xFF] ^ tt);
        tt = Ker[3];
        result[outOffset++] = (byte)(_S[t3 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_S[t0 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_S[t1 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_S[t2 & 0xFF] ^ tt);
    }

    public static final void blockDecrypt(byte[] in, byte[] result, int inOffset, int outOffset, Object sessionKey) {
        if (in.length - inOffset > result.length - outOffset) {
            throw new IllegalArgumentException("result too small: in.len=" + in.length + " in.offset=" + inOffset + " result.len=" + result.length + " result.offset=" + outOffset);
        }
        if (in.length - inOffset <= 15) {
            throw new IllegalArgumentException("data too small: " + in.length + " inOffset: " + inOffset);
        }
        int[][] Kd = (int[][])((Object[])sessionKey)[1];
        int ROUNDS = Kd.length - 1;
        int[] Kdr = Kd[0];
        int t0 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[0];
        int t1 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[1];
        int t2 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[2];
        int t3 = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kdr[3];
        for (int r = 1; r < ROUNDS; ++r) {
            Kdr = Kd[r];
            int a0 = _T5[t0 >>> 24 & 0xFF] ^ _T6[t3 >>> 16 & 0xFF] ^ _T7[t2 >>> 8 & 0xFF] ^ _T8[t1 & 0xFF] ^ Kdr[0];
            int a1 = _T5[t1 >>> 24 & 0xFF] ^ _T6[t0 >>> 16 & 0xFF] ^ _T7[t3 >>> 8 & 0xFF] ^ _T8[t2 & 0xFF] ^ Kdr[1];
            int a2 = _T5[t2 >>> 24 & 0xFF] ^ _T6[t1 >>> 16 & 0xFF] ^ _T7[t0 >>> 8 & 0xFF] ^ _T8[t3 & 0xFF] ^ Kdr[2];
            int a3 = _T5[t3 >>> 24 & 0xFF] ^ _T6[t2 >>> 16 & 0xFF] ^ _T7[t1 >>> 8 & 0xFF] ^ _T8[t0 & 0xFF] ^ Kdr[3];
            t0 = a0;
            t1 = a1;
            t2 = a2;
            t3 = a3;
        }
        Kdr = Kd[ROUNDS];
        int tt = Kdr[0];
        result[outOffset++] = (byte)(_Si[t0 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_Si[t3 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_Si[t2 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_Si[t1 & 0xFF] ^ tt);
        tt = Kdr[1];
        result[outOffset++] = (byte)(_Si[t1 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_Si[t0 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_Si[t3 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_Si[t2 & 0xFF] ^ tt);
        tt = Kdr[2];
        result[outOffset++] = (byte)(_Si[t2 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_Si[t1 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_Si[t0 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_Si[t3 & 0xFF] ^ tt);
        tt = Kdr[3];
        result[outOffset++] = (byte)(_Si[t3 >>> 24 & 0xFF] ^ tt >>> 24);
        result[outOffset++] = (byte)(_Si[t2 >>> 16 & 0xFF] ^ tt >>> 16);
        result[outOffset++] = (byte)(_Si[t1 >>> 8 & 0xFF] ^ tt >>> 8);
        result[outOffset++] = (byte)(_Si[t0 & 0xFF] ^ tt);
    }

    public static boolean self_test() {
        return CryptixRijndael_Algorithm.self_test(16);
    }

    public static final int blockSize() {
        return 16;
    }

    public static final Object makeKey(byte[] k, int blockSize) throws InvalidKeyException {
        return CryptixRijndael_Algorithm.makeKey(k, blockSize, null);
    }

    public static final Object makeKey(byte[] k, int blockSize, CryptixAESKeyCache.KeyCacheEntry keyData) throws InvalidKeyException {
        int tt;
        if (k == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (k.length != 16 && k.length != 24 && k.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        int ROUNDS = CryptixRijndael_Algorithm.getRounds(k.length, blockSize);
        int BC = blockSize / 4;
        int[][] Ke = null;
        int[][] Kd = null;
        int ROUND_KEY_COUNT = (ROUNDS + 1) * BC;
        int KC = k.length / 4;
        int[] tk = null;
        if (keyData == null) {
            Ke = new int[ROUNDS + 1][BC];
            Kd = new int[ROUNDS + 1][BC];
            tk = new int[KC];
        } else {
            Ke = keyData.Ke;
            Kd = keyData.Kd;
            tk = keyData.tk;
        }
        int i = 0;
        int j = 0;
        while (i < KC) {
            tk[i++] = (k[j++] & 0xFF) << 24 | (k[j++] & 0xFF) << 16 | (k[j++] & 0xFF) << 8 | k[j++] & 0xFF;
        }
        int t = 0;
        for (j = 0; j < KC && t < ROUND_KEY_COUNT; ++j, ++t) {
            Ke[t / BC][t % BC] = tk[j];
            Kd[ROUNDS - t / BC][t % BC] = tk[j];
        }
        int rconpointer = 0;
        while (t < ROUND_KEY_COUNT) {
            tt = tk[KC - 1];
            tk[0] = tk[0] ^ ((_S[tt >>> 16 & 0xFF] & 0xFF) << 24 ^ (_S[tt >>> 8 & 0xFF] & 0xFF) << 16 ^ (_S[tt & 0xFF] & 0xFF) << 8 ^ _S[tt >>> 24 & 0xFF] & 0xFF ^ (_rcon[rconpointer++] & 0xFF) << 24);
            if (KC != 8) {
                i = 1;
                j = 0;
                while (i < KC) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
            } else {
                i = 1;
                j = 0;
                while (i < KC / 2) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
                tt = tk[KC / 2 - 1];
                int n = KC / 2;
                tk[n] = tk[n] ^ (_S[tt & 0xFF] & 0xFF ^ (_S[tt >>> 8 & 0xFF] & 0xFF) << 8 ^ (_S[tt >>> 16 & 0xFF] & 0xFF) << 16 ^ (_S[tt >>> 24 & 0xFF] & 0xFF) << 24);
                j = KC / 2;
                i = j + 1;
                while (i < KC) {
                    int n2 = i++;
                    tk[n2] = tk[n2] ^ tk[j++];
                }
            }
            for (j = 0; j < KC && t < ROUND_KEY_COUNT; ++j, ++t) {
                Ke[t / BC][t % BC] = tk[j];
                Kd[ROUNDS - t / BC][t % BC] = tk[j];
            }
        }
        for (int r = 1; r < ROUNDS; ++r) {
            for (j = 0; j < BC; ++j) {
                tt = Kd[r][j];
                Kd[r][j] = _U1[tt >>> 24 & 0xFF] ^ _U2[tt >>> 16 & 0xFF] ^ _U3[tt >>> 8 & 0xFF] ^ _U4[tt & 0xFF];
            }
        }
        Object[] sessionKey = null;
        sessionKey = keyData == null ? new Object[]{Ke, Kd} : keyData.key;
        return sessionKey;
    }

    public static final void blockEncrypt(byte[] in, byte[] result, int inOffset, int outOffset, Object sessionKey, int blockSize) {
        int i;
        if (blockSize == 16) {
            CryptixRijndael_Algorithm.blockEncrypt(in, result, inOffset, outOffset, sessionKey);
            return;
        }
        Object[] sKey = (Object[])sessionKey;
        int[][] Ke = (int[][])sKey[0];
        int BC = blockSize / 4;
        int ROUNDS = Ke.length - 1;
        int SC = BC == 4 ? 0 : (BC == 6 ? 1 : 2);
        int s1 = _shifts[SC][1][0];
        int s2 = _shifts[SC][2][0];
        int s3 = _shifts[SC][3][0];
        int[] a = new int[BC];
        int[] t = new int[BC];
        int j = outOffset;
        for (i = 0; i < BC; ++i) {
            t[i] = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Ke[0][i];
        }
        for (int r = 1; r < ROUNDS; ++r) {
            for (i = 0; i < BC; ++i) {
                a[i] = _T1[t[i] >>> 24 & 0xFF] ^ _T2[t[(i + s1) % BC] >>> 16 & 0xFF] ^ _T3[t[(i + s2) % BC] >>> 8 & 0xFF] ^ _T4[t[(i + s3) % BC] & 0xFF] ^ Ke[r][i];
            }
            System.arraycopy(a, 0, t, 0, BC);
        }
        for (i = 0; i < BC; ++i) {
            int tt = Ke[ROUNDS][i];
            result[j++] = (byte)(_S[t[i] >>> 24 & 0xFF] ^ tt >>> 24);
            result[j++] = (byte)(_S[t[(i + s1) % BC] >>> 16 & 0xFF] ^ tt >>> 16);
            result[j++] = (byte)(_S[t[(i + s2) % BC] >>> 8 & 0xFF] ^ tt >>> 8);
            result[j++] = (byte)(_S[t[(i + s3) % BC] & 0xFF] ^ tt);
        }
    }

    public static final void blockDecrypt(byte[] in, byte[] result, int inOffset, int outOffset, Object sessionKey, int blockSize) {
        int i;
        if (blockSize == 16) {
            CryptixRijndael_Algorithm.blockDecrypt(in, result, inOffset, outOffset, sessionKey);
            return;
        }
        Object[] sKey = (Object[])sessionKey;
        int[][] Kd = (int[][])sKey[1];
        int BC = blockSize / 4;
        int ROUNDS = Kd.length - 1;
        int SC = BC == 4 ? 0 : (BC == 6 ? 1 : 2);
        int s1 = _shifts[SC][1][1];
        int s2 = _shifts[SC][2][1];
        int s3 = _shifts[SC][3][1];
        int[] a = new int[BC];
        int[] t = new int[BC];
        int j = outOffset;
        for (i = 0; i < BC; ++i) {
            t[i] = ((in[inOffset++] & 0xFF) << 24 | (in[inOffset++] & 0xFF) << 16 | (in[inOffset++] & 0xFF) << 8 | in[inOffset++] & 0xFF) ^ Kd[0][i];
        }
        for (int r = 1; r < ROUNDS; ++r) {
            for (i = 0; i < BC; ++i) {
                a[i] = _T5[t[i] >>> 24 & 0xFF] ^ _T6[t[(i + s1) % BC] >>> 16 & 0xFF] ^ _T7[t[(i + s2) % BC] >>> 8 & 0xFF] ^ _T8[t[(i + s3) % BC] & 0xFF] ^ Kd[r][i];
            }
            System.arraycopy(a, 0, t, 0, BC);
        }
        for (i = 0; i < BC; ++i) {
            int tt = Kd[ROUNDS][i];
            result[j++] = (byte)(_Si[t[i] >>> 24 & 0xFF] ^ tt >>> 24);
            result[j++] = (byte)(_Si[t[(i + s1) % BC] >>> 16 & 0xFF] ^ tt >>> 16);
            result[j++] = (byte)(_Si[t[(i + s2) % BC] >>> 8 & 0xFF] ^ tt >>> 8);
            result[j++] = (byte)(_Si[t[(i + s3) % BC] & 0xFF] ^ tt);
        }
    }

    private static boolean self_test(int keysize) {
        boolean ok = false;
        try {
            int i;
            byte[] kb = new byte[keysize];
            byte[] pt = new byte[16];
            for (i = 0; i < keysize; ++i) {
                kb[i] = (byte)i;
            }
            for (i = 0; i < 16; ++i) {
                pt[i] = (byte)i;
            }
            Object key = CryptixRijndael_Algorithm.makeKey(kb, 16);
            byte[] ct = new byte[16];
            CryptixRijndael_Algorithm.blockEncrypt(pt, ct, 0, 0, key, 16);
            byte[] cpt = new byte[16];
            CryptixRijndael_Algorithm.blockDecrypt(ct, cpt, 0, 0, key, 16);
            ok = CryptixRijndael_Algorithm.areEqual(pt, cpt);
            if (!ok) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public static final int getRounds(int keySize, int blockSize) {
        switch (keySize) {
            case 16: {
                return blockSize == 16 ? 10 : (blockSize == 24 ? 12 : 14);
            }
            case 24: {
                return blockSize != 32 ? 12 : 14;
            }
        }
        return 14;
    }

    private static final boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static final String byteToString(int n) {
        char[] buf = new char[]{_HEX_DIGITS[n >>> 4 & 0xF], _HEX_DIGITS[n & 0xF]};
        return new String(buf);
    }

    private static final String intToString(int n) {
        char[] buf = new char[8];
        for (int i = 7; i >= 0; --i) {
            buf[i] = _HEX_DIGITS[n & 0xF];
            n >>>= 4;
        }
        return new String(buf);
    }

    private static final String toString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[i++];
            buf[j++] = _HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = _HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    private static final String toString(int[] ia) {
        int length = ia.length;
        char[] buf = new char[length * 8];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int k = ia[i];
            buf[j++] = _HEX_DIGITS[k >>> 28 & 0xF];
            buf[j++] = _HEX_DIGITS[k >>> 24 & 0xF];
            buf[j++] = _HEX_DIGITS[k >>> 20 & 0xF];
            buf[j++] = _HEX_DIGITS[k >>> 16 & 0xF];
            buf[j++] = _HEX_DIGITS[k >>> 12 & 0xF];
            buf[j++] = _HEX_DIGITS[k >>> 8 & 0xF];
            buf[j++] = _HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = _HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        CryptixRijndael_Algorithm.self_test(16);
        CryptixRijndael_Algorithm.self_test(24);
        CryptixRijndael_Algorithm.self_test(32);
    }

    static {
        int t;
        int i;
        _err = new PrintWriter(new OutputStreamWriter(System.err));
        _alog = new int[256];
        _log = new int[256];
        _S = new byte[256];
        _Si = new byte[256];
        _T1 = new int[256];
        _T2 = new int[256];
        _T3 = new int[256];
        _T4 = new int[256];
        _T5 = new int[256];
        _T6 = new int[256];
        _T7 = new int[256];
        _T8 = new int[256];
        _U1 = new int[256];
        _U2 = new int[256];
        _U3 = new int[256];
        _U4 = new int[256];
        _rcon = new byte[30];
        _shifts = new int[][][]{new int[][]{{0, 0}, {1, 3}, {2, 2}, {3, 1}}, new int[][]{{0, 0}, {1, 5}, {2, 4}, {3, 3}}, new int[][]{{0, 0}, {1, 7}, {3, 5}, {4, 4}}};
        _HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        long time = Clock.getInstance().now();
        int ROOT = 283;
        int j = 0;
        CryptixRijndael_Algorithm._alog[0] = 1;
        for (i = 1; i < 256; ++i) {
            j = _alog[i - 1] << 1 ^ _alog[i - 1];
            if ((j & 0x100) != 0) {
                j ^= ROOT;
            }
            CryptixRijndael_Algorithm._alog[i] = j;
        }
        for (i = 1; i < 255; ++i) {
            CryptixRijndael_Algorithm._log[CryptixRijndael_Algorithm._alog[i]] = i;
        }
        byte[][] A = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] B = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] box = new byte[256][8];
        box[1][7] = 1;
        for (i = 2; i < 256; ++i) {
            j = _alog[255 - _log[i]];
            for (t = 0; t < 8; ++t) {
                box[i][t] = (byte)(j >>> 7 - t & 1);
            }
        }
        byte[][] cox = new byte[256][8];
        for (i = 0; i < 256; ++i) {
            for (t = 0; t < 8; ++t) {
                cox[i][t] = B[t];
                for (j = 0; j < 8; ++j) {
                    byte[] byArray = cox[i];
                    int n = t;
                    byArray[n] = (byte)(byArray[n] ^ A[t][j] * box[i][j]);
                }
            }
        }
        for (i = 0; i < 256; ++i) {
            CryptixRijndael_Algorithm._S[i] = (byte)(cox[i][0] << 7);
            for (t = 1; t < 8; ++t) {
                int n = i;
                _S[n] = (byte)(_S[n] ^ cox[i][t] << 7 - t);
            }
            CryptixRijndael_Algorithm._Si[CryptixRijndael_Algorithm._S[i] & 0xFF] = (byte)i;
        }
        byte[][] G = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] AA = new byte[4][8];
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                AA[i][j] = G[i][j];
            }
            AA[i][i + 4] = 1;
        }
        byte[][] iG = new byte[4][4];
        for (i = 0; i < 4; ++i) {
            byte pivot = AA[i][i];
            if (pivot == 0) {
                for (t = i + 1; AA[t][i] == 0 && t < 4; ++t) {
                }
                if (t == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                for (j = 0; j < 8; ++j) {
                    byte tmp = AA[i][j];
                    AA[i][j] = AA[t][j];
                    AA[t][j] = tmp;
                }
                pivot = AA[i][i];
            }
            for (j = 0; j < 8; ++j) {
                if (AA[i][j] == 0) continue;
                AA[i][j] = (byte)_alog[(255 + _log[AA[i][j] & 0xFF] - _log[pivot & 0xFF]) % 255];
            }
            for (t = 0; t < 4; ++t) {
                if (i == t) continue;
                for (j = i + 1; j < 8; ++j) {
                    byte[] byArray = AA[t];
                    int n = j;
                    byArray[n] = (byte)(byArray[n] ^ CryptixRijndael_Algorithm.mul(AA[i][j], AA[t][i]));
                }
                AA[t][i] = 0;
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                iG[i][j] = AA[i][j + 4];
            }
        }
        for (t = 0; t < 256; ++t) {
            byte s = _S[t];
            CryptixRijndael_Algorithm._T1[t] = CryptixRijndael_Algorithm.mul4(s, G[0]);
            CryptixRijndael_Algorithm._T2[t] = CryptixRijndael_Algorithm.mul4(s, G[1]);
            CryptixRijndael_Algorithm._T3[t] = CryptixRijndael_Algorithm.mul4(s, G[2]);
            CryptixRijndael_Algorithm._T4[t] = CryptixRijndael_Algorithm.mul4(s, G[3]);
            s = _Si[t];
            CryptixRijndael_Algorithm._T5[t] = CryptixRijndael_Algorithm.mul4(s, iG[0]);
            CryptixRijndael_Algorithm._T6[t] = CryptixRijndael_Algorithm.mul4(s, iG[1]);
            CryptixRijndael_Algorithm._T7[t] = CryptixRijndael_Algorithm.mul4(s, iG[2]);
            CryptixRijndael_Algorithm._T8[t] = CryptixRijndael_Algorithm.mul4(s, iG[3]);
            CryptixRijndael_Algorithm._U1[t] = CryptixRijndael_Algorithm.mul4(t, iG[0]);
            CryptixRijndael_Algorithm._U2[t] = CryptixRijndael_Algorithm.mul4(t, iG[1]);
            CryptixRijndael_Algorithm._U3[t] = CryptixRijndael_Algorithm.mul4(t, iG[2]);
            CryptixRijndael_Algorithm._U4[t] = CryptixRijndael_Algorithm.mul4(t, iG[3]);
        }
        CryptixRijndael_Algorithm._rcon[0] = 1;
        int r = 1;
        t = 1;
        while (t < 30) {
            int n = t++;
            r = CryptixRijndael_Algorithm.mul(2, r);
            CryptixRijndael_Algorithm._rcon[n] = (byte)r;
        }
        long l = Clock.getInstance().now() - time;
    }
}

