/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.data.DataHelper;

public class PetName {
    private String _name;
    private String _network;
    private String _protocol;
    private List _groups;
    private boolean _isPublic;
    private String _location;

    public PetName() {
        this(null, null, null, null);
    }

    public PetName(String name, String network, String protocol, String location) {
        this._name = name;
        this._network = network;
        this._protocol = protocol;
        this._location = location;
        this._groups = new ArrayList();
        this._isPublic = false;
    }

    public PetName(String dbLine) {
        this._groups = new ArrayList();
        StringTokenizer tok = new StringTokenizer(dbLine, ":\n", true);
        int tokens = tok.countTokens();
        if (tokens < 7) {
            return;
        }
        String s = tok.nextToken();
        if (":".equals(s)) {
            this._name = null;
        } else {
            this._name = s;
            s = tok.nextToken();
        }
        s = tok.nextToken();
        if (":".equals(s)) {
            this._network = null;
        } else {
            this._network = s;
            s = tok.nextToken();
        }
        s = tok.nextToken();
        if (":".equals(s)) {
            this._protocol = null;
        } else {
            this._protocol = s;
            s = tok.nextToken();
        }
        s = tok.nextToken();
        if (":".equals(s)) {
            this._isPublic = false;
        } else {
            this._isPublic = "true".equals(s);
            s = tok.nextToken();
        }
        s = tok.nextToken();
        if (!":".equals(s)) {
            StringTokenizer gtok = new StringTokenizer(s, ",");
            while (gtok.hasMoreTokens()) {
                this._groups.add(gtok.nextToken().trim());
            }
            s = tok.nextToken();
        }
        while (tok.hasMoreTokens()) {
            if (this._location == null) {
                this._location = tok.nextToken();
                continue;
            }
            this._location = this._location + tok.nextToken();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getNetwork() {
        return this._network;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getLocation() {
        return this._location;
    }

    public boolean getIsPublic() {
        return this._isPublic;
    }

    public int getGroupCount() {
        return this._groups.size();
    }

    public String getGroup(int i) {
        return (String)this._groups.get(i);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setNetwork(String network) {
        this._network = network;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public void setIsPublic(boolean pub) {
        this._isPublic = pub;
    }

    public void addGroup(String name) {
        if (name != null && name.length() > 0 && !this._groups.contains(name)) {
            this._groups.add(name);
        }
    }

    public void removeGroup(String name) {
        this._groups.remove(name);
    }

    public void setGroups(String groups) {
        if (groups != null) {
            this._groups.clear();
            StringTokenizer tok = new StringTokenizer(groups, ", \t");
            while (tok.hasMoreTokens()) {
                this.addGroup(tok.nextToken().trim());
            }
        } else {
            this._groups.clear();
        }
    }

    public boolean isMember(String group) {
        for (int i = 0; i < this.getGroupCount(); ++i) {
            if (!this.getGroup(i).equals(group)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        if (this._name != null) {
            buf.append(this._name.trim());
        }
        buf.append(':');
        if (this._network != null) {
            buf.append(this._network.trim());
        }
        buf.append(':');
        if (this._protocol != null) {
            buf.append(this._protocol.trim());
        }
        buf.append(':').append(this._isPublic).append(':');
        if (this._groups != null) {
            for (int i = 0; i < this._groups.size(); ++i) {
                buf.append(((String)this._groups.get(i)).trim());
                if (i + 1 >= this._groups.size()) continue;
                buf.append(',');
            }
        }
        buf.append(':');
        if (this._location != null) {
            buf.append(this._location.trim());
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PetName)) {
            return false;
        }
        PetName pn = (PetName)obj;
        return DataHelper.eq(this._name, pn._name) && DataHelper.eq(this._location, pn._location) && DataHelper.eq(this._network, pn._network) && DataHelper.eq(this._protocol, pn._protocol);
    }

    public int hashCode() {
        int rv = 0;
        rv += DataHelper.hashCode(this._name);
        rv += DataHelper.hashCode(this._location);
        rv += DataHelper.hashCode(this._network);
        return rv += DataHelper.hashCode(this._protocol);
    }

    public static void main(String[] args) {
        PetName.test("a:b:c:true:e:f");
        PetName.test("a:::true::d");
        PetName.test("a:::true::");
        PetName.test("a:b::true::");
        PetName.test(":::trye::");
        PetName.test("a:b:c:true:e:http://foo.bar");
    }

    private static void test(String line) {
        PetName pn = new PetName(line);
        String val = pn.toString();
        System.out.println("OK? " + val.equals(line) + ": " + line + " [" + val + "]");
    }
}

