/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.client.HandlerImpl;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.crypto.KeyGenerator;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.RequestLeaseSetMessage;

class RequestLeaseSetMessageHandler
extends HandlerImpl {
    private final Map _existingLeaseSets = new HashMap(32);

    public RequestLeaseSetMessageHandler(I2PAppContext context) {
        super(context, 21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        Object lease;
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        RequestLeaseSetMessage msg = (RequestLeaseSetMessage)message;
        LeaseSet leaseSet = new LeaseSet();
        for (int i = 0; i < msg.getEndpoints(); ++i) {
            lease = new Lease();
            ((Lease)lease).setGateway(msg.getRouter(i));
            ((Lease)lease).setTunnelId(msg.getTunnelId(i));
            ((Lease)lease).setEndDate(msg.getEndDate());
            leaseSet.addLease((Lease)lease);
        }
        leaseSet.setDestination(session.getMyDestination());
        LeaseInfo li = null;
        lease = this._existingLeaseSets;
        synchronized (lease) {
            if (this._existingLeaseSets.containsKey(session.getMyDestination())) {
                li = (LeaseInfo)this._existingLeaseSets.get(session.getMyDestination());
            }
        }
        if (li == null) {
            li = new LeaseInfo(session.getMyDestination());
            lease = this._existingLeaseSets;
            synchronized (lease) {
                this._existingLeaseSets.put(session.getMyDestination(), li);
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Creating new leaseInfo keys for " + session.getMyDestination().calculateHash().toBase64());
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Caching the old leaseInfo keys for " + session.getMyDestination().calculateHash().toBase64());
        }
        leaseSet.setEncryptionKey(li.getPublicKey());
        leaseSet.setSigningKey(li.getSigningPublicKey());
        boolean encrypt = Boolean.valueOf(session.getOptions().getProperty("i2cp.encryptLeaseSet"));
        String sk = session.getOptions().getProperty("i2cp.leaseSetKey");
        if (encrypt && sk != null) {
            SessionKey key = new SessionKey();
            try {
                key.fromBase64(sk);
                leaseSet.encrypt(key);
                this._context.keyRing().put(session.getMyDestination().calculateHash(), key);
            }
            catch (DataFormatException dfe) {
                this._log.error("Bad leaseset key: " + sk);
            }
        }
        try {
            leaseSet.sign(session.getPrivateKey());
            session.getProducer().createLeaseSet(session, leaseSet, li.getSigningPrivateKey(), li.getPrivateKey());
            session.setLeaseSet(leaseSet);
        }
        catch (DataFormatException dfe) {
            session.propogateError("Error signing the leaseSet", dfe);
        }
        catch (I2PSessionException ise) {
            session.propogateError("Error sending the signed leaseSet", ise);
        }
    }

    private static class LeaseInfo {
        private PublicKey _pubKey;
        private PrivateKey _privKey;
        private SigningPublicKey _signingPubKey;
        private SigningPrivateKey _signingPrivKey;
        private Destination _dest;

        public LeaseInfo(Destination dest) {
            this._dest = dest;
            Object[] encKeys = KeyGenerator.getInstance().generatePKIKeypair();
            Object[] signKeys = KeyGenerator.getInstance().generateSigningKeypair();
            this._pubKey = (PublicKey)encKeys[0];
            this._privKey = (PrivateKey)encKeys[1];
            this._signingPubKey = (SigningPublicKey)signKeys[0];
            this._signingPrivKey = (SigningPrivateKey)signKeys[1];
        }

        public PublicKey getPublicKey() {
            return this._pubKey;
        }

        public PrivateKey getPrivateKey() {
            return this._privKey;
        }

        public SigningPublicKey getSigningPublicKey() {
            return this._signingPubKey;
        }

        public SigningPrivateKey getSigningPrivateKey() {
            return this._signingPrivKey;
        }

        public int hashCode() {
            return DataHelper.hashCode(this._pubKey) + 7 * DataHelper.hashCode(this._privKey) + 49 * DataHelper.hashCode(this._signingPubKey) + 343 * DataHelper.hashCode(this._signingPrivKey);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LeaseInfo)) {
                return false;
            }
            LeaseInfo li = (LeaseInfo)obj;
            return DataHelper.eq(this._pubKey, li.getPublicKey()) && DataHelper.eq(this._privKey, li.getPrivateKey()) && DataHelper.eq(this._signingPubKey, li.getSigningPublicKey()) && DataHelper.eq(this._signingPrivKey, li.getSigningPrivateKey());
        }
    }
}

