/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.security;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.xml.sax.parser.ParserUtils;
import phex.xml.sax.parser.downloads.DownloadFileHandler;
import phex.xml.sax.security.DIpAccessRule;

public class IpAccessRuleHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "ip-access-rule";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DIpAccessRule dIpAccessRule;
    private DefaultHandler parent;

    public IpAccessRuleHandler(DIpAccessRule dIpAccessRule, DefaultHandler parent, SAXParser parser) {
        this.dIpAccessRule = dIpAccessRule;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("description")) {
            this.dIpAccessRule.setDescription(this.text.toString());
        } else if (qName.equals("isDenyingRule")) {
            this.dIpAccessRule.setDenyingRule(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("isDisabled")) {
            this.dIpAccessRule.setDisabled(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("isDeletedOnExpiry")) {
            this.dIpAccessRule.setDeletedOnExpiry(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("isSystemRule")) {
            this.dIpAccessRule.setSystemRule(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals("triggerCount")) {
            try {
                this.dIpAccessRule.setTriggerCount(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("expiryDate")) {
            try {
                this.dIpAccessRule.setExpiryDate(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("ip")) {
            this.dIpAccessRule.setIp(ParserUtils.fromHexBinary(this.text.toString()));
        } else if (qName.equals("cidr")) {
            try {
                this.dIpAccessRule.setCidr(Byte.parseByte(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        } else if (qName.equals("compareIP")) {
            this.dIpAccessRule.setCompareIp(ParserUtils.fromHexBinary(this.text.toString()));
        } else if (qName.equals("addressType")) {
            try {
                this.dIpAccessRule.setAddressType(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

