/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import phex.common.log.NLogger;
import phex.xml.sax.DPhex;

public class PhexXmlSaxWriter {
    private AttributesImpl attributes = new AttributesImpl();
    private TransformerHandler transHandler;

    public static void serializePhexXml(OutputStream outStream, DPhex dPhex) throws IOException {
        PhexXmlSaxWriter writer = new PhexXmlSaxWriter();
        try {
            writer.writePhexXml(outStream, dPhex);
        }
        catch (SAXException exp) {
            NLogger.error(PhexXmlSaxWriter.class, (Object)exp, (Throwable)exp);
            throw new IOException("Serializing Phex XML.");
        }
    }

    public void writePhexXml(OutputStream outStream, DPhex dPhex) throws SAXException {
        StreamResult streamResult = new StreamResult(outStream);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            this.transHandler = tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException exp) {
            throw new SAXException(exp.getMessage(), exp);
        }
        Transformer transformer = this.transHandler.getTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        this.transHandler.setResult(streamResult);
        this.transHandler.startDocument();
        dPhex.serialize(this);
        this.transHandler.endDocument();
    }

    public void startElm(String name, AttributesImpl atts) throws SAXException {
        if (atts == null) {
            this.attributes.clear();
            atts = this.attributes;
        }
        this.transHandler.startElement("", "", name, atts);
    }

    public void elmText(String text) throws SAXException {
        this.transHandler.characters(text.toCharArray(), 0, text.length());
    }

    public void elmByte(byte val) throws SAXException {
        this.elmText(String.valueOf(val));
    }

    public void elmInt(int val) throws SAXException {
        this.elmText(String.valueOf(val));
    }

    public void elmLong(long val) throws SAXException {
        this.elmText(String.valueOf(val));
    }

    public void elmBol(boolean val) throws SAXException {
        this.elmText(String.valueOf(val));
    }

    public void elmHexBinary(byte[] data) throws SAXException {
        StringBuffer r = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            r.append(this.hexBinaryEncode(data[i] >> 4));
            r.append(this.hexBinaryEncode(data[i] & 0xF));
        }
        this.elmText(r.toString());
    }

    private char hexBinaryEncode(int ch) {
        if ((ch &= 0xF) < 10) {
            return (char)(48 + ch);
        }
        return (char)(65 + (ch - 10));
    }

    public void endElm(String name) throws SAXException {
        this.transHandler.endElement("", "", name);
    }
}

