/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.StringTokenizer;
import phex.Res;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.utils.StringUtils;

public class VersionUtils {
    private static final int MAJOR_VERSION_NUMBER;
    private static final int MINOR_VERSION_NUMBER;
    private static final int ULTRAPEER_MAJOR_VERSION_NUMBER = 0;
    private static final int ULTRAPEER_MINOR_VERSION_NUMBER = 1;

    public static String getFullProgramVersion() {
        String privateBuild = Environment.getInstance().getProperty("privatebuild.number");
        if (!StringUtils.isEmpty(privateBuild)) {
            return Environment.getInstance().getProperty("privatebuild.number") + ' ' + Res.getStr("Program.Version") + '.' + Environment.getInstance().getProperty("build.number");
        }
        return Res.getStr("Program.Version") + '.' + Environment.getInstance().getProperty("build.number");
    }

    public static String getProgramVersion() {
        String privateBuild = Environment.getInstance().getProperty("privatebuild.number");
        if (!StringUtils.isEmpty(privateBuild)) {
            return Environment.getInstance().getProperty("privatebuild.number") + ' ' + Res.getStr("Program.Version");
        }
        return Res.getStr("Program.Version");
    }

    public static String getBuild() {
        return Environment.getInstance().getProperty("build.number");
    }

    public static int getMajorVersionNumber() {
        return MAJOR_VERSION_NUMBER;
    }

    public static int getMinorVersionNumber() {
        return MINOR_VERSION_NUMBER;
    }

    public static int getUltrapeerMajorVersionNumber() {
        return 0;
    }

    public static int getUltrapeerMinorVersionNumber() {
        return 1;
    }

    public static int compare(String version1, String version2) {
        int result = 0;
        int[] versionArr1 = VersionUtils.tokenizeVersion(version1);
        int[] versionArr2 = VersionUtils.tokenizeVersion(version2);
        int value1 = 0;
        int value2 = 0;
        for (int i = 0; result == 0 && (i < versionArr1.length || i < versionArr2.length); ++i) {
            value1 = versionArr1.length > i ? versionArr1[i] : 0;
            value2 = versionArr2.length > i ? versionArr2[i] : 0;
            result = value1 - value2;
        }
        return result;
    }

    public static int[] tokenizeVersion(String version) {
        StringTokenizer tok = new StringTokenizer(version, ".");
        int count = tok.countTokens();
        int[] arr = new int[count];
        for (int i = 0; i < count; ++i) {
            arr[i] = Integer.parseInt(tok.nextToken());
        }
        return arr;
    }

    static {
        String minorStr;
        String majorStr;
        String version = Res.getStr("Program.Version");
        try {
            int firstIdx = version.indexOf(".");
            int secondIdx = version.indexOf(".", firstIdx + 1);
            int thirdIdx = version.indexOf(".", secondIdx + 1);
            if (thirdIdx == -1) {
                thirdIdx = version.length();
            }
            majorStr = version.substring(0, firstIdx);
            minorStr = version.substring(firstIdx + 1, secondIdx);
        }
        catch (NumberFormatException exp) {
            NLogger.error(VersionUtils.class, (Object)exp, (Throwable)exp);
            majorStr = "3";
            minorStr = "0";
        }
        MAJOR_VERSION_NUMBER = Integer.valueOf(majorStr);
        MINOR_VERSION_NUMBER = Integer.valueOf(minorStr);
    }
}

