/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.utils.URLCodecUtils;

public class URLUtil {
    public static String buildBitziLookupURL(URN urn) {
        String url = "http://en.wikipedia.org/wiki/Bitzi";
        return url;
    }

    public static String buildMagnetURL(String sha1NSS, String filename) {
        String url = "magnet:?xt=urn:sha1:" + sha1NSS + "&dn=" + URLCodecUtils.encodeURL(filename);
        return url;
    }

    public static String buildMagnetURLWithXS(String sha1NSS, String filename, DestAddress ha) {
        String url = "magnet:?xt=urn:sha1:" + sha1NSS + "&dn=" + URLCodecUtils.encodeURL(filename) + "&xs=" + URLUtil.buildHostURL(ha) + "/uri-res/N2R?" + "urn:sha1:" + sha1NSS;
        return url;
    }

    public static String buildFileURL(RemoteFile file) {
        return "http://" + file.getHostAddress().getFullHostName() + "/get/" + file.getFileIndex() + "/" + URLCodecUtils.encodeURL(file.getFilename());
    }

    public static String buildName2ResourceURL(URN urn) {
        return "/uri-res/N2R?" + urn.getAsString();
    }

    public static String buildName2ResThexURL(URN urn, String tigerTreeRoot) {
        return "/uri-res/N2X?" + urn.getAsString() + ";" + tigerTreeRoot;
    }

    public static String buildFullName2ResourceURL(DestAddress ha, URN urn) {
        return URLUtil.buildHostURL(ha) + "/uri-res/N2R?" + urn.getAsString();
    }

    public static String buildHostURL(DestAddress address) {
        return "http://" + address.getFullHostName();
    }

    public static String getFileNameFromUri(URI uri) throws URIException {
        String path = uri.getPath();
        if (path == null) {
            return uri.getHost();
        }
        int at = path.lastIndexOf("/");
        int to = path.length();
        return at >= 0 ? path.substring(at + 1, to) : path;
    }

    public static String getPathQueryFromUri(URI uri) throws URIException {
        String path = uri.getPath();
        String query = uri.getQuery();
        uri.getCurrentHierPath();
        if (query != null && query.length() > 0) {
            return path + "?" + query;
        }
        if (path == null) {
            return "/";
        }
        return path;
    }

    public static URN getQueryURN(URI uri) throws URIException {
        String query = uri.getQuery();
        if (query != null && query.length() > 0 && URN.isValidURN(query)) {
            return new URN(query);
        }
        return null;
    }
}

