/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.InflaterInputStream;
import junit.framework.TestCase;
import phex.utils.IOUtil;

public class IOUtilTest
extends TestCase {
    public IOUtilTest(String string) {
        super(string);
    }

    protected void tearDown() {
    }

    protected void setUp() {
    }

    public void testDeflate() throws IOException {
        byte[] byArray = this.setUpRandomData();
        byte[] byArray2 = IOUtil.deflate(byArray);
        IOUtilTest.assertTrue((byArray2.length < byArray.length ? 1 : 0) != 0);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray2));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray3 = new byte[1024];
        int n = 0;
        do {
            if ((n = inflaterInputStream.read(byArray3)) <= 0) continue;
            byteArrayOutputStream.write(byArray3, 0, n);
        } while (n > 0);
        IOUtilTest.assertTrue((boolean)Arrays.equals(byteArrayOutputStream.toByteArray(), byArray));
    }

    public void testSimpleInflate() throws DataFormatException {
        byte[] byArray = this.setUpRandomData();
        byte[] byArray2 = IOUtil.deflate(byArray);
        byte[] byArray3 = IOUtil.inflate(byArray2);
        IOUtilTest.assertTrue((boolean)Arrays.equals(byArray3, byArray));
    }

    private byte[] setUpRandomData() {
        int n;
        byte[] byArray = new byte[100000];
        Random random = new Random();
        random.nextBytes(byArray);
        for (n = 300; n < 500; ++n) {
            byArray[n] = 0;
        }
        for (n = 3000; n < 5000; ++n) {
            byArray[n] = 0;
        }
        return byArray;
    }

    public void testCobs() throws IOException {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 1, 0, 0, 3, 0, 4, 3, 4, 5, 3, 6, 0, 0, 0, 0, 0, 0, 0, 3, 4, 3, 5, 4, 5, 6, 0, 0, 2, 3, 4, 2, 3};
        byte[] byArray2 = IOUtil.cobsEncode(byArray);
        byte[] byArray3 = IOUtil.cobsDecode(byArray2);
        IOUtilTest.assertTrue((boolean)Arrays.equals(byArray, byArray3));
        byArray = new byte[]{69, 0, 0, 44, 76, 121, 0, 0, 64, 6, 79, 55};
        byArray2 = IOUtil.cobsEncode(byArray);
        byte[] byArray4 = new byte[]{2, 69, 1, 4, 44, 76, 121, 1, 5, 64, 6, 79, 55};
        IOUtilTest.assertTrue((boolean)Arrays.equals(byArray2, byArray4));
        byArray3 = IOUtil.cobsDecode(byArray4);
        IOUtilTest.assertTrue((boolean)Arrays.equals(byArray, byArray3));
    }

    public void testLongDeSer() {
        byte[] byArray = IOUtil.serializeLong2MinLE(0L);
        IOUtilTest.assertEquals((long)0L, (long)IOUtil.deserializeLongLE(byArray, 0, byArray.length));
        byArray = IOUtil.serializeLong2MinLE(100000L);
        IOUtilTest.assertEquals((long)100000L, (long)IOUtil.deserializeLongLE(byArray, 0, byArray.length));
        long l = System.currentTimeMillis();
        byArray = IOUtil.serializeLong2MinLE(l);
        IOUtilTest.assertEquals((long)l, (long)IOUtil.deserializeLongLE(byArray, 0, byArray.length));
        byArray = IOUtil.serializeLong2MinLE(Long.MAX_VALUE);
        IOUtilTest.assertEquals((long)Long.MAX_VALUE, (long)IOUtil.deserializeLongLE(byArray, 0, byArray.length));
        Random random = new Random();
        for (int i = 0; i < 5000000; ++i) {
            l = Math.abs(random.nextLong());
            byArray = IOUtil.serializeLong2MinLE(l);
            IOUtilTest.assertEquals((long)l, (long)IOUtil.deserializeLongLE(byArray, 0, byArray.length));
        }
    }
}

