/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phex.common.ThreadTracking;
import phex.common.log.NLogger;

public class Executer
implements Runnable {
    File file;
    URL url;
    String command;

    public Executer(File file, String command) {
        this.url = null;
        this.file = file;
        this.command = command;
    }

    public Executer(URL url, String command) {
        this.url = url;
        this.file = null;
        this.command = command;
    }

    public Executer(String command) {
        this.url = null;
        this.file = null;
        this.command = command;
    }

    public void run() {
        block14: {
            if (this.command == null) {
                return;
            }
            String[] commands = Executer.parseCommandLine(this.command);
            System.out.println(commands);
            StringBuffer absFilename = null;
            if (this.file != null) {
                absFilename = new StringBuffer(this.file.getAbsolutePath().length() + 20);
                try {
                    for (int offset = 0; offset < this.file.getAbsolutePath().length(); ++offset) {
                        char currentChar = this.file.getAbsolutePath().charAt(offset);
                        if (currentChar == '\\') {
                            absFilename.append("\\\\");
                            continue;
                        }
                        absFilename.append(currentChar);
                    }
                }
                catch (IndexOutOfBoundsException offset) {
                    // empty catch block
                }
            }
            if (this.file != null || this.url != null) {
                for (int i = 0; i < commands.length; ++i) {
                    if (this.file != null) {
                        commands[i] = commands[i].replaceAll("%s", absFilename.toString());
                        try {
                            commands[i] = commands[i].replaceAll("%u", this.file.toURI().toURL().toExternalForm());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.url == null) continue;
                    commands[i] = commands[i].replaceAll("%u", this.url.toExternalForm());
                }
            }
            try {
                if (commands.length > 0) {
                    NLogger.error(Executer.class, (Object)("About to invoke " + Arrays.asList(commands)));
                    Runner i = new Runner(commands);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NLogger.error(Executer.class, (Object)"Cannot invoke previewer.");
                if (commands == null) break block14;
                NLogger.error(Executer.class, (Object)("Actual command was '" + commands + "'"));
            }
        }
    }

    public static String getViewCommand(String suffix) {
        return Executer.getViewCommand(suffix, true);
    }

    public static String getViewCommand(String suffix, boolean allowFallback) {
        String cmd = null;
        return cmd;
    }

    public static String matches(Iterator regexes, String name) {
        while (regexes.hasNext()) {
            Pattern p;
            Matcher m;
            StringBuffer regex;
            String entry = (String)regexes.next();
            if (entry.startsWith("^") && entry.endsWith("$")) {
                regex = new StringBuffer(entry);
            } else {
                regex = new StringBuffer();
                regex.append("^.*");
                regex.append(entry);
                regex.append("$");
            }
            if (!(m = (p = Pattern.compile(regex.toString(), 2)).matcher(name)).matches()) continue;
            return entry;
        }
        return null;
    }

    public static String[] parseCommandLine(String commandLine) {
        Pattern p = Pattern.compile("(\".*?\"|\\S+)", 2);
        Matcher m = p.matcher(commandLine);
        LinkedList<String> tokens = new LinkedList<String>();
        int counter = 0;
        while (m.find()) {
            tokens.add(m.group(1));
            ++counter;
        }
        String[] result = new String[counter];
        Iterator it = tokens.iterator();
        String quoteString = "\"";
        for (int i = 0; i < counter; ++i) {
            String field = (String)it.next();
            if (!field.startsWith("\"")) {
                // empty if block
            }
            result[i] = field;
        }
        return result;
    }

    private class Runner {
        public int result;

        public Runner(String commandLine) {
            this.go(Executer.parseCommandLine(commandLine));
        }

        public Runner(String[] commandLine) {
            this.go(commandLine);
        }

        public void go(String[] commands) {
            Process proc = null;
            try {
                proc = Runtime.getRuntime().exec(commands);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
            StringBuffer err = new StringBuffer();
            StringBuffer out = new StringBuffer();
            try {
                StreamReaderThread outThread = new StreamReaderThread(proc.getInputStream(), out);
                StreamReaderThread errThread = new StreamReaderThread(proc.getErrorStream(), err);
                outThread.start();
                errThread.start();
                this.result = proc.waitFor();
                outThread.join();
                errThread.join();
                if (this.result != 0) {
                    System.out.println("Process  returned non-zero value:" + this.result);
                    System.out.println("Process output:\n" + out.toString());
                    System.out.println("Process error:\n" + err.toString());
                } else {
                    System.out.println("Process  executed successfully");
                    System.out.println("Process output:\n" + out.toString());
                    System.out.println("Process error:\n" + err.toString());
                }
            }
            catch (Exception e) {
                System.out.println("Error executing. ");
                e.printStackTrace();
            }
        }

        private String[] parseCommandLineOld(String commandLine) {
            StringReader r = new StringReader(commandLine);
            StreamTokenizer t = new StreamTokenizer(r);
            t.wordChars(0, 255);
            t.quoteChar(34);
            t.whitespaceChars(32, 32);
            LinkedList<String> tokens = new LinkedList<String>();
            int counter = 0;
            try {
                while (t.nextToken() != -1) {
                    tokens.add(t.sval);
                    ++counter;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            String[] result = new String[counter];
            Iterator it = tokens.iterator();
            String quoteString = "\"";
            for (int i = 0; i < counter; ++i) {
                result[i] = quoteString + (String)it.next() + quoteString;
            }
            return result;
        }

        public class StreamReaderThread
        extends Thread {
            StringBuffer mOut;
            InputStreamReader mIn;

            public StreamReaderThread(InputStream in, StringBuffer out) {
                super(ThreadTracking.rootThreadGroup, "StreamReaderThread");
                this.mOut = out;
                this.mIn = new InputStreamReader(in);
            }

            public void run() {
                try {
                    int ch;
                    while (-1 != (ch = this.mIn.read())) {
                        this.mOut.append((char)ch);
                    }
                }
                catch (Exception e) {
                    this.mOut.append("\nRead error:" + e.getMessage());
                }
            }
        }
    }
}

