/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.util.HashSet;
import java.util.Set;
import phex.common.AlternateLocation;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.bandwidth.TransferAverage;
import phex.common.log.LogRecord;
import phex.common.log.NLogger;
import phex.prefs.core.UploadPrefs;
import phex.upload.UploadEngine;
import phex.upload.UploadManager;
import phex.upload.UploadStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadState
implements TransferDataProvider {
    private final UploadManager uploadManager;
    private long transferredDataSize;
    private int currentProgress;
    private UploadStatus status;
    private DestAddress hostAddress;
    private String vendor;
    private String fileName;
    private URN fileURN;
    private UploadEngine uploadEngine;
    private long previousSegmentsSize;
    private TransferAverage transferAverage;
    private Set<AlternateLocation> sendAltLocSet;
    private long transferLength;

    public UploadState(DestAddress hostAddress, String vendor, UploadManager uploadManager) {
        this(hostAddress, vendor, null, null, -1L, uploadManager);
    }

    public UploadState(DestAddress hostAddress, String vendor, String fileName, URN fileURN, long contentLength, UploadManager uploadManager) {
        this.uploadManager = uploadManager;
        this.transferredDataSize = 0L;
        this.previousSegmentsSize = 0L;
        this.currentProgress = 0;
        this.sendAltLocSet = new HashSet<AlternateLocation>();
        this.hostAddress = hostAddress;
        this.vendor = vendor;
        this.fileName = fileName;
        this.fileURN = fileURN;
        this.transferLength = contentLength;
        this.status = UploadStatus.ACCEPTING_REQUEST;
        this.transferAverage = new TransferAverage(1000, 10);
    }

    public void update(String fileName, URN fileURN, long contentLength) {
        this.fileName = fileName;
        this.fileURN = fileURN;
        this.transferLength = contentLength;
    }

    public Set<AlternateLocation> getSendAltLocSet() {
        return this.sendAltLocSet;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public UploadStatus getStatus() {
        return this.status;
    }

    public void addToUploadLog(String message) {
        if (UploadPrefs.UploadStateLogBufferSize.get() > 0) {
            LogRecord record = new LogRecord(this, message);
            this.uploadManager.getUploadStateLogBuffer().addLogRecord(record);
        }
    }

    public void setStatus(UploadStatus newStatus) {
        if (this.status == newStatus) {
            return;
        }
        NLogger.debug(UploadState.class, (Object)("UploadState Status " + (Object)((Object)newStatus)));
        this.addToUploadLog("UploadState Status " + (Object)((Object)newStatus));
        this.status = newStatus;
    }

    public boolean isUploadRunning() {
        return this.status == UploadStatus.HANDSHAKE || this.status == UploadStatus.UPLOADING_THEX || this.status == UploadStatus.UPLOADING_DATA;
    }

    public boolean isReadyForCleanup() {
        return this.status == UploadStatus.COMPLETED || this.status == UploadStatus.ABORTED;
    }

    public void setUploadEngine(UploadEngine uploadEngine) {
        this.uploadEngine = uploadEngine;
    }

    public void setTransferredDataSize(long aTransferredSize) {
        long diff = aTransferredSize - this.transferredDataSize;
        if (diff < 0L) {
            this.previousSegmentsSize += this.transferredDataSize;
            this.transferAverage.addValue(aTransferredSize);
        } else {
            this.transferAverage.addValue(diff);
        }
        this.transferredDataSize = aTransferredSize;
    }

    public int getProgress() {
        if (this.status == UploadStatus.COMPLETED) {
            this.currentProgress = 100;
        } else {
            long toTransfer = this.getTransferDataSize();
            this.currentProgress = (int)(this.getTransferredDataSize() * 100L / (toTransfer == 0L ? 1L : toTransfer));
        }
        return this.currentProgress;
    }

    public void stopUpload() {
        if (this.uploadEngine != null) {
            this.uploadEngine.stopUpload();
        }
        this.setStatus(UploadStatus.ABORTED);
    }

    public long getTransferSpeed() {
        return this.transferAverage.getAverage();
    }

    @Override
    public long getTransferDataSize() {
        return this.transferLength + this.previousSegmentsSize;
    }

    @Override
    public long getTransferredDataSize() {
        return this.transferredDataSize + this.previousSegmentsSize;
    }

    @Override
    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    @Override
    public void setTransferRateTimestamp(long timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    @Override
    public short getDataTransferStatus() {
        switch (this.status) {
            case HANDSHAKE: 
            case UPLOADING_DATA: 
            case UPLOADING_THEX: {
                return 10;
            }
            case ABORTED: {
                return 13;
            }
            case COMPLETED: {
                return 12;
            }
        }
        return 11;
    }
}

