/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.IOException;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.log.NLogger;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.io.buffer.ByteBuffer;
import phex.net.connection.Connection;
import phex.net.repres.SocketFacade;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.upload.UploadStatus;
import phex.upload.handler.FileUploadHandler;
import phex.upload.handler.ThexUploadHandler;
import phex.upload.handler.UploadHandler;
import phex.upload.response.UploadResponse;
import phex.utils.StringUtils;

public class UploadEngine {
    private final UploadManager uploadMgr;
    private final SharedFilesService sharedFilesService;
    private final Connection connection;
    private HTTPRequest httpRequest;
    private UploadState uploadState;
    public boolean isUploadCounted;
    private UploadHandler uploadHandler;

    public UploadEngine(Connection connection, HTTPRequest httpRequest, UploadManager uploadManager, SharedFilesService sharedFilesService) {
        this.sharedFilesService = sharedFilesService;
        this.connection = connection;
        this.uploadMgr = uploadManager;
        connection.setBandwidthController(this.uploadMgr.getUploadBandwidthController());
        this.httpRequest = httpRequest;
        this.isUploadCounted = false;
        SocketFacade socket = connection.getSocket();
        DestAddress hostAddress = socket.getRemoteAddress();
        this.uploadState = new UploadState(hostAddress, "?", uploadManager);
    }

    public void startUpload() {
        NLogger.debug(UploadEngine.class, (Object)"Start upload.");
        this.uploadState.addToUploadLog("Start upload.");
        boolean followUpRequestAvailable = false;
        try {
            do {
                try {
                    this.uploadHandler = this.httpRequest.getGnutellaRequest().isTigerTreeRequest() ? new ThexUploadHandler(this.sharedFilesService) : new FileUploadHandler(this.sharedFilesService, Servent.getInstance());
                    UploadResponse response = this.uploadHandler.determineUploadResponse(this.httpRequest, this.uploadState, this.uploadMgr);
                    this.sendHTTPResponse(response.buildHTTPResponseString());
                    if (this.uploadHandler.isQueued()) {
                        this.connection.getSocket().setSoTimeout(this.uploadHandler.getQueueMaxNextPollTime());
                    } else if (response.remainingBody() > 0 && !this.httpRequest.isHeadRequest()) {
                        this.uploadState.setUploadEngine(this);
                        this.connection.getSocket().setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
                        this.sendResponseData(response);
                    }
                    this.uploadState.setStatus(UploadStatus.COMPLETED);
                }
                catch (IOException exp) {
                    this.uploadState.setStatus(UploadStatus.ABORTED);
                    throw exp;
                }
                followUpRequestAvailable = false;
                if (!this.uploadHandler.isPersistentConnection()) continue;
                try {
                    this.readNextHTTPRequest();
                    followUpRequestAvailable = true;
                }
                catch (IOException exp) {
                    NLogger.debug(UploadEngine.class, (Object)exp);
                    this.uploadState.addToUploadLog(exp.toString() + " - " + exp.getMessage());
                }
            } while (followUpRequestAvailable);
            this.uploadState.setStatus(UploadStatus.COMPLETED);
        }
        catch (Exception exp) {
            this.uploadState.setStatus(UploadStatus.ABORTED);
            NLogger.error(UploadEngine.class, (Object)exp, (Throwable)exp);
            this.uploadState.addToUploadLog(exp.toString() + " - " + exp.getMessage());
        }
        finally {
            assert (!this.uploadState.isUploadRunning()) : "Upload state should not be in running status anymore. Request: " + this.httpRequest.buildHTTPRequestString();
            this.stopUpload();
            this.uploadMgr.releaseUploadAddress(this.uploadState.getHostAddress());
            this.uploadState.setUploadEngine(null);
            if (this.uploadHandler.isQueued()) {
                this.uploadMgr.removeQueuedUpload(this.uploadState);
            }
        }
    }

    public void stopUpload() {
        this.connection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponseData(UploadResponse response) throws IOException {
        NLogger.debug(UploadEngine.class, (Object)("About to send response data: " + response.remainingBody() + " bytes."));
        this.uploadState.addToUploadLog("About to send response data: " + response.remainingBody() + " bytes.");
        if (!this.isUploadCounted) {
            response.countUpload();
            StatisticsManager statMgr = Servent.getInstance().getStatisticsService();
            SimpleStatisticProvider provider = (SimpleStatisticProvider)statMgr.getStatisticProvider("SessionUploadCountProvider");
            provider.increment(1);
            this.isUploadCounted = true;
        }
        this.uploadState.setStatus(UploadStatus.UPLOADING_DATA);
        BandwidthController throttleController = this.uploadMgr.getUploadBandwidthController();
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = ByteBuffer.allocate(16384);
            long lengthUploaded = 0L;
            while (response.remainingBody() > 0) {
                int likeToSend = Math.min(response.remainingBody(), byteBuffer.capacity());
                int ableToSend = throttleController.getAvailableByteCount(likeToSend, true, false);
                byteBuffer.clear();
                byteBuffer.limit(ableToSend);
                int lengthRead = response.fillBody(byteBuffer);
                byteBuffer.flip();
                if (!byteBuffer.hasRemaining()) {
                    break;
                }
                this.connection.write(byteBuffer);
                this.uploadState.setTransferredDataSize(lengthUploaded += (long)lengthRead);
            }
        }
        finally {
            byteBuffer = null;
            response.close();
        }
    }

    private void readNextHTTPRequest() throws IOException {
        try {
            this.httpRequest = HTTPProcessor.parseHTTPRequest(this.connection);
            if (this.uploadHandler.isQueued() && System.currentTimeMillis() < this.uploadHandler.getQueueMinNextPollTime()) {
                throw new IOException("Queued host is requesting too soon.");
            }
        }
        catch (HTTPMessageException exp) {
            throw new IOException("Invalid HTTP Message: " + exp.getMessage());
        }
    }

    private void sendHTTPResponse(String httpResponseStr) throws IOException {
        String logMsg = "HTTP Response: " + httpResponseStr;
        NLogger.debug(UploadEngine.class, (Object)logMsg);
        this.uploadState.addToUploadLog(logMsg);
        this.connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii(httpResponseStr)));
    }
}

