/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import phex.common.address.DefaultDestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.gui.prefs.InterfacePrefs;
import phex.gui.prefs.PhexGuiPrefs;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.PhexCorePrefs;
import phex.servent.Servent;
import phex.share.ShareFile;
import phex.upload.HrrnQueueComparator;
import phex.upload.UploadManager;
import phex.upload.UploadQueueState;
import phex.upload.UploadState;
import phex.utils.Localizer;

public class HrrnQueuePerformanceTest
extends TestCase {
    private static final int TOTAL_FILES = 20;
    private static final int MAX_QUEUE_LENGTH = 10;
    private static final int MAX_UPLOAD_SLOTS = 3;
    private static final int SMALL_FILE_MIN = 2048;
    private static final int SMALL_FILE_ADD = 2048;
    private static final int LARGE_FILE_MIN = 600000;
    private static final int LARGE_FILE_ADD = 600000;
    private static final int SPEED = 100000;
    private static final int MAX_SPEED_PER_FILE = 16666;
    private static Random rand = new Random();
    private UploadManager uploadManager;

    public void setUp() {
        PhexCorePrefs.init();
        PhexGuiPrefs.init();
        Localizer.initialize(InterfacePrefs.LocaleName.get());
        Servent servent = Servent.getInstance();
        this.uploadManager = new UploadManager(servent);
        BandwidthPrefs.MaxUploadBandwidth.set(100000);
    }

    public void testRunFifo() {
        System.out.println("----------FIFO--------------");
        Provider provider = new Provider(true, 20);
        Consumer consumer = new Consumer(provider);
        provider.start();
        try {
            Thread.sleep(100L);
            consumer.start();
            consumer.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void testRunHrrn() {
        System.out.println("----------HRRN--------------");
        Provider provider = new Provider(false, 20);
        Consumer consumer = new Consumer(provider);
        provider.start();
        try {
            Thread.sleep(100L);
            consumer.start();
            consumer.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private static class DummyShareFile
    extends ShareFile {
        private long queueTime;
        private long uploadStart;
        private long leftFileSize;

        public DummyShareFile(int n, long l) {
            super(l);
            this.setFileIndex(n);
            this.leftFileSize = l;
        }

        public void trackUp() {
            this.uploadStart = System.currentTimeMillis();
        }

        public long getLeftFileSize() {
            return this.leftFileSize;
        }

        public void uploadSize(long l) {
            this.leftFileSize -= l;
        }
    }

    public class Consumer
    extends Thread {
        private CharArrayWriter writter;
        private List<UploadQueueState> uploads = new ArrayList<UploadQueueState>();
        private Provider provider;
        private BandwidthController bdw = new BandwidthController("up", BandwidthPrefs.MaxUploadBandwidth.get().intValue());

        public Consumer(Provider provider) {
            this.provider = provider;
            this.writter = new CharArrayWriter();
        }

        @Override
        public void run() {
            long l = 0L;
            long l2 = System.currentTimeMillis();
            try {
                while (true) {
                    Object object;
                    if (this.uploads.size() < 3) {
                        object = this.provider.pop();
                        if (object != null) {
                            this.uploads.add((UploadQueueState)object);
                            long l3 = System.currentTimeMillis();
                            DummyShareFile dummyShareFile = (DummyShareFile)((UploadQueueState)object).getLastRequestedFile();
                            dummyShareFile.queueTime = l3 - ((UploadQueueState)object).getFirstQueueTime();
                            System.out.println("Uploading: #" + dummyShareFile.getFileIndex() + " - " + dummyShareFile.queueTime + "ms");
                            dummyShareFile.trackUp();
                            continue;
                        }
                        if (this.uploads.size() == 0) break;
                    }
                    object = this.uploads.listIterator();
                    while (object.hasNext()) {
                        UploadQueueState uploadQueueState = (UploadQueueState)object.next();
                        DummyShareFile dummyShareFile = (DummyShareFile)uploadQueueState.getLastRequestedFile();
                        long l4 = dummyShareFile.getLeftFileSize();
                        int n = (int)Math.min(l4, 16666L);
                        int n2 = this.bdw.getAvailableByteCount(n, false, true);
                        l += (long)n2;
                        dummyShareFile.uploadSize(n2);
                        if (dummyShareFile.getLeftFileSize() > 0L) continue;
                        long l5 = System.currentTimeMillis();
                        long l6 = Math.max(l5 - dummyShareFile.uploadStart, 1L);
                        System.out.println("Uploaded: #" + dummyShareFile.getFileIndex() + " - " + dummyShareFile.getFileSize() + "KB - " + l6 + "ms - " + (double)dummyShareFile.getFileSize() / ((double)l6 / 1000.0) + "KB/s");
                        object.remove();
                        this.writter.append(String.valueOf(dummyShareFile.getFileSize()));
                        this.writter.append(" ");
                        this.writter.append(String.valueOf(dummyShareFile.queueTime));
                        this.writter.append(" ");
                        this.writter.append(String.valueOf(l6));
                        this.writter.append("\n");
                    }
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            long l7 = System.currentTimeMillis();
            double d = (double)(l7 - l2) / 1000.0;
            System.out.println("Took: " + d + "s");
            System.out.println("Transferred: " + l + "KB - " + (double)l / d + "KB/s");
            System.out.println("====================================================");
            System.out.println(this.writter.toString());
            System.out.println("====================================================");
        }
    }

    public class Provider
    extends Thread {
        private int fileIndex = 1;
        private int maxUploads;
        private boolean isFifo;
        private List<UploadQueueState> list;

        public Provider(boolean bl, int n) {
            this.maxUploads = n;
            this.isFifo = bl;
            this.list = Collections.synchronizedList(new ArrayList());
        }

        @Override
        public void run() {
            while (this.maxUploads > 0) {
                if (this.list.size() < 10) {
                    this.add();
                    --this.maxUploads;
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private synchronized void add() {
            boolean bl = rand.nextBoolean();
            long l = bl ? (long)(2048 + rand.nextInt(2048)) : (long)(600000 + rand.nextInt(600000));
            UploadState uploadState = new UploadState(new DefaultDestAddress("", 0), "", HrrnQueuePerformanceTest.this.uploadManager);
            DummyShareFile dummyShareFile = new DummyShareFile(this.fileIndex++, l);
            UploadQueueState uploadQueueState = new UploadQueueState(uploadState, dummyShareFile);
            if (this.isFifo) {
                this.list.add(uploadQueueState);
            } else {
                this.list.add(uploadQueueState);
                long l2 = System.currentTimeMillis();
                Collections.sort(this.list, new HrrnQueueComparator(l2));
            }
            System.out.println("Queued (" + this.list.size() + "): #" + dummyShareFile.getFileIndex() + " - " + dummyShareFile.getFileSize() + "kb");
        }

        public synchronized UploadQueueState pop() {
            if (this.list.size() == 0) {
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.list.size() > 0) {
                return this.list.remove(0);
            }
            return null;
        }
    }
}

