/*
 * Decompiled with CFR 0.152.
 */
package phex.udp.hostcache;

import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.net.repres.PresentationManager;
import phex.servent.Servent;

public class UdpHostCache {
    public static final int MAX_FAIL_COUNT = 3;
    private DestAddress address;
    private int failedCount;

    public UdpHostCache(DestAddress addr) {
        this.address = addr;
        this.failedCount = 0;
    }

    public UdpHostCache(DestAddress addr, int failCount) {
        this.address = addr;
        this.failedCount = failCount;
    }

    public UdpHostCache(String aHostName, int aPort, int failCount) throws IllegalArgumentException {
        try {
            this.address = PresentationManager.getInstance().createHostAddress(aHostName, aPort);
        }
        catch (MalformedDestAddressException e) {
            throw new IllegalArgumentException("Malformed destination address.");
        }
        this.failedCount = failCount;
    }

    public void pingCache() {
        Servent.getInstance().getMessageService().sendUdpPing(this.address);
    }

    public void incrementFailCount() {
        if (this.failedCount < 3) {
            ++this.failedCount;
        }
    }

    public void decrementFailCount() {
        --this.failedCount;
    }

    public int getFailCount() {
        return this.failedCount;
    }

    public void resetFailCount() {
        this.failedCount = 0;
    }

    public DestAddress getHostAddress() {
        return this.address;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UdpHostCache) {
            UdpHostCache objCache = (UdpHostCache)obj;
            return this.address.equals(objCache.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        String str = " Host Address : " + this.address + " [ failure count : " + this.failedCount + " ] ";
        return str;
    }
}

