/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import phex.common.AbstractLifeCycle;
import phex.common.Environment;
import phex.common.QueryRoutingTable;
import phex.common.RunnerQueueWorker;
import phex.common.ThreadTracking;
import phex.common.URN;
import phex.common.collections.IntSet;
import phex.common.collections.StringTrie;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.event.PhexEventService;
import phex.msg.QueryMsg;
import phex.prefs.core.LibraryPrefs;
import phex.servent.Servent;
import phex.share.FileRescanRunner;
import phex.share.QueryResultSearchEngine;
import phex.share.ShareFile;
import phex.share.SharedDirectory;
import phex.share.SharedResource;
import phex.share.UrnCalculationWorker;
import phex.thex.FileHashCalculationHandler;
import phex.thex.ThexCalculationWorker;
import phex.utils.FileUtils;
import phex.utils.ReadWriteLock;
import phex.utils.StringUtils;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.share.DSharedFile;
import phex.xml.sax.share.DSharedLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFilesService
extends AbstractLifeCycle
implements FileHashCalculationHandler {
    private final PhexEventService eventService;
    private ReadWriteLock rwLock;
    private QueryResultSearchEngine searchEngine;
    private HashMap<File, SharedDirectory> directoryShareMap;
    private ArrayList<SharedDirectory> sharedDirectories;
    private HashMap<URN, ShareFile> urnToFileMap;
    private HashMap<String, ShareFile> nameToFileMap;
    private Map<Long, Set<ShareFile>> timeToFileMap;
    private ArrayList<ShareFile> indexedSharedFiles;
    private ArrayList<ShareFile> sharedFiles;
    private int totalFileSizeKb;
    private StringTrie<IntSet> keywordTrie;
    private QueryRoutingTable localRoutingTable;
    private boolean localQRTNeedsUpdate;
    private RunnerQueueWorker urnThexCalculationRunner;
    private static Object saveSharedFilesLock = new Object();
    private SaveSharedFilesJob saveSharedFilesJob;

    public SharedFilesService(Servent servent) {
        this.eventService = servent.getEventService();
        this.rwLock = new ReadWriteLock();
        this.urnThexCalculationRunner = new RunnerQueueWorker(4);
        Environment.getInstance().scheduleTimerTask(new FileRescanTimer(), 60000L, 60000L);
        this.searchEngine = new QueryResultSearchEngine(servent, this);
        this.directoryShareMap = new HashMap();
        this.sharedDirectories = new ArrayList();
        this.urnToFileMap = new HashMap();
        this.nameToFileMap = new HashMap();
        this.timeToFileMap = new TreeMap(Collections.reverseOrder());
        this.indexedSharedFiles = new ArrayList();
        this.sharedFiles = new ArrayList();
        this.keywordTrie = new StringTrie(true);
        this.totalFileSizeKb = 0;
        this.localQRTNeedsUpdate = true;
    }

    @Override
    protected void doStart() throws Exception {
        FileRescanRunner.rescan(this, true, false);
    }

    @Override
    protected void doStop() throws Exception {
        this.triggerSaveSharedFiles();
    }

    public List<ShareFile> handleQuery(QueryMsg queryMsg) {
        return this.searchEngine.handleQuery(queryMsg);
    }

    public QueryRoutingTable getLocalRoutingTable() {
        if (this.localQRTNeedsUpdate) {
            this.localRoutingTable = QueryRoutingTable.createLocalQueryRoutingTable(this);
        }
        return this.localRoutingTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSharedFilePath(File file) {
        this.rwLock.readLock();
        try {
            File highestDir = file.getParentFile();
            ArrayList sharedDirectoriesCopy = new ArrayList(LibraryPrefs.SharedDirectoriesSet.get());
            for (String dirStr : sharedDirectoriesCopy) {
                File dir = new File(dirStr);
                if (!FileUtils.isChildOfDir(file, dir) || !FileUtils.isChildOfDir(highestDir, dir)) continue;
                highestDir = dir;
            }
            File highestParent = highestDir.getParentFile();
            if (highestParent != null) {
                highestDir = highestParent;
            }
            String pathStr = highestDir.getAbsolutePath();
            int length = pathStr.length();
            if (!pathStr.endsWith(File.separator)) {
                ++length;
            }
            String string = file.getAbsolutePath().substring(length);
            return string;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByName(String name) {
        this.rwLock.readLock();
        try {
            ShareFile shareFile = this.nameToFileMap.get(name);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public ShareFile getShareFileByFile(File file) {
        return this.getFileByName(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileAt(int index) {
        this.rwLock.readLock();
        try {
            if (index >= this.sharedFiles.size()) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = this.sharedFiles.get(index);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public Iterator<IntSet> getIndexIteratorForPrefixTerm(String searchTerm, int startOffset, int stopOffset) {
        return this.keywordTrie.getPrefixedBy(searchTerm, startOffset, stopOffset);
    }

    public List<ShareFile> getSharedFiles() {
        this.rwLock.readLock();
        try {
            ArrayList<ShareFile> arrayList = new ArrayList<ShareFile>(this.sharedFiles);
            return arrayList;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public int getFileCount() {
        this.rwLock.readLock();
        try {
            int n = this.sharedFiles.size();
            return n;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public int getTotalFileSizeInKb() {
        this.rwLock.readLock();
        try {
            int n = this.totalFileSizeKb;
            return n;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByIndex(int fileIndex) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (fileIndex >= this.indexedSharedFiles.size()) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = this.indexedSharedFiles.get(fileIndex);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByURN(URN fileURN) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (fileURN == null) {
                ShareFile shareFile = null;
                return shareFile;
            }
            ShareFile shareFile = this.urnToFileMap.get(fileURN);
            return shareFile;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNShared(URN fileURN) throws IndexOutOfBoundsException {
        this.rwLock.readLock();
        try {
            if (fileURN == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.urnToFileMap.containsKey(fileURN);
            return bl;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShareFile> getFilesByURNs(URN[] urns) {
        this.rwLock.readLock();
        try {
            ArrayList<ShareFile> results = new ArrayList<ShareFile>(urns.length);
            for (int i = 0; i < urns.length; ++i) {
                ShareFile file = this.urnToFileMap.get(urns[i]);
                if (file == null) continue;
                results.add(file);
            }
            ArrayList<ShareFile> arrayList = results;
            return arrayList;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public List<ShareFile> getNewestFiles(int count) {
        ArrayList<ShareFile> fileList = new ArrayList<ShareFile>();
        Iterator<Map.Entry<Long, Set<ShareFile>>> iterator = this.timeToFileMap.entrySet().iterator();
        while (iterator.hasNext() && fileList.size() < count) {
            Set<ShareFile> fileSet = iterator.next().getValue();
            Iterator<ShareFile> setIterator = fileSet.iterator();
            while (setIterator.hasNext() && fileList.size() < count) {
                ShareFile shareFile = setIterator.next();
                fileList.add(shareFile);
            }
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSharedFile(ShareFile shareFile) {
        File file = shareFile.getSystemFile();
        if (this.getFileByName(file.getAbsolutePath()) != null) {
            return;
        }
        this.rwLock.writeLock();
        try {
            int position = this.indexedSharedFiles.size();
            shareFile.setFileIndex(position);
            this.indexedSharedFiles.add(shareFile);
            this.sharedFiles.add(shareFile);
            this.nameToFileMap.put(file.getAbsolutePath(), shareFile);
            String keywordsString = this.getSharedFilePath(shareFile.getSystemFile()).toLowerCase();
            String[] keywords = StringUtils.split(keywordsString, " -,._+/*()[]\\");
            for (int i = 0; i < keywords.length; ++i) {
                IntSet indices = this.keywordTrie.get(keywords[i]);
                if (indices == null) {
                    indices = new IntSet();
                    this.keywordTrie.add(keywords[i], indices);
                }
                indices.add(position);
            }
            this.totalFileSizeKb = (int)((long)this.totalFileSizeKb + file.length() / 1024L);
            this.localQRTNeedsUpdate = true;
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    private void addTimeToFile(ShareFile shareFile) {
        try {
            this.rwLock.assertWriteLock();
        }
        catch (IllegalAccessException exp) {
            NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
        }
        Long time = shareFile.getNetworkCreateTime();
        Set<ShareFile> shareFileSet = this.timeToFileMap.get(time);
        if (shareFileSet == null) {
            shareFileSet = new HashSet<ShareFile>();
            this.timeToFileMap.put(time, shareFileSet);
        }
        shareFileSet.add(shareFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            int fileIndex = shareFile.getFileIndex();
            this.indexedSharedFiles.set(fileIndex, null);
            String keywordsString = this.getSharedFilePath(shareFile.getSystemFile()).toLowerCase();
            String[] keywords = StringUtils.split(keywordsString, " -,._+/*()[]\\");
            for (int i = 0; i < keywords.length; ++i) {
                IntSet indices = this.keywordTrie.get(keywords[i]);
                if (indices == null) continue;
                indices.remove(fileIndex);
                if (indices.size() != 0) continue;
                this.keywordTrie.remove(keywords[i]);
            }
            File file = shareFile.getSystemFile();
            this.urnToFileMap.remove(shareFile.getURN());
            this.nameToFileMap.remove(file.getAbsolutePath());
            this.removeTimeToFile(shareFile);
            int position = this.sharedFiles.indexOf(shareFile);
            if (position != -1) {
                this.sharedFiles.remove(position);
                this.totalFileSizeKb = (int)((long)this.totalFileSizeKb - shareFile.getFileSize() / 1024L);
                this.localQRTNeedsUpdate = true;
            }
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    private void removeTimeToFile(ShareFile shareFile) {
        try {
            this.rwLock.assertWriteLock();
        }
        catch (IllegalAccessException exp) {
            NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
        }
        Long time = shareFile.getNetworkCreateTime();
        Set<ShareFile> shareFileSet = this.timeToFileMap.get(time);
        if (shareFileSet == null) {
            return;
        }
        shareFileSet.remove(shareFile);
        if (shareFileSet.size() == 0) {
            this.timeToFileMap.remove(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSharedDirecotries(HashMap<File, SharedDirectory> sharedDirectoryMap, HashSet<SharedDirectory> sharedDirectoryList) {
        this.rwLock.writeLock();
        try {
            this.directoryShareMap.clear();
            this.directoryShareMap.putAll(sharedDirectoryMap);
            this.sharedDirectories.clear();
            this.sharedDirectories.addAll(sharedDirectoryList);
            this.sharedDirectoriesChanged();
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedDirectory[] getSharedDirectories() {
        this.rwLock.readLock();
        try {
            SharedDirectory[] array = new SharedDirectory[this.sharedDirectories.size()];
            SharedDirectory[] sharedDirectoryArray = array = this.sharedDirectories.toArray(array);
            return sharedDirectoryArray;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedDirectory getSharedDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        this.rwLock.readLock();
        try {
            SharedResource resource = this.directoryShareMap.get(file);
            if (resource instanceof SharedDirectory) {
                SharedDirectory sharedDirectory = (SharedDirectory)resource;
                return sharedDirectory;
            }
            SharedDirectory sharedDirectory = null;
            return sharedDirectory;
        }
        finally {
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    public void addUrn2FileMapping(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            assert (shareFile.getURN() != null);
            this.urnToFileMap.put(shareFile.getURN(), shareFile);
            this.addTimeToFile(shareFile);
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    @Override
    public void queueUrnCalculation(ShareFile shareFile) {
        UrnCalculationWorker worker = new UrnCalculationWorker(shareFile, this);
        this.urnThexCalculationRunner.add(worker);
    }

    @Override
    public void queueThexCalculation(ShareFile shareFile) {
        ThexCalculationWorker worker = new ThexCalculationWorker(shareFile);
        this.urnThexCalculationRunner.add(worker);
    }

    public void setCalculationRunnerPause(boolean state) {
        this.urnThexCalculationRunner.setPause(state);
    }

    public int getCalculationRunnerQueueSize() {
        return this.urnThexCalculationRunner.getQueueSize();
    }

    public void clearSharedFiles() {
        this.rwLock.writeLock();
        try {
            this.urnThexCalculationRunner.stopAndClear();
            this.sharedFiles.clear();
            this.indexedSharedFiles.clear();
            this.urnToFileMap.clear();
            this.nameToFileMap.clear();
            this.timeToFileMap.clear();
            this.totalFileSizeKb = 0;
            this.localQRTNeedsUpdate = true;
        }
        finally {
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException exp) {
                NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSaveSharedFiles() {
        NLogger.debug(SharedFilesService.class, (Object)"Trigger save shared files...");
        Object object = saveSharedFilesLock;
        synchronized (object) {
            if (this.saveSharedFilesJob != null) {
                this.saveSharedFilesJob.triggerFollowUpSave();
            } else {
                this.saveSharedFilesJob = new SaveSharedFilesJob();
                this.saveSharedFilesJob.start();
            }
        }
    }

    public DSharedLibrary loadSharedLibrary() {
        DPhex dPhex;
        NLogger.debug(SharedFilesService.class, (Object)"Load shared library configuration file.");
        File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
        try {
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(file);
            dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug(SharedFilesService.class, (Object)"No shared library configuration file found.");
                return null;
            }
        }
        catch (InterruptedIOException exp) {
            return null;
        }
        catch (IOException exp) {
            NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SharedFilesLoadFailed", new String[]{exp.toString()});
            try {
                FileUtils.copyFile(file, new File(file.getAbsolutePath() + ".failed"));
            }
            catch (IOException e) {
                NLogger.error(SharedFilesService.class, (Object)("Failed to store failed file copy: " + exp.getMessage()));
            }
            return null;
        }
        catch (ManagedFileException exp) {
            NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("SharedFilesLoadFailed", new String[]{exp.toString()});
            return null;
        }
        DSharedLibrary sharedLibrary = dPhex.getSharedLibrary();
        return sharedLibrary;
    }

    private void sharedDirectoriesChanged() {
        this.eventService.publish("phex:share/update", "");
    }

    private class SaveSharedFilesJob
    extends Thread {
        private volatile boolean isFollowUpSaveTriggered;

        public SaveSharedFilesJob() {
            super(ThreadTracking.rootThreadGroup, "SaveSharedFilesJob");
            this.setPriority(1);
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileManager fileMgr = FileManager.getInstance();
            File libraryFile = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
            File tmpFile = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml.tmp");
            do {
                NLogger.debug(SharedFilesService.class, (Object)"Saving shared library.");
                this.isFollowUpSaveTriggered = false;
                SharedFilesService.this.rwLock.readLock();
                try {
                    DPhex dPhex = new DPhex();
                    dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
                    DSharedLibrary dLibrary = this.createDSharedLibrary();
                    dPhex.setSharedLibrary(dLibrary);
                    ManagedFile tmpMgFile = fileMgr.getReadWriteManagedFile(tmpFile);
                    XMLBuilder.saveToFile(tmpMgFile, dPhex);
                    ManagedFile libraryMgFile = fileMgr.getReadWriteManagedFile(libraryFile);
                    try {
                        libraryMgFile.acquireFileLock();
                        FileUtils.copyFile(tmpFile, libraryFile);
                    }
                    finally {
                        libraryMgFile.releaseFileLock();
                    }
                }
                catch (ManagedFileException exp) {
                    if (exp.getCause() instanceof InterruptedException) {
                        NLogger.debug(SharedFilesService.class, (Object)exp);
                        continue;
                    }
                    NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("SharedFilesSaveFailed", new String[]{exp.toString()});
                    NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
                }
                catch (IOException exp) {
                    NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
                    Environment.getInstance().fireDisplayUserMessage("SharedFilesSaveFailed", new String[]{exp.toString()});
                }
                finally {
                    try {
                        SharedFilesService.this.rwLock.readUnlock();
                    }
                    catch (IllegalAccessException exp) {
                        NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
                    }
                }
            } while (this.isFollowUpSaveTriggered);
            NLogger.debug(SharedFilesService.class, (Object)"Finished saving download list...");
            Object object = saveSharedFilesLock;
            synchronized (object) {
                SharedFilesService.this.saveSharedFilesJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DSharedLibrary createDSharedLibrary() {
            DSharedLibrary library = new DSharedLibrary();
            SharedFilesService.this.rwLock.readLock();
            try {
                List<DSharedFile> sharedFileList = library.getSubElementList();
                for (ShareFile file : SharedFilesService.this.sharedFiles) {
                    try {
                        if (file.getURN() == null) continue;
                        DSharedFile dFile = file.createDSharedFile();
                        sharedFileList.add(dFile);
                    }
                    catch (Exception exp) {
                        NLogger.error(SharedFilesService.class, (Object)"SharedFile skipped due to error.", (Throwable)exp);
                    }
                }
            }
            finally {
                try {
                    SharedFilesService.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException exp) {
                    NLogger.error(SharedFilesService.class, (Object)exp, (Throwable)exp);
                }
            }
            return library;
        }
    }

    private class FileRescanTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private FileRescanTimer() {
        }

        public void run() {
            try {
                FileRescanRunner.rescan(SharedFilesService.this, false, false);
            }
            catch (Throwable th) {
                NLogger.error(SharedFilesService.class, (Object)th, th);
            }
        }
    }
}

