/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import phex.common.URN;
import phex.common.collections.IntSet;
import phex.common.log.NLogger;
import phex.msg.QueryMsg;
import phex.prefs.core.LibraryPrefs;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.share.ShareFile;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultSearchEngine {
    public static final String INDEX_QUERY_STRING = "    ";
    private final SharedFilesService sharedFilesService;
    private final Servent servent;

    public QueryResultSearchEngine(Servent servent, SharedFilesService sharedFilesService) {
        this.servent = servent;
        this.sharedFilesService = sharedFilesService;
    }

    public List<ShareFile> handleQuery(QueryMsg queryMsg) {
        if (queryMsg.getFeatureQuerySelector() > 1) {
            return Collections.emptyList();
        }
        if (queryMsg.isRequesterFirewalled() && this.servent.isFirewalled()) {
            return Collections.emptyList();
        }
        if (this.servent.isUploadLimitReached()) {
            return Collections.emptyList();
        }
        if (queryMsg.isWhatsNewQuery()) {
            return this.sharedFilesService.getNewestFiles(3);
        }
        String searchStr = queryMsg.getSearchString();
        if (searchStr.equals(INDEX_QUERY_STRING)) {
            NLogger.debug(QueryResultSearchEngine.class, (Object)"Index query detected.");
            return this.sharedFilesService.getSharedFiles();
        }
        List<ShareFile> urnMatches = null;
        URN[] urns = queryMsg.getQueryURNs();
        if (urns.length > 0 && (urnMatches = this.sharedFilesService.getFilesByURNs(urns)).size() == urns.length) {
            return this.provideResultData(urnMatches, null, queryMsg.getOriginIpAddress());
        }
        IntSet keyWordMatches = this.handleKeywordSearch(searchStr);
        return this.provideResultData(urnMatches, keyWordMatches, queryMsg.getOriginIpAddress());
    }

    private IntSet handleKeywordSearch(String searchStr) {
        IntSet searchMatches = null;
        int searchStrLength = searchStr.length();
        int startPos = 0;
        while (startPos < searchStrLength) {
            int endPos;
            if (StringUtils.isFileDelimiter(searchStr.charAt(startPos))) {
                ++startPos;
                continue;
            }
            for (endPos = startPos + 1; endPos < searchStrLength && !StringUtils.isFileDelimiter(searchStr.charAt(endPos)); ++endPos) {
            }
            Iterator<IntSet> indexIterator = this.sharedFilesService.getIndexIteratorForPrefixTerm(searchStr, startPos, endPos);
            if (indexIterator.hasNext()) {
                IntSet keywordMatches = null;
                while (indexIterator.hasNext()) {
                    IntSet match = indexIterator.next();
                    if (keywordMatches == null) {
                        if (startPos == 0 && endPos == searchStrLength && !indexIterator.hasNext()) {
                            return match;
                        }
                        keywordMatches = new IntSet();
                    }
                    keywordMatches.addAll(match);
                }
                if (searchMatches == null) {
                    searchMatches = keywordMatches;
                } else {
                    searchMatches.retainAll(keywordMatches);
                    if (searchMatches.size() == 0) {
                        return null;
                    }
                }
            } else {
                return null;
            }
            startPos = endPos;
        }
        return searchMatches;
    }

    private List<ShareFile> provideResultData(List<ShareFile> urnMatches, IntSet keywordMatches, byte[] originIpAddress) {
        int count = 0;
        if (urnMatches != null) {
            count += urnMatches.size();
        }
        if (keywordMatches != null) {
            count += keywordMatches.size();
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        PhexSecurityManager securityService = this.servent.getSecurityService();
        ArrayList<ShareFile> resultList = new ArrayList<ShareFile>();
        int maxResults = LibraryPrefs.MaxResultsPerQuery.get();
        int resultListSize = 0;
        if (urnMatches != null && urnMatches.size() > 0) {
            for (ShareFile shareFile : urnMatches) {
                try {
                    SharedDirectory dir = this.sharedFilesService.getSharedDirectory(shareFile.getSystemFile().getParentFile());
                    if (!securityService.isEligibleIpAddress(originIpAddress, dir)) {
                        continue;
                    }
                }
                catch (Exception exp) {
                    NLogger.warn(QueryResultSearchEngine.class, (Object)exp, (Throwable)exp);
                }
                shareFile.incSearchCount();
                resultList.add(shareFile);
                if (++resultListSize < maxResults) continue;
                break;
            }
        }
        if (keywordMatches != null && keywordMatches.size() > 0 && resultListSize < maxResults) {
            IntSet.IntSetIterator iterator = keywordMatches.iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                ShareFile shareFile = this.sharedFilesService.getFileByIndex(index);
                if (shareFile == null) continue;
                try {
                    SharedDirectory dir = this.sharedFilesService.getSharedDirectory(shareFile.getSystemFile().getParentFile());
                    if (!securityService.isEligibleIpAddress(originIpAddress, dir)) {
                        continue;
                    }
                }
                catch (Exception exp) {
                    NLogger.warn(QueryResultSearchEngine.class, (Object)exp, (Throwable)exp);
                }
                shareFile.incSearchCount();
                resultList.add(shareFile);
                if (++resultListSize < maxResults) continue;
                break;
            }
        }
        assert (resultList.size() <= maxResults);
        return resultList;
    }
}

