/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.Iterator;
import phex.common.AltLocContainer;
import phex.common.FileHandlingException;
import phex.common.URN;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.download.swarming.SWDownloadFile;
import phex.http.HTTPRangeSet;
import phex.http.Range;
import phex.share.ShareFile;
import phex.xml.sax.share.DSharedFile;

public class PartialShareFile
extends ShareFile {
    private SWDownloadFile swDownloadFile;
    private HTTPRangeSet availableRangeSet;
    private File partialFile;
    private long fileStartOffset;

    public PartialShareFile(SWDownloadFile downloadFile) {
        super(downloadFile.getTotalDataSize());
        this.swDownloadFile = downloadFile;
        this.availableRangeSet = this.swDownloadFile.createAvailableRangeSet();
    }

    public URN getURN() {
        return this.swDownloadFile.getFileURN();
    }

    public String getSha1() {
        URN urn = this.swDownloadFile.getFileURN();
        if (urn == null || !urn.isSha1Nid()) {
            return "";
        }
        return urn.getNamespaceSpecificString();
    }

    public String getFileName() {
        return this.swDownloadFile.getFileName();
    }

    public AltLocContainer getAltLocContainer() {
        return this.swDownloadFile.getGoodAltLocContainer();
    }

    public Range.RangeAvailability getRangeAvailableStatus(Range requestedRange) {
        long fileSize = this.getFileSize();
        Iterator<Range> iterator = this.availableRangeSet.getIterator();
        while (iterator.hasNext()) {
            Range availableRange = iterator.next();
            if (!availableRange.isRangeSatisfiable(requestedRange, fileSize)) continue;
            return Range.RangeAvailability.RANGE_AVAILABLE;
        }
        long startOffset = requestedRange.getStartOffset(fileSize);
        if (startOffset < 0L || startOffset >= fileSize) {
            return Range.RangeAvailability.RANGE_NOT_SATISFIABLE;
        }
        return Range.RangeAvailability.RANGE_NOT_AVAILABLE;
    }

    public File getSystemFile() {
        return this.partialFile;
    }

    public String toString() {
        return super.toString() + " - Backed SWDownloadFile: " + this.swDownloadFile.toString();
    }

    public void findFittingPartForRange(Range requestedRange) {
        Iterator<Range> iterator = this.availableRangeSet.getIterator();
        long fileSize = this.getFileSize();
        while (iterator.hasNext()) {
            Range availableRange = iterator.next();
            if (!availableRange.isRangeSatisfiable(requestedRange, fileSize)) continue;
            try {
                this.partialFile = this.swDownloadFile.getIncompleteDownloadFile().getFile();
                long startOffset = requestedRange.getStartOffset(fileSize);
                long endOffset = Math.min(requestedRange.getEndOffset(fileSize), availableRange.getEndOffset(fileSize));
                requestedRange.update(startOffset, endOffset);
                this.fileStartOffset = startOffset;
                return;
            }
            catch (ManagedFileException exp) {
                NLogger.error(PartialShareFile.class, (Object)exp);
            }
            catch (FileHandlingException exp) {
                NLogger.error(PartialShareFile.class, (Object)exp);
            }
        }
    }

    public long getFileStartOffset() {
        return this.fileStartOffset;
    }

    public String buildXAvailableRangesString() {
        return this.availableRangeSet.buildXAvailableRangesString();
    }

    public int getFileIndex() {
        throw new UnsupportedOperationException();
    }

    public void setFileIndex(int index) {
        throw new UnsupportedOperationException();
    }

    public Integer getSearchCountObject() {
        throw new UnsupportedOperationException();
    }

    public int getSearchCount() {
        throw new UnsupportedOperationException();
    }

    public void incSearchCount() {
        throw new UnsupportedOperationException();
    }

    public Integer getUploadCountObject() {
        throw new UnsupportedOperationException();
    }

    public int getUploadCount() {
        throw new UnsupportedOperationException();
    }

    public void incUploadCount() {
    }

    public char[] getSearchCompareTerm() {
        throw new UnsupportedOperationException();
    }

    public void updateFromCache(DSharedFile dFile) {
        throw new UnsupportedOperationException();
    }

    public void calculateURN() {
        throw new UnsupportedOperationException();
    }
}

