/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.URN;
import phex.common.log.NLogger;
import phex.download.RemoteFile;
import phex.msg.InvalidMessageException;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.DynamicQueryEngine;
import phex.query.SearchDataEvent;
import phex.query.SearchResultHolder;
import phex.security.AccessType;
import phex.servent.Servent;

public abstract class Search {
    protected final Servent servent;
    protected long startTime;
    protected DynamicQueryEngine queryEngine;
    protected QueryMsg queryMsg;
    protected boolean isSearching;
    protected SearchResultHolder searchResultHolder;

    protected Search(Servent servent) {
        this.servent = servent;
        this.isSearching = false;
        this.searchResultHolder = new SearchResultHolder();
    }

    public int getQueryHitCount() {
        return this.searchResultHolder.getQueryHitCount();
    }

    public int getProgress() {
        if (!this.isSearching) {
            return 100;
        }
        if (this.queryEngine != null) {
            return this.queryEngine.getProgress();
        }
        long currentTime = System.currentTimeMillis();
        int timeProgress = (int)(100.0 - (double)(this.startTime + 300000L - currentTime) / 300000.0 * 100.0);
        return Math.min(timeProgress, 100);
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public void checkForSearchTimeout(long currentTime) {
        if (this.queryEngine != null) {
            if (this.queryEngine.isQueryFinished()) {
                this.stopSearching();
            }
        } else if (currentTime > this.startTime + 300000L) {
            this.stopSearching();
        }
    }

    public void startSearching() {
        this.startTime = System.currentTimeMillis();
        this.queryMsg.setCreationTime(this.startTime);
        NLogger.debug(Search.class, (Object)("Sending Query " + this.queryMsg));
        this.queryEngine = this.servent.getQueryService().sendMyQuery(this.queryMsg);
        this.isSearching = true;
        this.fireSearchStarted();
    }

    public void stopSearching() {
        if (!this.isSearching) {
            return;
        }
        this.isSearching = false;
        if (this.queryEngine != null) {
            this.queryEngine.stopQuery();
        }
        this.fireSearchStoped();
    }

    protected boolean isResponseRecordValid(QueryResponseRecord record) {
        URN urn = record.getURN();
        if (urn != null && this.servent.getSecurityService().controlUrnAccess(urn) != AccessType.ACCESS_GRANTED) {
            NLogger.debug(Search.class, (Object)("Record contains blocked URN: " + urn.getAsString()));
            return false;
        }
        return true;
    }

    public abstract void processResponse(QueryResponseMsg var1) throws InvalidMessageException;

    protected void fireSearchStarted() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchStoped() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 4);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    public void fireSearchChanged() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchHitsAdded(RemoteFile[] newHits) {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 1, newHits);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchChangeEvent(SearchDataEvent searchChangeEvent) {
        this.servent.getEventService().publish("phex:search/data", searchChangeEvent);
    }
}

