/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import phex.common.collections.SortedProperties;
import phex.common.log.NLogger;
import phex.prefs.api.PreferencesFactory;
import phex.prefs.api.Setting;
import phex.utils.FileUtils;
import phex.utils.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private Map<String, Setting<?>> settingMap;
    private File prefFile;
    private Properties valueProperties;
    private boolean isSaveRequired;

    public Preferences(File file) {
        this.prefFile = file;
        this.settingMap = new HashMap();
    }

    protected String getLoadedProperty(String name) {
        return this.valueProperties.getProperty(name);
    }

    protected List<String> getPrefixedPropertyNames(String prefix) {
        ArrayList<String> found = new ArrayList<String>();
        Set<Object> keys = this.valueProperties.keySet();
        for (Object keyObj : keys) {
            String key = (String)keyObj;
            if (!key.startsWith(prefix)) continue;
            found.add(key);
        }
        return found;
    }

    protected void registerSetting(String name, Setting<?> setting) {
        this.settingMap.put(name, setting);
    }

    public synchronized void saveRequiredNotify() {
        this.isSaveRequired = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() {
        Properties loadProperties = new Properties();
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(this.prefFile));
            loadProperties.load(inStream);
        }
        catch (IOException exp) {
            try {
                IOUtil.closeQuietly(inStream);
                if (!(exp instanceof FileNotFoundException)) {
                    NLogger.error(Preferences.class, (Object)exp);
                }
                File bakFile = new File(this.prefFile.getParentFile(), this.prefFile.getName() + ".bak");
                try {
                    inStream = new BufferedInputStream(new FileInputStream(bakFile));
                    loadProperties.load(inStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException exp2) {
                    NLogger.error(Preferences.class, (Object)exp);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(inStream);
                throw throwable;
            }
            IOUtil.closeQuietly(inStream);
        }
        IOUtil.closeQuietly(inStream);
        this.valueProperties = loadProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        if (!this.isSaveRequired) {
            NLogger.debug(Preferences.class, (Object)"No saving of preferences required.");
            return;
        }
        NLogger.debug(Preferences.class, (Object)("Saving preferences to: " + this.prefFile.getAbsolutePath()));
        SortedProperties saveProperties = new SortedProperties();
        for (Setting<?> setting : this.settingMap.values()) {
            if (setting.isDefault() && !setting.isAlwaysSaved()) continue;
            PreferencesFactory.serializeSetting(setting, saveProperties);
        }
        File bakFile = new File(this.prefFile.getParentFile(), this.prefFile.getName() + ".bak");
        try {
            if (this.prefFile.exists()) {
                FileUtils.copyFile(this.prefFile, bakFile);
            }
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(this.prefFile));
                saveProperties.store(os, "Phex Preferences");
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(os);
                throw throwable;
            }
            IOUtil.closeQuietly(os);
        }
        catch (IOException exp) {
            NLogger.error(Preferences.class, (Object)exp, (Throwable)exp);
        }
    }
}

