/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.log.NLogger;
import phex.connection.ConnectionStatusEvent;
import phex.event.ChangeEvent;
import phex.host.HostFetchingStrategy;
import phex.host.NetworkHostsContainer;
import phex.servent.OnlineStatus;
import phex.servent.Servent;

public class OnlineObserver {
    private int failedConnections;
    private final Servent servent;
    private final HostFetchingStrategy fetchingStrategy;

    public OnlineObserver(Servent servent, HostFetchingStrategy fetchingStrategy) {
        this.fetchingStrategy = fetchingStrategy;
        this.servent = servent;
        this.failedConnections = 0;
        servent.getEventService().processAnnotations(this);
    }

    @EventTopicSubscriber(topic="phex:net/connectionStatus")
    public void onConnectionStatusEvent(String topic, ConnectionStatusEvent event) {
        if (event.getStatus() == ConnectionStatusEvent.Status.CONNECTION_FAILED) {
            NetworkHostsContainer networkHostsContainer = this.servent.getHostService().getNetworkHostsContainer();
            if (networkHostsContainer.getTotalConnectionCount() > 0) {
                this.failedConnections = 0;
                return;
            }
            ++this.failedConnections;
            if (NLogger.isDebugEnabled(OnlineObserver.class) && this.failedConnections % 3 == 0) {
                NLogger.debug(OnlineObserver.class, (Object)("Observed " + this.failedConnections + " failed connections."));
            }
            if (this.failedConnections % 6 == 0) {
                NLogger.info(OnlineObserver.class, (Object)"Started fetching new hosts due to increasing failed connections");
                this.fetchingStrategy.fetchNewHosts(HostFetchingStrategy.FetchingReason.UpdateHosts);
            }
        } else {
            this.failedConnections = 0;
        }
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, ChangeEvent event) {
        OnlineStatus oldStatus = (OnlineStatus)((Object)event.getOldValue());
        OnlineStatus newStatus = (OnlineStatus)((Object)event.getNewValue());
        if (oldStatus == OnlineStatus.OFFLINE && newStatus != OnlineStatus.OFFLINE) {
            this.failedConnections = 0;
        }
    }
}

