/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.connection.IncomingConnectionDispatcher;
import phex.host.NetworkHostsContainer;
import phex.net.Server;
import phex.net.repres.PresentationManager;
import phex.net.repres.def.DefaultSocketFacade;
import phex.prefs.core.NetworkPrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityException;
import phex.servent.Servent;

public class NIOServer
extends Server {
    protected ServerSocket serverSocket;
    private ServerSocketChannel listeningChannel;
    private Selector selector;

    public NIOServer(Servent servent) {
        super(servent);
        Environment.getInstance().scheduleTimerTask(new Server.FirewallCheckTimer(this, servent.getHostService().getNetworkHostsContainer(), servent.getMessageService(), servent.getEventService()), 300000L, 300000L);
    }

    public int getListeningLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return NetworkPrefs.ListeningPort.get();
    }

    public IpAddress resolveLocalHostIP() {
        byte[] ip = null;
        InetAddress addr = this.serverSocket.getInetAddress();
        ip = addr.getAddress();
        IpAddress ipAddress = ip[0] == 0 && ip[1] == 0 && ip[2] == 0 && ip[3] == 0 ? IpAddress.LOCAL_HOST_IP : new IpAddress(ip);
        return ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (NLogger.isDebugEnabled(NIOServer.class)) {
            NLogger.debug(NIOServer.class, (Object)("Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort()));
        }
        try {
            while (this.selector.isOpen()) {
                this.selector.select(10000L);
                if (this.selector.isOpen()) {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selKey = iterator.next();
                        iterator.remove();
                        if (!selKey.isAcceptable()) continue;
                        ServerSocketChannel ssChannel = (ServerSocketChannel)selKey.channel();
                        try {
                            SocketChannel socketChannel = ssChannel.accept();
                            this.handleIncomingClientChannel(socketChannel);
                        }
                        catch (PhexSecurityException exp) {
                            NLogger.debug(NIOServer.class, (Object)exp);
                        }
                        catch (IOException exp) {
                            NLogger.debug(NIOServer.class, (Object)exp, (Throwable)exp);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exp) {
            NLogger.error(NIOServer.class, (Object)exp, (Throwable)exp);
        }
        this.isRunning = false;
        NLogger.debug(NIOServer.class, (Object)"Listener stopped.");
        PresentationManager presentationMgr = PresentationManager.getInstance();
        DestAddress newAddress = presentationMgr.createHostAddress(IpAddress.LOCAL_HOST_IP, (int)NetworkPrefs.ListeningPort.get());
        this.localAddress.updateLocalAddress(newAddress);
        NIOServer nIOServer = this;
        synchronized (nIOServer) {
            this.notifyAll();
        }
    }

    private void handleIncomingClientChannel(SocketChannel socketChannel) throws IOException, PhexSecurityException {
        socketChannel.configureBlocking(true);
        Socket clientSocket = socketChannel.socket();
        clientSocket.setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
        IpAddress ip = new IpAddress(clientSocket.getInetAddress().getAddress());
        PresentationManager presentationMgr = PresentationManager.getInstance();
        DestAddress address = presentationMgr.createHostAddress(ip, clientSocket.getPort());
        NetworkHostsContainer netHostsContainer = this.servent.getHostService().getNetworkHostsContainer();
        if (!netHostsContainer.isConnectedToHost(address) && !address.getIpAddress().isSiteLocalIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        AccessType access = this.servent.getSecurityService().controlHostAddressAccess(address);
        switch (access) {
            case ACCESS_DENIED: 
            case ACCESS_STRONGLY_DENIED: {
                throw new PhexSecurityException("Host access denied: " + clientSocket.getInetAddress().getHostAddress());
            }
        }
        NLogger.debug(NIOServer.class, (Object)("Accepted incoming connection from: " + address.getFullHostName()));
        DefaultSocketFacade clientFacade = new DefaultSocketFacade(clientSocket);
        IncomingConnectionDispatcher dispatcher = new IncomingConnectionDispatcher(clientFacade, this.servent);
        Environment.getInstance().executeOnThreadPool(dispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind(int initialPort) throws IOException {
        boolean error;
        assert (this.listeningChannel == null);
        this.listeningChannel = ServerSocketChannel.open();
        this.serverSocket = this.listeningChannel.socket();
        this.listeningChannel.configureBlocking(false);
        int tries = 0;
        do {
            error = false;
            try {
                NLogger.debug(NIOServer.class, (Object)("Binding to port " + initialPort));
                this.serverSocket.bind(new InetSocketAddress(initialPort));
            }
            catch (BindException exp) {
                NLogger.debug(NIOServer.class, (Object)("Binding failed to port " + initialPort));
                if (tries > 10) {
                    throw exp;
                }
                error = true;
                ++initialPort;
                ++tries;
            }
        } while (error);
        IpAddress hostIP = this.resolveLocalHostIP();
        initialPort = this.serverSocket.getLocalPort();
        DestAddress newAddress = PresentationManager.getInstance().createHostAddress(hostIP, initialPort);
        this.localAddress.updateLocalAddress(newAddress);
        this.selector = Selector.open();
        this.listeningChannel.register(this.selector, 16);
    }

    protected void closeServer() {
        try {
            this.listeningChannel.close();
            SelectionKey key = this.listeningChannel.keyFor(this.selector);
            key.cancel();
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.listeningChannel = null;
    }
}

