/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import java.net.Socket;
import junit.framework.TestCase;
import phex.common.address.DefaultDestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.host.Host;
import phex.msg.GUID;
import phex.msghandling.MessageRouting;
import phex.net.connection.Connection;
import phex.net.repres.def.DefaultSocketFacade;
import phex.utils.QueryGUIDRoutingPair;

public class MessageRoutingTest
extends TestCase {
    private MessageRouting messageRouting;

    public MessageRoutingTest(String string) {
        super(string);
    }

    protected void setUp() {
        this.messageRouting = new MessageRouting();
    }

    public void testAddToPushRoutingTable() throws Exception {
        GUID gUID = new GUID();
        Host host = new Host(new DefaultDestAddress("1.1.1.1", 1111));
        host.setConnection(new Connection(new DummySocket(), new BandwidthController("JUnitText", Long.MAX_VALUE)));
        this.messageRouting.addToPushRoutingTable(gUID, host);
        Host host2 = this.messageRouting.getPushRouting(gUID);
        MessageRoutingTest.assertEquals((Object)host, (Object)host2);
    }

    public void testCheckAndAddToPingRoutingTable() throws Exception {
        GUID gUID = new GUID();
        Host host = new Host(new DefaultDestAddress("2.2.2.2", 2222));
        host.setConnection(new Connection(new DummySocket(), new BandwidthController("JUnitText", Long.MAX_VALUE)));
        boolean bl = this.messageRouting.checkAndAddToPingRoutingTable(gUID, host);
        MessageRoutingTest.assertEquals((boolean)true, (boolean)bl);
        bl = this.messageRouting.checkAndAddToPingRoutingTable(gUID, host);
        MessageRoutingTest.assertEquals((boolean)false, (boolean)bl);
        Host host2 = this.messageRouting.getPingRouting(gUID);
        MessageRoutingTest.assertEquals((Object)host, (Object)host2);
    }

    public void testCheckAndAddToQueryRoutingTable() throws Exception {
        GUID gUID = new GUID();
        Host host = new Host(new DefaultDestAddress("3.3.3.3", 3333));
        host.setConnection(new Connection(new DummySocket(), new BandwidthController("JUnitText", Long.MAX_VALUE)));
        boolean bl = this.messageRouting.checkAndAddToQueryRoutingTable(gUID, host);
        MessageRoutingTest.assertEquals((boolean)true, (boolean)bl);
        bl = this.messageRouting.checkAndAddToQueryRoutingTable(gUID, host);
        MessageRoutingTest.assertEquals((boolean)false, (boolean)bl);
        QueryGUIDRoutingPair queryGUIDRoutingPair = this.messageRouting.getQueryRouting(gUID, 0);
        MessageRoutingTest.assertEquals((Object)host, (Object)queryGUIDRoutingPair.getHost());
    }

    private class DummySocket
    extends DefaultSocketFacade {
        DummySocket() {
            super(new Socket());
        }
    }
}

